package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SelectCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SelectCruiseUIModel, SelectCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CRUISE_COMBOBOX_ENABLED = "cruiseCombobox.enabled";
    public static final String BINDING_CRUISE_COMBOBOX_SELECTED_ITEM = "cruiseCombobox.selectedItem";
    public static final String BINDING_CRUISE_LABEL_ICON = "cruiseLabel.icon";
    public static final String BINDING_EDIT_CATCHES_BUTTON_ENABLED = "editCatchesButton.enabled";
    public static final String BINDING_EDIT_CRUISE_COMBO_BOX_ENABLED = "editCruiseComboBox.enabled";
    public static final String BINDING_EDIT_PROGRAM_BUTTON_ENABLED = "editProgramButton.enabled";
    public static final String BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED = "editProtocolComboBox.enabled";
    public static final String BINDING_NEW_CRUISE_BUTTON_ENABLED = "newCruiseButton.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_ENABLED = "programCombobox.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM = "programCombobox.selectedItem";
    public static final String BINDING_PROTOCOL_COMBOBOX_ENABLED = "protocolCombobox.enabled";
    public static final String BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM = "protocolCombobox.selectedItem";
    public static final String BINDING_VALIDATE_CATCHES_BUTTON_ENABLED = "validateCatchesButton.enabled";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SelectCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cloneProtocolButton;
    @ValidatorField( validatorId = "validator",  propertyName = "cruise",  editorName = "cruiseCombobox")
    protected BeanFilterableComboBox<Cruise> cruiseCombobox;
    protected JLabel cruiseLabel;
    protected JButton deleteProtocolButton;
    protected JButton editCatchesButton;
    protected JButton editCruiseButton;
    protected JComboBox editCruiseComboBox;
    protected JButton editProgramButton;
    protected JButton editProtocolButton;
    protected JComboBox editProtocolComboBox;
    protected JButton exportCruiseForSumatraButton;
    protected JButton exportProtocolButton;
    protected final SelectCruiseUIHandler handler = createHandler();
    protected JButton importProtocolButton;
    protected SelectCruiseUIModel model;
    protected JButton newCruiseButton;
    protected JButton newProgramButton;
    protected JButton newProtocolButton;
    protected JComboBox newProtocolComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programCombobox")
    protected BeanFilterableComboBox<Program> programCombobox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "protocol",  editorName = "protocolCombobox")
    protected BeanFilterableComboBox<TuttiProtocol> protocolCombobox;
    protected JLabel protocolLabel;
    protected SelectCruiseUI selectCruiseTopPanel = this;
    protected JButton sendCruiseReportButton;
    protected JButton speciesToConfirmReportForCruiseButton;
    protected JButton validateCatchesButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<SelectCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCruiseUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
                uiContext = TuttiUIUtil.getApplicationContext(parentUI);
            $initialize();
    }

    public SelectCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI() {
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloneProtocolButton() {
        return cloneProtocolButton;
    }

    public BeanFilterableComboBox<Cruise> getCruiseCombobox() {
        return cruiseCombobox;
    }

    public JLabel getCruiseLabel() {
        return cruiseLabel;
    }

    public JButton getDeleteProtocolButton() {
        return deleteProtocolButton;
    }

    public JButton getEditCatchesButton() {
        return editCatchesButton;
    }

    public JButton getEditCruiseButton() {
        return editCruiseButton;
    }

    public JComboBox getEditCruiseComboBox() {
        return editCruiseComboBox;
    }

    public JButton getEditProgramButton() {
        return editProgramButton;
    }

    public JButton getEditProtocolButton() {
        return editProtocolButton;
    }

    public JComboBox getEditProtocolComboBox() {
        return editProtocolComboBox;
    }

    public JButton getExportCruiseForSumatraButton() {
        return exportCruiseForSumatraButton;
    }

    public JButton getExportProtocolButton() {
        return exportProtocolButton;
    }

    public SelectCruiseUIHandler getHandler() {
        return handler;
    }

    public JButton getImportProtocolButton() {
        return importProtocolButton;
    }

    public SelectCruiseUIModel getModel() {
        return model;
    }

    public JButton getNewCruiseButton() {
        return newCruiseButton;
    }

    public JButton getNewProgramButton() {
        return newProgramButton;
    }

    public JButton getNewProtocolButton() {
        return newProtocolButton;
    }

    public JComboBox getNewProtocolComboBox() {
        return newProtocolComboBox;
    }

    public BeanFilterableComboBox<Program> getProgramCombobox() {
        return programCombobox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanFilterableComboBox<TuttiProtocol> getProtocolCombobox() {
        return protocolCombobox;
    }

    public JLabel getProtocolLabel() {
        return protocolLabel;
    }

    public JButton getSendCruiseReportButton() {
        return sendCruiseReportButton;
    }

    public JButton getSpeciesToConfirmReportForCruiseButton() {
        return speciesToConfirmReportForCruiseButton;
    }

    public JButton getValidateCatchesButton() {
        return validateCatchesButton;
    }

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return validator;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(editCruiseButton);
        add(sendCruiseReportButton);
        add(exportCruiseForSumatraButton);
        add(speciesToConfirmReportForCruiseButton);
        add(newProtocolButton);
        add(importProtocolButton);
        add(editProtocolButton);
        add(cloneProtocolButton);
        add(exportProtocolButton);
        add(deleteProtocolButton);
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.selectCruise.help"));
    }

    protected void createCloneProtocolButton() {
        $objectMap.put("cloneProtocolButton", cloneProtocolButton = new JButton());
        
        cloneProtocolButton.setName("cloneProtocolButton");
        cloneProtocolButton.setText(t("tutti.selectCruise.action.cloneProtocol"));
        cloneProtocolButton.setToolTipText(t("tutti.selectCruise.action.cloneProtocol.tip"));
        cloneProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.CloneProtocolAction.class);
        cloneProtocolButton.putClientProperty("help", "tutti.selectCruise.action.cloneProtocol.help");
    }

    protected void createCruiseCombobox() {
        $objectMap.put("cruiseCombobox", cruiseCombobox = new BeanFilterableComboBox<Cruise>(this));
        
        cruiseCombobox.setName("cruiseCombobox");
        cruiseCombobox.setProperty("cruise");
        cruiseCombobox.setShowReset(true);
        cruiseCombobox.putClientProperty("help", "tutti.selectCruise.field.cruise.help");
        cruiseCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.cruise"));
    }

    protected void createCruiseLabel() {
        $objectMap.put("cruiseLabel", cruiseLabel = new JLabel());
        
        cruiseLabel.setName("cruiseLabel");
        cruiseLabel.setText(t("tutti.selectCruise.field.cruise"));
        cruiseLabel.setToolTipText(t("tutti.selectCruise.field.cruise.tip"));
        cruiseLabel.putClientProperty("help", "tutti.selectCruise.field.cruise.help");
    }

    protected void createDeleteProtocolButton() {
        $objectMap.put("deleteProtocolButton", deleteProtocolButton = new JButton());
        
        deleteProtocolButton.setName("deleteProtocolButton");
        deleteProtocolButton.setText(t("tutti.selectCruise.action.deleteProtocol"));
        deleteProtocolButton.setToolTipText(t("tutti.selectCruise.action.deleteProtocol.tip"));
        deleteProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.DeleteProtocolAction.class);
        deleteProtocolButton.putClientProperty("help", "tutti.selectCruise.action.deleteProtocol.help");
    }

    protected void createEditCatchesButton() {
        $objectMap.put("editCatchesButton", editCatchesButton = new JButton());
        
        editCatchesButton.setName("editCatchesButton");
        editCatchesButton.setText(t("tutti.selectCruise.action.editCatches"));
        editCatchesButton.setToolTipText(t("tutti.selectCruise.action.editCatches.tip"));
        editCatchesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.EditCatchesAction.class);
        editCatchesButton.putClientProperty("help", "tutti.selectCruise.action.editCatches.help");
    }

    protected void createEditCruiseButton() {
        $objectMap.put("editCruiseButton", editCruiseButton = new JButton());
        
        editCruiseButton.setName("editCruiseButton");
        editCruiseButton.setText(t("tutti.selectCruise.action.editCruise"));
        editCruiseButton.setToolTipText(t("tutti.selectCruise.action.editCruise.tip"));
        editCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.EditCruiseAction.class);
        editCruiseButton.putClientProperty("help", "tutti.selectCruise.action.editCruise.help");
    }

    protected void createEditCruiseComboBox() {
        $objectMap.put("editCruiseComboBox", editCruiseComboBox = new JComboBox());
        
        editCruiseComboBox.setName("editCruiseComboBox");
        editCruiseComboBox.putClientProperty("comboboxActions", Arrays.asList(editCruiseButton, sendCruiseReportButton, exportCruiseForSumatraButton, speciesToConfirmReportForCruiseButton));
    }

    protected void createEditProgramButton() {
        $objectMap.put("editProgramButton", editProgramButton = new JButton());
        
        editProgramButton.setName("editProgramButton");
        editProgramButton.setText(t("tutti.selectCruise.action.editProgram"));
        editProgramButton.setToolTipText(t("tutti.selectCruise.action.editProgram.tip"));
        editProgramButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.EditProgramAction.class);
        editProgramButton.putClientProperty("help", "tutti.selectCruise.action.editProgram.help");
    }

    protected void createEditProtocolButton() {
        $objectMap.put("editProtocolButton", editProtocolButton = new JButton());
        
        editProtocolButton.setName("editProtocolButton");
        editProtocolButton.setText(t("tutti.selectCruise.action.editProtocol"));
        editProtocolButton.setToolTipText(t("tutti.selectCruise.action.editProtocol.tip"));
        editProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.EditProtocolAction.class);
        editProtocolButton.putClientProperty("help", "tutti.selectCruise.action.editProtocol.help");
    }

    protected void createEditProtocolComboBox() {
        $objectMap.put("editProtocolComboBox", editProtocolComboBox = new JComboBox());
        
        editProtocolComboBox.setName("editProtocolComboBox");
        editProtocolComboBox.putClientProperty("comboboxActions", Arrays.asList(editProtocolButton, cloneProtocolButton, exportProtocolButton, deleteProtocolButton));
    }

    protected void createExportCruiseForSumatraButton() {
        $objectMap.put("exportCruiseForSumatraButton", exportCruiseForSumatraButton = new JButton());
        
        exportCruiseForSumatraButton.setName("exportCruiseForSumatraButton");
        exportCruiseForSumatraButton.setText(t("tutti.selectCruise.action.exportCruiseForSumatra"));
        exportCruiseForSumatraButton.setToolTipText(t("tutti.selectCruise.action.exportCruiseForSumatra.tip"));
        exportCruiseForSumatraButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.ExportCruiseForSumatraAction.class);
        exportCruiseForSumatraButton.putClientProperty("help", "tutti.selectCruise.action.exportCruiseForSumatra.help");
    }

    protected void createExportProtocolButton() {
        $objectMap.put("exportProtocolButton", exportProtocolButton = new JButton());
        
        exportProtocolButton.setName("exportProtocolButton");
        exportProtocolButton.setText(t("tutti.selectCruise.action.exportProtocol"));
        exportProtocolButton.setToolTipText(t("tutti.selectCruise.action.exportProtocol.tip"));
        exportProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.ExportProtocolAction.class);
        exportProtocolButton.putClientProperty("help", "tutti.selectCruise.action.exportProtocol.help");
    }

    protected SelectCruiseUIHandler createHandler() {
        return new SelectCruiseUIHandler();
    }

    protected void createImportProtocolButton() {
        $objectMap.put("importProtocolButton", importProtocolButton = new JButton());
        
        importProtocolButton.setName("importProtocolButton");
        importProtocolButton.setText(t("tutti.selectCruise.action.importProtocol"));
        importProtocolButton.setToolTipText(t("tutti.selectCruise.action.importProtocol.tip"));
        importProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.ImportProtocolAction.class);
        importProtocolButton.putClientProperty("help", "tutti.selectCruise.action.importProtocol.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCruiseUIModel.class));
    }

    protected void createNewCruiseButton() {
        $objectMap.put("newCruiseButton", newCruiseButton = new JButton());
        
        newCruiseButton.setName("newCruiseButton");
        newCruiseButton.setText(t("tutti.selectCruise.action.newCruise"));
        newCruiseButton.setToolTipText(t("tutti.selectCruise.action.newCruise.tip"));
        newCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.NewCruiseAction.class);
        newCruiseButton.putClientProperty("help", "tutti.selectCruise.action.newCruise.help");
    }

    protected void createNewProgramButton() {
        $objectMap.put("newProgramButton", newProgramButton = new JButton());
        
        newProgramButton.setName("newProgramButton");
        newProgramButton.setText(t("tutti.selectCruise.action.newProgram"));
        newProgramButton.setToolTipText(t("tutti.selectCruise.action.newProgram.tip"));
        newProgramButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.NewProgramAction.class);
        newProgramButton.putClientProperty("help", "tutti.selectCruise.action.newProgram.help");
    }

    protected void createNewProtocolButton() {
        $objectMap.put("newProtocolButton", newProtocolButton = new JButton());
        
        newProtocolButton.setName("newProtocolButton");
        newProtocolButton.setText(t("tutti.selectCruise.action.newProtocol"));
        newProtocolButton.setToolTipText(t("tutti.selectCruise.action.newProtocol.tip"));
        newProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.NewProtocolAction.class);
        newProtocolButton.putClientProperty("help", "tutti.selectCruise.action.newProtocol.help");
    }

    protected void createNewProtocolComboBox() {
        $objectMap.put("newProtocolComboBox", newProtocolComboBox = new JComboBox());
        
        newProtocolComboBox.setName("newProtocolComboBox");
        newProtocolComboBox.putClientProperty("comboboxActions", Arrays.asList(newProtocolButton, importProtocolButton));
    }

    protected void createProgramCombobox() {
        $objectMap.put("programCombobox", programCombobox = new BeanFilterableComboBox<Program>(this));
        
        programCombobox.setName("programCombobox");
        programCombobox.setProperty("program");
        programCombobox.setShowReset(true);
        programCombobox.putClientProperty("help", "tutti.selectCruise.field.program.help");
        programCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(t("tutti.selectCruise.field.program"));
        programLabel.setToolTipText(t("tutti.selectCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.selectCruise.field.program.help");
    }

    protected void createProtocolCombobox() {
        $objectMap.put("protocolCombobox", protocolCombobox = new BeanFilterableComboBox<TuttiProtocol>(this));
        
        protocolCombobox.setName("protocolCombobox");
        protocolCombobox.setProperty("protocol");
        protocolCombobox.setShowReset(true);
        protocolCombobox.putClientProperty("help", "tutti.selectCruise.field.protocol.help");
        protocolCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.protocol"));
    }

    protected void createProtocolLabel() {
        $objectMap.put("protocolLabel", protocolLabel = new JLabel());
        
        protocolLabel.setName("protocolLabel");
        protocolLabel.setText(t("tutti.selectCruise.field.protocol"));
        protocolLabel.setToolTipText(t("tutti.selectCruise.field.protocol.tip"));
        protocolLabel.putClientProperty("help", "tutti.selectCruise.field.protocol.help");
    }

    protected void createSendCruiseReportButton() {
        $objectMap.put("sendCruiseReportButton", sendCruiseReportButton = new JButton());
        
        sendCruiseReportButton.setName("sendCruiseReportButton");
        sendCruiseReportButton.setText(t("tutti.selectCruise.action.sendCruiseReport"));
        sendCruiseReportButton.setToolTipText(t("tutti.selectCruise.action.sendCruiseReport.tip"));
        sendCruiseReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.SendCruiseReportAction.class);
        sendCruiseReportButton.putClientProperty("help", "tutti.selectCruise.action.sendCruiseReport.help");
    }

    protected void createSpeciesToConfirmReportForCruiseButton() {
        $objectMap.put("speciesToConfirmReportForCruiseButton", speciesToConfirmReportForCruiseButton = new JButton());
        
        speciesToConfirmReportForCruiseButton.setName("speciesToConfirmReportForCruiseButton");
        speciesToConfirmReportForCruiseButton.setText(t("tutti.selectCruise.action.speciesToConfirmReportForCruise"));
        speciesToConfirmReportForCruiseButton.setToolTipText(t("tutti.selectCruise.action.speciesToConfirmReportForCruise.tip"));
        speciesToConfirmReportForCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.SpeciesToConfirmReportForCruiseAction.class);
        speciesToConfirmReportForCruiseButton.putClientProperty("help", "tutti.selectCruise.action.speciesToConfirmReportForCruise.help");
    }

    protected void createValidateCatchesButton() {
        $objectMap.put("validateCatchesButton", validateCatchesButton = new JButton());
        
        validateCatchesButton.setName("validateCatchesButton");
        validateCatchesButton.setText(t("tutti.selectCruise.action.validateCatches"));
        validateCatchesButton.setToolTipText(t("tutti.selectCruise.action.validateCatches.tip"));
        validateCatchesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.home.actions.ValidateCatchesAction.class);
        validateCatchesButton.putClientProperty("help", "tutti.selectCruise.action.validateCatches.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SelectCruiseUIModel.class, null));
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
        warningLabel.setText(t("tutti.selectCruise.warn.invalid.selected.data"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectCruiseTopPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.2, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(warningContainer, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(programLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programCombobox), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cruiseCombobox), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(protocolLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(protocolCombobox), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel4, new GridBagConstraints(0, 5, 3, 2, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel0, BorderLayout.CENTER);
        addChildrenToWarningContainer();
        // inline complete setup of $JPanel1
        $JPanel1.add(editProgramButton);
        $JPanel1.add(newProgramButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(editCruiseComboBox);
        $JPanel2.add(newCruiseButton);
        // inline complete setup of $JPanel3
        $JPanel3.add(editProtocolComboBox);
        $JPanel3.add(newProtocolComboBox);
        // inline complete setup of $JPanel4
        $JPanel4.add(editCatchesButton);
        $JPanel4.add(validateCatchesButton);
        $JPanel4.add($JLabel1);
        $JPanel4.add($JLabel2);
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 37 property setters
        programCombobox.setBeanType(Program.class);
        cruiseCombobox.setBeanType(Cruise.class);
        protocolCombobox.setBeanType(TuttiProtocol.class);
        editCruiseButton.setIcon(SwingUtil.createActionIcon("edit"));
        sendCruiseReportButton.setIcon(SwingUtil.createActionIcon("email"));
        exportCruiseForSumatraButton.setIcon(SwingUtil.createActionIcon("export"));
        speciesToConfirmReportForCruiseButton.setIcon(SwingUtil.createActionIcon("report"));
        newProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        importProtocolButton.setIcon(SwingUtil.createActionIcon("import"));
        editProtocolButton.setIcon(SwingUtil.createActionIcon("edit"));
        cloneProtocolButton.setIcon(SwingUtil.createActionIcon("copy"));
        exportProtocolButton.setIcon(SwingUtil.createActionIcon("export"));
        deleteProtocolButton.setIcon(SwingUtil.createActionIcon("delete"));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        programLabel.setIcon(SwingUtil.createActionIcon("program"));
        programCombobox.setBean(model);
        editProgramButton.setIcon(SwingUtil.createActionIcon("edit"));
        newProgramButton.setIcon(SwingUtil.createActionIcon("add"));
        cruiseLabel.setLabelFor(cruiseCombobox);
        cruiseCombobox.setBean(model);
        newCruiseButton.setIcon(SwingUtil.createActionIcon("add"));
        protocolLabel.setLabelFor(protocolCombobox);
        protocolLabel.setIcon(SwingUtil.createActionIcon("protocol"));
        protocolCombobox.setBean(model);
        editCatchesButton.setIcon(SwingUtil.createActionIcon("edit"));
        editCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectCruise.action.editCatches.mnemonic"),'Z'));
        validateCatchesButton.setIcon(SwingUtil.createActionIcon("validate"));
        validateCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectCruise.action.validateCatches.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, selectCruiseTopPanel, "tutti.selectCruise.help");
        registerHelpId(_broker, editCruiseButton, "tutti.selectCruise.action.editCruise.help");
        registerHelpId(_broker, sendCruiseReportButton, "tutti.selectCruise.action.sendCruiseReport.help");
        registerHelpId(_broker, exportCruiseForSumatraButton, "tutti.selectCruise.action.exportCruiseForSumatra.help");
        registerHelpId(_broker, speciesToConfirmReportForCruiseButton, "tutti.selectCruise.action.speciesToConfirmReportForCruise.help");
        registerHelpId(_broker, newProtocolButton, "tutti.selectCruise.action.newProtocol.help");
        registerHelpId(_broker, importProtocolButton, "tutti.selectCruise.action.importProtocol.help");
        registerHelpId(_broker, editProtocolButton, "tutti.selectCruise.action.editProtocol.help");
        registerHelpId(_broker, cloneProtocolButton, "tutti.selectCruise.action.cloneProtocol.help");
        registerHelpId(_broker, exportProtocolButton, "tutti.selectCruise.action.exportProtocol.help");
        registerHelpId(_broker, deleteProtocolButton, "tutti.selectCruise.action.deleteProtocol.help");
        registerHelpId(_broker, programLabel, "tutti.selectCruise.field.program.help");
        registerHelpId(_broker, programCombobox, "tutti.selectCruise.field.program.help");
        registerHelpId(_broker, editProgramButton, "tutti.selectCruise.action.editProgram.help");
        registerHelpId(_broker, newProgramButton, "tutti.selectCruise.action.newProgram.help");
        registerHelpId(_broker, cruiseLabel, "tutti.selectCruise.field.cruise.help");
        registerHelpId(_broker, cruiseCombobox, "tutti.selectCruise.field.cruise.help");
        registerHelpId(_broker, newCruiseButton, "tutti.selectCruise.action.newCruise.help");
        registerHelpId(_broker, protocolLabel, "tutti.selectCruise.field.protocol.help");
        registerHelpId(_broker, protocolCombobox, "tutti.selectCruise.field.protocol.help");
        registerHelpId(_broker, editCatchesButton, "tutti.selectCruise.action.editCatches.help");
        registerHelpId(_broker, validateCatchesButton, "tutti.selectCruise.action.validateCatches.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("selectCruiseTopPanel", selectCruiseTopPanel);
        createModel();
        createValidator();
        createBroker();
        createEditCruiseButton();
        createSendCruiseReportButton();
        createExportCruiseForSumatraButton();
        createSpeciesToConfirmReportForCruiseButton();
        createNewProtocolButton();
        createImportProtocolButton();
        createEditProtocolButton();
        createCloneProtocolButton();
        createExportProtocolButton();
        createDeleteProtocolButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createWarningContainer();
        createWarningLabel();
        createProgramLabel();
        createProgramCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditProgramButton();
        createNewProgramButton();
        createCruiseLabel();
        createCruiseCombobox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createEditCruiseComboBox();
        createNewCruiseButton();
        createProtocolLabel();
        createProtocolCombobox();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createEditProtocolComboBox();
        createNewProtocolComboBox();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(2,0));
        createEditCatchesButton();
        createValidateCatchesButton();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        // inline creation of selectCruiseTopPanel
        setName("selectCruiseTopPanel");
        setLayout(new BorderLayout());
        selectCruiseTopPanel.putClientProperty("help", "tutti.selectCruise.help");
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (programCombobox != null) {
                    programCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (programCombobox != null) {
                    programCombobox.setEnabled(!programCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (programCombobox != null) {
                    programCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programCombobox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROGRAM_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProgramButton.setEnabled(model.getProgram() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_LABEL_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseLabel.setIcon(TuttiUIUtil.getCruiseIcon(model.getCruise()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.setEnabled(!cruiseCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setSelectedItem(model.getCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CRUISE_COMBO_BOX_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCruiseComboBox.setEnabled(model.isProgramFound() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CRUISE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCruiseButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.setEnabled(!protocolCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocol", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    protocolCombobox.setSelectedItem(model.getProtocol());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocol", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocolFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProtocolComboBox.setEnabled(model.isProtocolFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocolFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCatchesButton.setEnabled(model.isValid() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateCatchesButton.setEnabled(model.isValid() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
    }

}