/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.bidi;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.CallStatement;
import org.eclipse.birt.report.data.oda.jdbc.bidi.BidiResultSetMetaData;
import org.eclipse.birt.report.data.oda.jdbc.utils.BidiSQLTransform;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class BidiCallStatement
extends CallStatement {
    String contentBidiFormatStr;
    String metadataBidiFormatStr;

    public BidiCallStatement(Connection connection, Properties connProperties) throws OdaException {
        super(connection);
        this.contentBidiFormatStr = connProperties.getProperty("contentBidiFormatStr");
        this.metadataBidiFormatStr = connProperties.getProperty("metadataBidiFormatStr");
    }

    protected IResultSetMetaData createNewResultSetMetaData(ResultSetMetaData resultmd) throws OdaException {
        BidiResultSetMetaData result = new BidiResultSetMetaData((IResultSetMetaData)resultmd, this.contentBidiFormatStr, this.metadataBidiFormatStr);
        return result;
    }

    @Override
    public void prepare(String command) throws OdaException {
        try {
            String newCommand = BidiSQLTransform.transform(command, "ILYNN", this.contentBidiFormatStr, "ILYNN", this.metadataBidiFormatStr);
            super.prepare(newCommand);
        }
        catch (Throwable throwable) {
            super.prepare(command);
        }
    }

    @Override
    public IResultSetMetaData getMetaData() throws OdaException {
        IResultSetMetaData meta = super.getMetaData();
        return new BidiResultSetMetaData(meta, this.contentBidiFormatStr, this.metadataBidiFormatStr);
    }
}

