/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.producer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchRow;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationRow;
import fr.ifremer.tutti.service.genericformat.csv.SpeciesExportModel;
import fr.ifremer.tutti.service.genericformat.csv.SpeciesExportRow;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class CsvProducerForSpecies
extends CsvProducer<SpeciesExportRow, SpeciesExportModel> {
    final Map<String, Species> speciesByReferenceTaxonId;
    final Map<String, SpeciesExportRow> speciesToExport = Maps.newTreeMap();

    public CsvProducerForSpecies(Path file, SpeciesExportModel model, Map<String, Species> speciesByReferenceTaxonId) {
        super(file, model);
        this.speciesByReferenceTaxonId = speciesByReferenceTaxonId;
    }

    public void prepareSpeciesBatchRows(BatchContainer<SpeciesBatch> rootSpeciesBatch) {
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            this.addSpecies(speciesBatch.getSpecies());
        }
    }

    public void prepareBenthosBatchRows(BatchContainer<BenthosBatch> rootBenthosBatch) {
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            this.addSpecies(benthosBatch.getSpecies());
        }
    }

    public void prepareIndividualRows(List<IndividualObservationRow> rows) {
        for (IndividualObservationRow row : rows) {
            this.addSpecies(row.getSpecies());
        }
    }

    public void prepareAccidentalRows(List<AccidentalCatchRow> rows) {
        for (AccidentalCatchRow row : rows) {
            this.addSpecies(row.getSpecies());
        }
    }

    public List<SpeciesExportRow> getDataToExport() {
        ArrayList result = Lists.newArrayList(this.speciesToExport.values());
        Collections.sort(result, new Comparator<SpeciesExportRow>(){

            @Override
            public int compare(SpeciesExportRow o1, SpeciesExportRow o2) {
                return o1.getSpecies().getReferenceTaxonId().compareTo(o2.getSpecies().getReferenceTaxonId());
            }
        });
        return result;
    }

    public void addSpecies(Species species) {
        String speciesId = String.valueOf(species.getReferenceTaxonId());
        if (!this.speciesToExport.containsKey(speciesId)) {
            Species fullSpecies = this.speciesByReferenceTaxonId.get(speciesId);
            SpeciesExportRow row = new SpeciesExportRow();
            row.setSpecies(fullSpecies);
            this.speciesToExport.put(speciesId, row);
            species.setSurveyCode(fullSpecies.getSurveyCode());
        }
    }
}

