// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.user;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

/**
 * Tête de grappe de droits calculés pour un utilisateur à partir d'autres entités implémentant la
 * gestion des droits. Le but est l'amélioration des performances de synchronisation entre bases
 * locale et distante. Les droits sont calculés en début d'importation des données et n'ont pas à
 * être recalculés pour chaque donnée pour laquelle des droits sont appliqués.
 * Créé d'après l'étude sur l'amélioration des performances V3 (cf. mantis 10528).
 */
// HibernateEntity.vsl annotations merge-point
public abstract class PersonSession
    implements Serializable, Comparable<PersonSession>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 1029951372514017956L;

    // Generate 2 attributes
    private Integer id;

    /**
     * Identifiant technique
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant technique
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Timestamp updateDate;

    /**
     * Date de dernière modification en base centrale : utilisé pour la synchronisation entre base
     * locale et base distante
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de dernière modification en base centrale : utilisé pour la synchronisation entre base
     * locale et base distante
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 2 associations
    private Collection<PersonSessionVessel> personSessionVessels = new HashSet<PersonSessionVessel>();

    /**
     * ensemble de droits calculés de la grappe
     * @return this.personSessionVessels Collection<PersonSessionVessel>
     */
    public Collection<PersonSessionVessel> getPersonSessionVessels()
    {
        return this.personSessionVessels;
    }

    /**
     * ensemble de droits calculés de la grappe
     * @param personSessionVesselsIn Collection<PersonSessionVessel>
     */
    public void setPersonSessionVessels(Collection<PersonSessionVessel> personSessionVesselsIn)
    {
        this.personSessionVessels = personSessionVesselsIn;
    }

    /**
     * ensemble de droits calculés de la grappe
     * @param elementToAdd PersonSessionVessel
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addPersonSessionVessels(PersonSessionVessel elementToAdd)
    {
        return this.personSessionVessels.add(elementToAdd);
    }

    /**
     * ensemble de droits calculés de la grappe
     * @param elementToRemove PersonSessionVessel
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removePersonSessionVessels(PersonSessionVessel elementToRemove)
    {
        return this.personSessionVessels.remove(elementToRemove);
    }

    private Person person;

    /**
     * Personne pour laquelle s’applique la grappe de droits calculés
     * @return this.person Person
     */
    public Person getPerson()
    {
        return this.person;
    }

    /**
     * Personne pour laquelle s’applique la grappe de droits calculés
     * @param personIn Person
     */
    public void setPerson(Person personIn)
    {
        this.person = personIn;
    }

    /**
     * Returns <code>true</code> if the argument is an PersonSession instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof PersonSession))
        {
            return false;
        }
        final PersonSession that = (PersonSession)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link PersonSession}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link PersonSession}.
         * @return new PersonSessionImpl()
         */
        public static PersonSession newInstance()
        {
            return new PersonSessionImpl();
        }

        /**
         * Constructs a new instance of {@link PersonSession}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param person Person
         * @return newInstance
         */
        public static PersonSession newInstance(Person person)
        {
            final PersonSession entity = new PersonSessionImpl();
            entity.setPerson(person);
            return entity;
        }

        /**
         * Constructs a new instance of {@link PersonSession}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param updateDate Timestamp
         * @param personSessionVessels Collection<PersonSessionVessel>
         * @param person Person
         * @return newInstance PersonSession
         */
        public static PersonSession newInstance(Timestamp updateDate, Collection<PersonSessionVessel> personSessionVessels, Person person)
        {
            final PersonSession entity = new PersonSessionImpl();
            entity.setUpdateDate(updateDate);
            entity.setPersonSessionVessels(personSessionVessels);
            entity.setPerson(person);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(PersonSession o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// PersonSession.java merge-point
}