// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringDao.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.sample;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.andromda.spring.PaginationResult;

/**
 * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
 * d'un échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
 * pour analyse ou dénombrement.
 * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un débarquement
 * ou à une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de
 * provenance).
 * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le support
 * est, par exemple :
 * - crustacé (crevette...)
 * - poisson (merlu, sardine...)
 * - gastéropode (bigorneau, littorine...)
 * - echinoderme (oursin...)
 * - etc.
 * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de plusieurs
 * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
 * pourra identifié l'individu concerné par la mesure, par une numéro din'dividu.
 * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
 * prélèvement, permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour
 * la saisie des lectures d'age, etc..
 * Par exemple de prélèvement :
 * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes afin de
 * réaliser une lecture d'age.
 * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
 * - etc.
 * @see Sample
 */
public interface SampleDao
{
    /**
     * This constant is used as a transformation flag; entities can be converted automatically into value objects
     * or other types, different methods in a class implementing this interface support this feature: look for
     * an <code>int</code> parameter called <code>transform</code>.
     * <p>
     * This specific flag denotes no transformation will occur.
     */
    public static final int TRANSFORM_NONE = 0;


    /**
     * Transforms the given results to a collection of {@link Sample}
     * instances (this is useful when the returned results contains a row of data and you want just entities only).
     *
     * @param results the query results.
     */
    public void toEntities(final Collection<?> results);

    /**
     * Gets an instance of Sample from the persistent store.
     * @param id
     * @return Sample
     */
    public Sample get(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #get(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to get.
     * @return either the entity or the object transformed from the entity.
     */
    public Object get(int transform, Integer id);

    /**
     * Loads an instance of Sample from the persistent store.
     * @param id
     * @return Sample
     */
    public Sample load(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #load(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to load.
     * @return either the entity or the object transformed from the entity.
     */
    public Object load(int transform, Integer id);

    /**
     * Loads all entities of type {@link Sample}.
     *
     * @return the loaded entities.
     */
    public Collection<Sample> loadAll();

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform);

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int pageNumber, final int pageSize);

    /**
     * <p>
     * Does the same thing as {@link #loadAll(int)} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform, final int pageNumber, final int pageSize);

    /**
     * Creates an instance of Sample and adds it to the persistent store.
     * @param sample
     * @return Sample
     */
    public Sample create(Sample sample);

    /**
     * <p>
     * Does the same thing as {@link #create(Sample)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param sample
     * @return Object
     */
    public Object create(int transform, Sample sample);

    /**
     * Creates a new instance of Sample and adds
     * from the passed in <code>entities</code> collection
     *
     * @param entities the collection of Sample
     * instances to create.
     *
     * @return the created instances.
     */
    public Collection<Sample> create(Collection<Sample> entities);

    /**
     * <p>
     * Does the same thing as {@link #create(Sample)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param entities
     * @return Collection
     */
    public Collection<?> create(int transform, Collection<Sample> entities);

    /**
     * <p>
     * Creates a new <code>Sample</code>
     * instance from <strong>all</strong> attributes and adds it to
     * the persistent store.
     * </p>
     * @param label Mnémonique du prélèvement. Par exemple, il peut s'agir d'un code propre à chaque programme : pour
les marées observée, par exemple, il s'agira d'une étiquette permettant d'identifier l'échantillon
sur le terrain puis en laboratoire.
Autant que possible, le mnémonique devra etre unique pour tous le système, ou à défaut unique au
sein de la marée, du débarquement, de la vente ou de la campagne.
Nomenclature retenue à l'issu des spécifications Allegro V3 :
<date>_<initiales>_<lieu>_<G|S>_<numéro>
Avec :
- <date> : date de l’observation au format AAAMMJJ. La date est issue (suivant la donnée mère
rattachée) :
* de la date de début de l’opération de pêche ou du groupe d’opérations (si période du groupe
d’opération n’a pas été renseigné : prendre la date de début de la marée)
* ou de la date de débarquement,
* ou de la date de la vente.
- <initiales> : il s’agit des initiales déjà saisit par l’utilisateur (cf variante précédente).
- <lieu> : mnémonique du lieu d’observation, si présent, ou libellé sinon. Le lieu d’observation est
issu (suivant la donnée mère rattachée) :
* pour une opération de pêche ou un groupe d’opérations, il s’agit du port de départ de la marée,
* pour un débarquement, du lieu de débarquement
* pour une vente, du lieu de la vente
- <G|S> : suivant la donnée mère rattachée :
* ‘G’ (=Ground) si donnée mère rattachée est un débarquement ou une vente ;
* ‘S’ (=Sea) si donnée mère rattachée est une opération de pêche ou à une groupe d’opérations.
- <numéro> : Il s’agit d’un numéro au format NNN (sur trois caractère. Exemple : « 001 »),
auto-incrémentée (valeur maximale connue + 1) de manière à être unique au sein de (suivant la donnée
mère rattachée) :
* la marée, si la donnée mère rattachée est une opération de pêche ou un groupe d’opérations
* ou du débarquement,
* ou de la vente
     * @param sampleDate Jour du prélèvement (heure optionnelle).
     * @param individualCount Nombre d'individus constituant l'échantillon.
     * @param size La taille de l'échantillon peut représenter une surface ou un volume suivant les cas. Il peut aussi
s'agir du nombre d'individus entrant dans l'homogénat.
     * @param synchronizationStatus Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement visible dans
la base locale.
     * @param comments Commentaire libre concernant l'échantillon.
     * @param creationDate 
     * @param controlDate 
     * @param validationDate 
     * @param qualificationDate 
     * @param qualificationComments 
     * @param updateDate 
     * @param remoteId 
     * @return Sample
     */
    public Sample create(
        String label,
        Date sampleDate,
        Short individualCount,
        Float size,
        String synchronizationStatus,
        String comments,
        Date creationDate,
        Date controlDate,
        Date validationDate,
        Date qualificationDate,
        String qualificationComments,
        Timestamp updateDate,
        Integer remoteId);

    /**
     * <p>
     * Does the same thing as {@link #create(String, Date, Short, Float, String, String, Date, Date, Date, Date, String, Timestamp, Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param label Mnémonique du prélèvement. Par exemple, il peut s'agir d'un code propre à chaque programme : pour
les marées observée, par exemple, il s'agira d'une étiquette permettant d'identifier l'échantillon
sur le terrain puis en laboratoire.
Autant que possible, le mnémonique devra etre unique pour tous le système, ou à défaut unique au
sein de la marée, du débarquement, de la vente ou de la campagne.
Nomenclature retenue à l'issu des spécifications Allegro V3 :
<date>_<initiales>_<lieu>_<G|S>_<numéro>
Avec :
- <date> : date de l’observation au format AAAMMJJ. La date est issue (suivant la donnée mère
rattachée) :
* de la date de début de l’opération de pêche ou du groupe d’opérations (si période du groupe
d’opération n’a pas été renseigné : prendre la date de début de la marée)
* ou de la date de débarquement,
* ou de la date de la vente.
- <initiales> : il s’agit des initiales déjà saisit par l’utilisateur (cf variante précédente).
- <lieu> : mnémonique du lieu d’observation, si présent, ou libellé sinon. Le lieu d’observation est
issu (suivant la donnée mère rattachée) :
* pour une opération de pêche ou un groupe d’opérations, il s’agit du port de départ de la marée,
* pour un débarquement, du lieu de débarquement
* pour une vente, du lieu de la vente
- <G|S> : suivant la donnée mère rattachée :
* ‘G’ (=Ground) si donnée mère rattachée est un débarquement ou une vente ;
* ‘S’ (=Sea) si donnée mère rattachée est une opération de pêche ou à une groupe d’opérations.
- <numéro> : Il s’agit d’un numéro au format NNN (sur trois caractère. Exemple : « 001 »),
auto-incrémentée (valeur maximale connue + 1) de manière à être unique au sein de (suivant la donnée
mère rattachée) :
* la marée, si la donnée mère rattachée est une opération de pêche ou un groupe d’opérations
* ou du débarquement,
* ou de la vente
     * @param sampleDate Jour du prélèvement (heure optionnelle).
     * @param individualCount Nombre d'individus constituant l'échantillon.
     * @param size La taille de l'échantillon peut représenter une surface ou un volume suivant les cas. Il peut aussi
s'agir du nombre d'individus entrant dans l'homogénat.
     * @param synchronizationStatus Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement visible dans
la base locale.
     * @param comments Commentaire libre concernant l'échantillon.
     * @param creationDate 
     * @param controlDate 
     * @param validationDate 
     * @param qualificationDate 
     * @param qualificationComments 
     * @param updateDate 
     * @param remoteId 
     * @return Sample
     */
    public Object create(
        int transform,
        String label,
        Date sampleDate,
        Short individualCount,
        Float size,
        String synchronizationStatus,
        String comments,
        Date creationDate,
        Date controlDate,
        Date validationDate,
        Date qualificationDate,
        String qualificationComments,
        Timestamp updateDate,
        Integer remoteId);

    /**
     * <p>
     * Creates a new <code>Sample</code>
     * instance from only <strong>required</strong> properties (attributes
     * and association ends) and adds it to the persistent store.
     * </p>
     * @param creationDate
     * @param label
     * @param matrix
     * @param program
     * @param qualityFlag
     * @param recorderDepartment
     * @param synchronizationStatus
     * @return Sample
     */
    public Sample create(
        Date creationDate,
        String label,
        Matrix matrix,
        Program program,
        QualityFlag qualityFlag,
        Department recorderDepartment,
        String synchronizationStatus);

    /**
     * <p>
     * Does the same thing as {@link #create(String, String, Date)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform flag to determine transformation type.
     * @param creationDate
     * @param label
     * @param matrix
     * @param program
     * @param qualityFlag
     * @param recorderDepartment
     * @param synchronizationStatus
     * @return Object
     */
    public Object create(
        int transform,
        Date creationDate,
        String label,
        Matrix matrix,
        Program program,
        QualityFlag qualityFlag,
        Department recorderDepartment,
        String synchronizationStatus);

    /**
     * Updates the <code>sample</code> instance in the persistent store.
     * @param sample
     */
    public void update(Sample sample);

    /**
     * Updates all instances in the <code>entities</code> collection in the persistent store.
     * @param entities
     */
    public void update(Collection<Sample> entities);

    /**
     * Removes the instance of Sample from the persistent store.
     * @param sample
     */
    public void remove(Sample sample);

    /**
     * Removes the instance of Sample having the given
     * <code>identifier</code> from the persistent store.
     * @param id
     */
    public void remove(Integer id);

    /**
     * Removes all entities in the given <code>entities</code> collection.
     * @param entities
     */
    public void remove(Collection<Sample> entities);


    /**
     * Does the same thing as {@link #search(int, Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param transform the transformation flag.
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int transform, final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * finder results will <strong>NOT</strong> be transformed during retrieval.
     * If this flag is any of the other constants defined here
     * then results <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     *
     * @param transform the transformation flag.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<?> search(final int transform, final Search search);

    /**
     * Performs a search using the parameters specified in the given <code>search</code> object.
     *
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<Sample> search(final Search search);

    /**
     * Allows transformation of entities into value objects
     * (or something else for that matter), when the <code>transform</code>
     * flag is set to one of the constants defined in <code>fr.ifremer.adagio.core.dao.data.sample.SampleDao</code>, please note
     * that the {@link #TRANSFORM_NONE} constant denotes no transformation, so the entity itself
     * will be returned.
     *
     * If the integer argument value is unknown {@link #TRANSFORM_NONE} is assumed.
     *
     * @param transform one of the constants declared in {@link fr.ifremer.adagio.core.dao.data.sample.SampleDao}
     * @param entity an entity that was found
     * @return the transformed entity (i.e. new value object, etc)
     * @see #transformEntities(int,Collection)
     */
    public Object transformEntity(final int transform, final Sample entity);

    /**
     * Transforms a collection of entities using the
     * {@link #transformEntity(int,Sample)}
     * method. This method does not instantiate a new collection.
     * <p>
     * This method is to be used internally only.
     *
     * @param transform one of the constants declared in <code>fr.ifremer.adagio.core.dao.data.sample.SampleDao</code>
     * @param entities the collection of entities to transform
     * @see #transformEntity(int,Sample)
     */
    public void transformEntities(final int transform, final Collection<?> entities);

    // spring-dao merge-point
}