// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.programStrategy;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;

/**
 * Liste des droits d''un service pour un programme particulier
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Program2Department
    implements Serializable, Comparable<Program2Department>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -1578423454473058781L;

    // Generate 1 attributes
    private Integer id;

    /**
     * 
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * 
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    // Generate 4 associations
    private ProgramPrivilege programPrivilege;

    /**
     * Identifiant du privilège (droit) sur les programmes
     * @return this.programPrivilege ProgramPrivilege
     */
    public ProgramPrivilege getProgramPrivilege()
    {
        return this.programPrivilege;
    }

    /**
     * Identifiant du privilège (droit) sur les programmes
     * @param programPrivilegeIn ProgramPrivilege
     */
    public void setProgramPrivilege(ProgramPrivilege programPrivilegeIn)
    {
        this.programPrivilege = programPrivilegeIn;
    }

    private Program program;

    /**
     * Code unique du programme
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Code unique du programme
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Location location;

    /**
     * Lieu sur lequel le département a les droits
     * @return this.location Location
     */
    public Location getLocation()
    {
        return this.location;
    }

    /**
     * Lieu sur lequel le département a les droits
     * @param locationIn Location
     */
    public void setLocation(Location locationIn)
    {
        this.location = locationIn;
    }

    private Department department;

    /**
     * Identifiant interne d''un service
     * @return this.department Department
     */
    public Department getDepartment()
    {
        return this.department;
    }

    /**
     * Identifiant interne d''un service
     * @param departmentIn Department
     */
    public void setDepartment(Department departmentIn)
    {
        this.department = departmentIn;
    }

    /**
     * Returns <code>true</code> if the argument is an Program2Department instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Program2Department))
        {
            return false;
        }
        final Program2Department that = (Program2Department)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Program2Department}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Program2Department}.
         * @return new Program2DepartmentImpl()
         */
        public static Program2Department newInstance()
        {
            return new Program2DepartmentImpl();
        }

        /**
         * Constructs a new instance of {@link Program2Department}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param programPrivilege ProgramPrivilege
         * @param program Program
         * @param department Department
         * @return newInstance
         */
        public static Program2Department newInstance(ProgramPrivilege programPrivilege, Program program, Department department)
        {
            final Program2Department entity = new Program2DepartmentImpl();
            entity.setProgramPrivilege(programPrivilege);
            entity.setProgram(program);
            entity.setDepartment(department);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Program2Department}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param programPrivilege ProgramPrivilege
         * @param program Program
         * @param location Location
         * @param department Department
         * @return newInstance Program2Department
         */
        public static Program2Department newInstance(ProgramPrivilege programPrivilege, Program program, Location location, Department department)
        {
            final Program2Department entity = new Program2DepartmentImpl();
            entity.setProgramPrivilege(programPrivilege);
            entity.setProgram(program);
            entity.setLocation(location);
            entity.setDepartment(department);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Program2Department o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Program2Department.java merge-point
}