// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.programStrategy;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Programme d'observation à l'origine d'une collecte de données.
 * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données, que
 * ce soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
 * dans le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
 * s'agit d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais
 * toujours mise en œuvre selon un schéma décidé à l'avance.
 * Exemple de programmes d'observations :
 * - SIH-OBSMER (marées observées en mer)
 * - SIH-STATPECHE (enquete d'activité et d'effort...)
 * - SIPA : données déclaratives transmises par la DPMA
 * - VMS : données satellitaires
 * - OFIMER : données du SI de l'OFIMER
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Program
    implements Serializable, Comparable<Program>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -8923218287399812385L;

    // Generate 5 attributes
    private String code;

    /**
     * 
     * @return this.code String
     */
    public String getCode()
    {
        return this.code;
    }

    /**
     * 
     * @param codeIn String
     */
    public void setCode(String codeIn)
    {
        this.code = codeIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * 
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * 
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 44 associations
    private TaxonGroupType taxonGroupType;

    /**
     * Type de classification d'espèce commerciales utilisé par le programme.
     * Généralement, pour les actions du SIH, on utilise le référentiel des espèces commerciales
     * ASFIS/FAO.
     * Malgré tout, dans certains cas (ex : données historiques), d'autres référentiels peuvent
     * avoir été utilisés.
     * @return this.taxonGroupType TaxonGroupType
     */
    public TaxonGroupType getTaxonGroupType()
    {
        return this.taxonGroupType;
    }

    /**
     * Type de classification d'espèce commerciales utilisé par le programme.
     * Généralement, pour les actions du SIH, on utilise le référentiel des espèces commerciales
     * ASFIS/FAO.
     * Malgré tout, dans certains cas (ex : données historiques), d'autres référentiels peuvent
     * avoir été utilisés.
     * @param taxonGroupTypeIn TaxonGroupType
     */
    public void setTaxonGroupType(TaxonGroupType taxonGroupTypeIn)
    {
        this.taxonGroupType = taxonGroupTypeIn;
    }

    private Collection<Program2Person> programUsers = new HashSet<Program2Person>();

    /**
     * 
     * @return this.programUsers Collection<Program2Person>
     */
    public Collection<Program2Person> getProgramUsers()
    {
        return this.programUsers;
    }

    /**
     * 
     * @param programUsersIn Collection<Program2Person>
     */
    public void setProgramUsers(Collection<Program2Person> programUsersIn)
    {
        this.programUsers = programUsersIn;
    }

    /**
     * 
     * @param elementToAdd Program2Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProgramUsers(Program2Person elementToAdd)
    {
        return this.programUsers.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove Program2Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProgramUsers(Program2Person elementToRemove)
    {
        return this.programUsers.remove(elementToRemove);
    }

    private Collection<Program2Department> program2Departments = new HashSet<Program2Department>();

    /**
     * Liste des droits d''un service pour un programme particulier
     * @return this.program2Departments Collection<Program2Department>
     */
    public Collection<Program2Department> getProgram2Departments()
    {
        return this.program2Departments;
    }

    /**
     * Liste des droits d''un service pour un programme particulier
     * @param program2DepartmentsIn Collection<Program2Department>
     */
    public void setProgram2Departments(Collection<Program2Department> program2DepartmentsIn)
    {
        this.program2Departments = program2DepartmentsIn;
    }

    /**
     * Liste des droits d''un service pour un programme particulier
     * @param elementToAdd Program2Department
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProgram2Departments(Program2Department elementToAdd)
    {
        return this.program2Departments.add(elementToAdd);
    }

    /**
     * Liste des droits d''un service pour un programme particulier
     * @param elementToRemove Program2Department
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProgram2Departments(Program2Department elementToRemove)
    {
        return this.program2Departments.remove(elementToRemove);
    }

    private Collection<LocationClassification> locationClassifications = new HashSet<LocationClassification>();

    /**
     * Classifications de lieu concernés par le programme.
     * Au moins une est obligatoire.
     * @return this.locationClassifications Collection<LocationClassification>
     */
    public Collection<LocationClassification> getLocationClassifications()
    {
        return this.locationClassifications;
    }

    /**
     * Classifications de lieu concernés par le programme.
     * Au moins une est obligatoire.
     * @param locationClassificationsIn Collection<LocationClassification>
     */
    public void setLocationClassifications(Collection<LocationClassification> locationClassificationsIn)
    {
        this.locationClassifications = locationClassificationsIn;
    }

    /**
     * Classifications de lieu concernés par le programme.
     * Au moins une est obligatoire.
     * @param elementToAdd LocationClassification
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addLocationClassifications(LocationClassification elementToAdd)
    {
        return this.locationClassifications.add(elementToAdd);
    }

    /**
     * Classifications de lieu concernés par le programme.
     * Au moins une est obligatoire.
     * @param elementToRemove LocationClassification
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeLocationClassifications(LocationClassification elementToRemove)
    {
        return this.locationClassifications.remove(elementToRemove);
    }

    private GearClassification gearClassification;

    /**
     * Une classification d'engin permet le regroupement d'un ensemble cohérent d'engin.
     * Exemple :
     * - Engin FAO, appellée aussi CSITEP (Classification Standard Internationale Type des Engins de
     * Pêche), ou, en anglais : International Standard Statistical Classification of Fishing Gear
     * (ISSCFG)
     * : ftp://ftp.fao.org/FI/DOCUMENT/cwp/handbook/annex/AnnexM1fishinggear.pdf
     * - Engin CNTS (DPMA SIP)
     * - Engin EU (basé sur les engins FAO, mais adapté au contexte réglementaire européen) :
     * exemple : 	- extension pour signifier 'pas d'engin' : NO
     * extension pour signifier 'engin inconnu' : NK (Not Known)
     * 'ligne avec canne (...)' : BTF (code utilisé pour des données historique)
     * - 'Engin EU Corpus' pour le traitment (cf DRE_CORPUS dans tmpsih)
     * - Engin Métier Ifremer (basé sur la classification FAO, et etendue aux besoins
     * Ifremer/francais)
     * Pour ObsMer, la classification utilisée est : FAO
     * Pour les observations au débarquement, la classification utilisée est : FAO + CNTS (pour
     * recroiser
     * avec les déclarations)
     * @return this.gearClassification GearClassification
     */
    public GearClassification getGearClassification()
    {
        return this.gearClassification;
    }

    /**
     * Une classification d'engin permet le regroupement d'un ensemble cohérent d'engin.
     * Exemple :
     * - Engin FAO, appellée aussi CSITEP (Classification Standard Internationale Type des Engins de
     * Pêche), ou, en anglais : International Standard Statistical Classification of Fishing Gear
     * (ISSCFG)
     * : ftp://ftp.fao.org/FI/DOCUMENT/cwp/handbook/annex/AnnexM1fishinggear.pdf
     * - Engin CNTS (DPMA SIP)
     * - Engin EU (basé sur les engins FAO, mais adapté au contexte réglementaire européen) :
     * exemple : 	- extension pour signifier 'pas d'engin' : NO
     * extension pour signifier 'engin inconnu' : NK (Not Known)
     * 'ligne avec canne (...)' : BTF (code utilisé pour des données historique)
     * - 'Engin EU Corpus' pour le traitment (cf DRE_CORPUS dans tmpsih)
     * - Engin Métier Ifremer (basé sur la classification FAO, et etendue aux besoins
     * Ifremer/francais)
     * Pour ObsMer, la classification utilisée est : FAO
     * Pour les observations au débarquement, la classification utilisée est : FAO + CNTS (pour
     * recroiser
     * avec les déclarations)
     * @param gearClassificationIn GearClassification
     */
    public void setGearClassification(GearClassification gearClassificationIn)
    {
        this.gearClassification = gearClassificationIn;
    }

    private Collection<Strategy> strategies = new HashSet<Strategy>();

    /**
     * La stratégie définit a priori ce que devront être les données présentes dans le système de
     * l'origine
     * de la collecte des données. Il s'agit de la liste des paramètres à mesurer, ainsi que des
     * méthodes
     * préconisées pour chacun de ces paramètres. La stratégie permet ainsi d'aider à la saisie des
     * données, en personnalisant les écrans, et facilite la consultation rapide du contenu
     * théorique de la
     * base.
     * Par exemple, on pourra avoir les stratégies suivantes :
     * - stratégie "échantillonnage pendant les marées observées"
     * - stratégie "échantillonnage pendant les campagne à la mer"
     * @return this.strategies Collection<Strategy>
     */
    public Collection<Strategy> getStrategies()
    {
        return this.strategies;
    }

    /**
     * La stratégie définit a priori ce que devront être les données présentes dans le système de
     * l'origine
     * de la collecte des données. Il s'agit de la liste des paramètres à mesurer, ainsi que des
     * méthodes
     * préconisées pour chacun de ces paramètres. La stratégie permet ainsi d'aider à la saisie des
     * données, en personnalisant les écrans, et facilite la consultation rapide du contenu
     * théorique de la
     * base.
     * Par exemple, on pourra avoir les stratégies suivantes :
     * - stratégie "échantillonnage pendant les marées observées"
     * - stratégie "échantillonnage pendant les campagne à la mer"
     * @param strategiesIn Collection<Strategy>
     */
    public void setStrategies(Collection<Strategy> strategiesIn)
    {
        this.strategies = strategiesIn;
    }

    /**
     * La stratégie définit a priori ce que devront être les données présentes dans le système de
     * l'origine
     * de la collecte des données. Il s'agit de la liste des paramètres à mesurer, ainsi que des
     * méthodes
     * préconisées pour chacun de ces paramètres. La stratégie permet ainsi d'aider à la saisie des
     * données, en personnalisant les écrans, et facilite la consultation rapide du contenu
     * théorique de la
     * base.
     * Par exemple, on pourra avoir les stratégies suivantes :
     * - stratégie "échantillonnage pendant les marées observées"
     * - stratégie "échantillonnage pendant les campagne à la mer"
     * @param elementToAdd Strategy
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addStrategies(Strategy elementToAdd)
    {
        return this.strategies.add(elementToAdd);
    }

    /**
     * La stratégie définit a priori ce que devront être les données présentes dans le système de
     * l'origine
     * de la collecte des données. Il s'agit de la liste des paramètres à mesurer, ainsi que des
     * méthodes
     * préconisées pour chacun de ces paramètres. La stratégie permet ainsi d'aider à la saisie des
     * données, en personnalisant les écrans, et facilite la consultation rapide du contenu
     * théorique de la
     * base.
     * Par exemple, on pourra avoir les stratégies suivantes :
     * - stratégie "échantillonnage pendant les marées observées"
     * - stratégie "échantillonnage pendant les campagne à la mer"
     * @param elementToRemove Strategy
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeStrategies(Strategy elementToRemove)
    {
        return this.strategies.remove(elementToRemove);
    }

    private Collection<Location> locations = new HashSet<Location>();

    /**
     * Lieux concernés par le programme.Les lieux sont obligatoirement du type de lieu rattaché au
     * programme (cf. type de lieu concerné).
     * @return this.locations Collection<Location>
     */
    public Collection<Location> getLocations()
    {
        return this.locations;
    }

    /**
     * Lieux concernés par le programme.Les lieux sont obligatoirement du type de lieu rattaché au
     * programme (cf. type de lieu concerné).
     * @param locationsIn Collection<Location>
     */
    public void setLocations(Collection<Location> locationsIn)
    {
        this.locations = locationsIn;
    }

    /**
     * Lieux concernés par le programme.Les lieux sont obligatoirement du type de lieu rattaché au
     * programme (cf. type de lieu concerné).
     * @param elementToAdd Location
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addLocations(Location elementToAdd)
    {
        return this.locations.add(elementToAdd);
    }

    /**
     * Lieux concernés par le programme.Les lieux sont obligatoirement du type de lieu rattaché au
     * programme (cf. type de lieu concerné).
     * @param elementToRemove Location
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeLocations(Location elementToRemove)
    {
        return this.locations.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Program instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Program))
        {
            return false;
        }
        final Program that = (Program)object;
        if (this.code == null || that.getCode() == null || !this.code.equals(that.getCode()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Program}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Program}.
         * @return new ProgramImpl()
         */
        public static Program newInstance()
        {
            return new ProgramImpl();
        }

        /**
         * Constructs a new instance of {@link Program}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param description String
         * @param creationDate Date
         * @param taxonGroupType TaxonGroupType
         * @param locationClassifications Collection<LocationClassification>
         * @param gearClassification GearClassification
         * @return newInstance
         */
        public static Program newInstance(String name, String description, Date creationDate, TaxonGroupType taxonGroupType, Collection<LocationClassification> locationClassifications, GearClassification gearClassification)
        {
            final Program entity = new ProgramImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setCreationDate(creationDate);
            entity.setTaxonGroupType(taxonGroupType);
            entity.setLocationClassifications(locationClassifications);
            entity.setGearClassification(gearClassification);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Program}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param description String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param taxonGroupType TaxonGroupType
         * @param programUsers Collection<Program2Person>
         * @param program2Departments Collection<Program2Department>
         * @param locationClassifications Collection<LocationClassification>
         * @param gearClassification GearClassification
         * @param strategies Collection<Strategy>
         * @param locations Collection<Location>
         * @return newInstance Program
         */
        public static Program newInstance(String name, String description, Date creationDate, Timestamp updateDate, TaxonGroupType taxonGroupType, Collection<Program2Person> programUsers, Collection<Program2Department> program2Departments, Collection<LocationClassification> locationClassifications, GearClassification gearClassification, Collection<Strategy> strategies, Collection<Location> locations)
        {
            final Program entity = new ProgramImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setTaxonGroupType(taxonGroupType);
            entity.setProgramUsers(programUsers);
            entity.setProgram2Departments(program2Departments);
            entity.setLocationClassifications(locationClassifications);
            entity.setGearClassification(gearClassification);
            entity.setStrategies(strategies);
            entity.setLocations(locations);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Program o)
    {
        int cmp = 0;
        if (this.getCode() != null)
        {
            cmp = this.getCode().compareTo(o.getCode());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Program.java merge-point
}