/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SampleCategoryModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<SampleCategoryModelEntry> category;
    protected final List<Integer> samplingOrder;
    protected final List<SampleCategoryModelEntry> reverseCategory;
    protected final Map<Integer, SampleCategoryModelEntry> categoryMap;

    public SampleCategoryModel(List<SampleCategoryModelEntry> category) {
        ArrayList samplingOrder = Lists.newArrayList();
        this.category = Lists.newArrayList(category);
        this.categoryMap = Maps.newLinkedHashMap();
        for (SampleCategoryModelEntry def : category) {
            this.categoryMap.put(def.getCategoryId(), def);
            samplingOrder.add(def.getCategoryId());
        }
        this.samplingOrder = Collections.unmodifiableList(samplingOrder);
        ArrayList reverseCategory = Lists.newArrayList(category);
        Collections.reverse(reverseCategory);
        this.reverseCategory = Collections.unmodifiableList(reverseCategory);
    }

    public void load(TuttiPersistence service) {
        for (SampleCategoryModelEntry def : this.category) {
            def.load(service);
        }
    }

    public List<Integer> getSamplingOrder() {
        return this.samplingOrder;
    }

    public List<SampleCategoryModelEntry> getCategory() {
        return this.category;
    }

    public List<SampleCategoryModelEntry> getReverseCategory() {
        return this.reverseCategory;
    }

    public Map<Integer, SampleCategoryModelEntry> getCategoryMap() {
        return this.categoryMap;
    }

    public SampleCategoryModelEntry getCategoryById(Integer categoryId) {
        return this.categoryMap.get(categoryId);
    }

    public SampleCategoryModelEntry getCategoryByIndex(int index) {
        return this.category.get(index);
    }

    public String toString() {
        ArrayList entries = Lists.newArrayList();
        for (SampleCategoryModelEntry entry : this.category) {
            entries.add(entry.toString());
        }
        String result = Joiner.on((char)'|').join((Iterable)entries);
        return result;
    }

    public Integer getLastCategoryId() {
        return this.samplingOrder.isEmpty() ? null : this.samplingOrder.get(this.samplingOrder.size() - 1);
    }

    public int getNbSampling() {
        return this.samplingOrder.size();
    }

    public Integer getFirstCategoryId() {
        return this.samplingOrder.isEmpty() ? null : this.samplingOrder.get(0);
    }

    public boolean containsCategoryId(Integer id) {
        return this.samplingOrder.contains(id);
    }

    public int indexOf(SampleCategoryModelEntry sampleCategoryDef) {
        return this.category.indexOf(sampleCategoryDef);
    }
}

