/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RenameSpeciesBatchAction
extends LongActionSupport<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected Species selectedSpecies;

    public RenameSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        int selectedRowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)((SpeciesBatchUIHandler)this.handler).getModel();
        ArrayList speciesList = Lists.newArrayList((Iterable)this.getDataContext().getReferentSpeciesWithSurveyCode());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Object categoryValue = firstSampleCategory.getCategoryValue();
        speciesList.removeAll(model.getSpeciesUsed().get((Object)((CaracteristicQualitativeValue)categoryValue)));
        this.selectedSpecies = this.openAddSpeciesDialog(I18n.t((String)"tutti.selectSpecies.title", (Object[])new Object[0]), speciesList);
        return result &= this.selectedSpecies != null;
    }

    public void releaseAction() {
        this.selectedSpecies = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        int selectedRowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        persistenceService.changeSpeciesBatchSpecies(row.getId(), this.selectedSpecies);
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Object categoryValue = firstSampleCategory.getCategoryValue();
        Collection speciesUsed = ((SpeciesBatchUIModel)this.getModel()).getSpeciesUsed().get((Object)((CaracteristicQualitativeValue)categoryValue));
        speciesUsed.remove(row.getSpecies());
        this.changeChildrenSpecies(row, this.selectedSpecies);
        speciesUsed.add(this.selectedSpecies);
    }

    protected void changeChildrenSpecies(SpeciesBatchRowModel row, Species species) {
        row.setSpecies(species);
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (children != null) {
            for (SpeciesBatchRowModel child : children) {
                this.changeChildrenSpecies(child, species);
            }
        }
    }
}

