/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.producer;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationModel;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationRow;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class CsvProducerForIndividualObservation
extends CsvProducer<IndividualObservationRow, IndividualObservationModel> {
    public CsvProducerForIndividualObservation(Path file, IndividualObservationModel model) {
        super(file, model);
    }

    public List<IndividualObservationRow> getDataToExport(GenericFormatExportOperationContext operationExportContext) {
        ArrayList<IndividualObservationRow> rows = new ArrayList<IndividualObservationRow>();
        List<IndividualObservationBatch> individualObservations = operationExportContext.getIndividualObservations();
        if (CollectionUtils.isNotEmpty(individualObservations)) {
            for (IndividualObservationBatch child : individualObservations) {
                this.addIndividualObservationBatch(operationExportContext, rows, child);
            }
        }
        return rows;
    }

    protected void addIndividualObservationBatch(GenericFormatExportOperationContext operationExportContext, List<IndividualObservationRow> rows, IndividualObservationBatch child) {
        CaracteristicMap caracteristics;
        this.addCaracteristicRow(operationExportContext, rows, child, operationExportContext.getWeightMeasuredCaracteristic(), child.getWeight());
        if (child.getLengthStepCaracteristic() != null) {
            this.addCaracteristicRow(operationExportContext, rows, child, operationExportContext.getPmfmIdCaracteristic(), child.getLengthStepCaracteristic().getIdAsInt());
            this.addCaracteristicRow(operationExportContext, rows, child, child.getLengthStepCaracteristic(), child.getSize());
        }
        if (MapUtils.isNotEmpty((Map)(caracteristics = child.getCaracteristics()))) {
            for (Map.Entry entry : caracteristics.entrySet()) {
                this.addCaracteristicRow(operationExportContext, rows, child, (Caracteristic)entry.getKey(), (Serializable)entry.getValue());
            }
        }
    }

    protected void addCaracteristicRow(GenericFormatExportOperationContext operationExportContext, List<IndividualObservationRow> rows, IndividualObservationBatch individualObservationBatch, Caracteristic caracteristic, Serializable caracteristicValue) {
        if (caracteristicValue != null) {
            IndividualObservationRow row = new IndividualObservationRow();
            row.setCruise(operationExportContext.getCruise());
            row.setFishingOperation(operationExportContext.getOperation());
            row.setComment(individualObservationBatch.getComment());
            row.setSpecies(individualObservationBatch.getSpecies());
            row.setBatchId(individualObservationBatch.getIdAsInt());
            row.setCaracteristic(caracteristic);
            row.setCaracteristicValue(caracteristicValue);
            rows.add(row);
        }
    }
}

