/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.csv;

import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchRow;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class AccidentalCatchModel
extends AbstractTuttiImportExportModel<AccidentalCatchRow> {
    public static AccidentalCatchModel forExport(char separator) {
        AccidentalCatchModel exportModel = new AccidentalCatchModel(separator);
        exportModel.forExport();
        return exportModel;
    }

    public static AccidentalCatchModel forImport(char separator, GenericFormatImportEntityParserFactory parserFactory) {
        AccidentalCatchModel importModel = new AccidentalCatchModel(separator);
        importModel.forImport(parserFactory);
        return importModel;
    }

    public AccidentalCatchRow newEmptyInstance() {
        AccidentalCatchRow row = AccidentalCatchRow.newEmptyInstance();
        return row;
    }

    protected AccidentalCatchModel(char separator) {
        super(separator);
    }

    protected void forExport() {
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", TuttiCsvUtil.PROGRAM_FORMATTER);
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Code_Station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Id_Lot", "batchId", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport("Code_Taxon", "species", TuttiCsvUtil.SPECIES_TECHNICAL_FORMATTER);
        this.newColumnForExport("Nom_Scientifique", "species", TuttiCsvUtil.SPECIES_FORMATTER);
        this.newColumnForExport("Commentaire", "comment", (ValueFormatter)TuttiCsvUtil.COMMENT_PARSER_FORMATTER);
        this.newColumnForExport("Code_PMFM", "caracteristic", TuttiCsvUtil.CARACTERISTIC_TECHNICAL_FORMATTER);
        this.newColumnForExport("Libelle_PMFM", "caracteristic", TuttiCsvUtil.CARACTERISTIC_FORMATTER);
        this.newColumnForExport("Valeur", "caracteristicValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newColumnForExport("Serie_Id", "program", TuttiCsvUtil.PROGRAM_TECHNICAL_FORMATTER);
        this.newColumnForExport("Valeur_Id", "caracteristicValue", TuttiCsvUtil.CARACTERISTIC_VALUE_TECHNICAL_FORMATTER);
    }

    protected void forImport(GenericFormatImportEntityParserFactory parserFactory) {
        this.newMandatoryColumn("Annee", "beginDate", (ValueParser)TuttiCsvUtil.YEAR);
        this.newIgnoredColumn("Serie");
        this.newMandatoryColumn("Serie_Partielle", "surveyPart");
        this.newMandatoryColumn("Code_Station", "stationNumber");
        this.newMandatoryColumn("Id_Operation", "fishingOperationNumber", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Poche", "multirigAggregation");
        this.newMandatoryColumn("Id_Lot", "batchId", (ValueParser)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newMandatoryColumn("Code_Taxon", "species", (ValueParser)parserFactory.getSpeciesParser());
        this.newIgnoredColumn("Nom_Scientifique");
        this.newMandatoryColumn("Commentaire", "comment", (ValueParser)TuttiCsvUtil.COMMENT_PARSER_FORMATTER);
        this.newMandatoryColumn("Code_PMFM", "caracteristic", (ValueParser)parserFactory.getCaracteristicWithProtectedParser());
        this.newIgnoredColumn("Libelle_PMFM");
        this.newIgnoredColumn("Valeur");
        this.newMandatoryColumn("Serie_Id", "program", (ValueParser)parserFactory.getProgramParser());
        this.newMandatoryColumn("Valeur_Id", "caracteristicValue");
    }
}

