/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CaracteristicValueParseException;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationModel;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationRow;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;

public class CsvConsumerForIndividualObservation
extends CsvComsumer<IndividualObservationRow, IndividualObservationModel> {
    private static final Log log = LogFactory.getLog(CsvConsumerForIndividualObservation.class);

    public CsvConsumerForIndividualObservation(Path file, char separator, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, IndividualObservationModel.forImport(separator, parserFactory), reportError);
    }

    public GenericFormatImportOperationContext validateRow(ImportRow<IndividualObservationRow> row, GenericFormatContextSupport importContext) {
        GenericFormatImportOperationContext operationContext = importContext.getValidationHelper().getFishingOperationContext(this, row, importContext);
        if (operationContext != null) {
            IndividualObservationRow bean = (IndividualObservationRow)row.getBean();
            Caracteristic caracteristic = bean.getCaracteristic();
            if (caracteristic == null) {
                // empty if block
            }
            if (bean.getCaracteristicValue() == null) {
                // empty if block
            }
            String value = (String)((Object)bean.getCaracteristicValue());
            try {
                Serializable serializable = importContext.parseCaracteristicValue(caracteristic, value);
                bean.setCaracteristicValue(serializable);
            }
            catch (CaracteristicValueParseException e) {
                this.addCheckError(row, e);
            }
        }
        this.reportError(row);
        return operationContext;
    }

    public void prepareRowForPersist(GenericFormatImportOperationContext operationContext, ImportRow<IndividualObservationRow> row) {
        IndividualObservationRow bean = (IndividualObservationRow)row.getBean();
        Integer batchId = bean.getBatchId();
        IndividualObservationBatch batch = operationContext.getIndividualObservationBatchesById(batchId);
        if (batch == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Detects individualObservationBatch: " + batchId));
            }
            batch = IndividualObservationBatchs.newIndividualObservationBatch();
            batch.setFishingOperation(operationContext.getFishingOperation());
            batch.setCaracteristics(new CaracteristicMap());
            batch.setComment(bean.getComment());
            batch.setSpecies(bean.getSpecies());
            batch.setId(bean.getBatchId());
            operationContext.addIndividualObservationBatch(batchId, batch);
        }
        batch.getCaracteristics().put((Object)bean.getCaracteristic(), (Object)bean.getCaracteristicValue());
    }
}

