/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.SybaseASADatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropUniqueConstraintStatement;

@DatabaseChange(name="dropUniqueConstraint", description="Drops an existing unique constraint", priority=1, appliesTo={"uniqueConstraint"})
public class DropUniqueConstraintChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String constraintName;
    private String uniqueColumns;

    @DatabaseChangeProperty(mustEqualExisting="uniqueConstraint.table.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="uniqueConstraint.table.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="uniqueConstraint.table", description="Name of the table to drop the unique constraint from")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(mustEqualExisting="uniqueConstraint", description="Name of unique constraint to drop")
    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getUniqueColumns() {
        return this.uniqueColumns;
    }

    public void setUniqueColumns(String uniqueColumns) {
        this.uniqueColumns = uniqueColumns;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        DropUniqueConstraintStatement statement = new DropUniqueConstraintStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getConstraintName());
        if (database instanceof SybaseASADatabase) {
            statement.setUniqueColumns(this.uniqueColumns);
        }
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Unique constraint " + this.getConstraintName() + " dropped from " + this.getTableName();
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

