/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;

public interface IPDFTableLayoutManager {
    public void startRow(IRowContent var1);

    public void updateRow(RowArea var1, int var2);

    public int getXPos(int var1);

    public void startCell(ICellContent var1);

    public int getCellWidth(int var1, int var2);

    public void resolveBorderConflict(CellArea var1);

    public TableLayoutInfo getLayoutInfo();

    public static class TableLayoutInfo {
        protected int columnNumber;
        protected int tableWidth;
        protected int[] colWidth = null;
        protected int[] xPositions = null;

        public TableLayoutInfo(int[] colWidth) {
            this.colWidth = colWidth;
            this.columnNumber = colWidth.length;
            this.xPositions = new int[this.columnNumber];
            this.tableWidth = 0;
            int i = 0;
            while (i < this.columnNumber) {
                this.xPositions[i] = this.tableWidth;
                this.tableWidth += colWidth[i];
                ++i;
            }
        }

        public int getTableWidth() {
            return this.tableWidth;
        }

        public int getXPosition(int index) {
            return this.xPositions[index];
        }

        public int getCellWidth(int startColumn, int endColumn) {
            assert (startColumn < endColumn);
            assert (this.colWidth != null);
            int sum = 0;
            int i = startColumn;
            while (i < endColumn) {
                sum += this.colWidth[i];
                ++i;
            }
            return sum;
        }
    }
}

