/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessorService;
import org.eclipse.birt.data.engine.olap.cursor.SubRowDataAccessor;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;

public class EdgeAxis
implements IEdgeAxis {
    private DimensionAxis[] dimensionAxis;
    private IAggregationResultSet rs;
    private IRowDataAccessor dataAccessor;
    private boolean isCalculatedMember = false;
    private RowDataAccessorService service;

    public EdgeAxis(IAggregationResultSet resultSet, BirtEdgeView view, boolean isCalculatedMember) throws IOException {
        this(resultSet, view, null, isCalculatedMember);
    }

    public EdgeAxis(IAggregationResultSet resultSet, BirtEdgeView view, List sortList, boolean isCalculatedMember) throws IOException {
        this.rs = resultSet;
        this.isCalculatedMember = isCalculatedMember;
        this.populateDimensionAxis(resultSet, view);
        this.service = new RowDataAccessorService(this.dimensionAxis, view);
        this.dataAccessor = new RowDataAccessor(this.service, this.rs);
        int i = 0;
        while (i < this.dimensionAxis.length) {
            this.dimensionAxis[i].setEdgeInfo(this.dataAccessor);
            ++i;
        }
    }

    public EdgeAxis(IRowDataAccessor parent, BirtEdgeView view, List sortList, boolean isPage, int startingLevelIndex) throws IOException {
        this(parent.getAggregationResultSet(), view, sortList, isPage);
        this.dataAccessor = new SubRowDataAccessor(parent.getRowDataAccessorService(), parent, startingLevelIndex);
        int i = 0;
        while (i < this.dimensionAxis.length) {
            this.dimensionAxis[i].setEdgeInfo(this.dataAccessor);
            ++i;
        }
    }

    private void populateDimensionAxis(IAggregationResultSet rs, BirtEdgeView view) throws IOException {
        ArrayList<DimensionAxis> dimensionAxisList = new ArrayList<DimensionAxis>();
        int index = -1;
        int levelIndex = -1;
        if (!this.isCalculatedMember) {
            index = 0;
            levelIndex = 0;
            int i = 0;
            while (i < view.getDimensionViews().size()) {
                BirtDimensionView dv = (BirtDimensionView)view.getDimensionViews().get(i);
                for (ILevelDefinition level : dv.getMemberSelection()) {
                    DimensionAxis axis = new DimensionAxis(this, rs, index, levelIndex);
                    axis.setLevelDefinition(level);
                    ++index;
                    ++levelIndex;
                    dimensionAxisList.add(axis);
                }
                ++i;
            }
        } else if (this.isCalculatedMember) {
            DimensionAxis axis = new DimensionAxis(this, rs, index, 0);
            dimensionAxisList.add(axis);
        }
        this.dimensionAxis = new DimensionAxis[dimensionAxisList.size()];
        int i = 0;
        while (i < dimensionAxisList.size()) {
            this.dimensionAxis[i] = (DimensionAxis)dimensionAxisList.get(i);
            ++i;
        }
    }

    @Override
    public void populateEdgeInfo(boolean isPage) throws OLAPException {
        if (this.dataAccessor != null) {
            try {
                this.dataAccessor.initialize(isPage);
            }
            catch (IOException e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public IRowDataAccessor getRowDataAccessor() {
        return this.dataAccessor;
    }

    @Override
    public DimensionAxis getDimensionAxis(int index) {
        return this.dimensionAxis[index];
    }

    @Override
    public DimensionAxis[] getAllDimensionAxis() {
        return this.dimensionAxis;
    }

    @Override
    public IAggregationResultSet getQueryResultSet() {
        return this.rs;
    }
}

