/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.valueexpr;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.ValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.CombinedValueExpressionOperator;

public class CombinedValueExpression
extends ValueExpression {
    private ValueExpression m_leftExpr;
    private ValueExpression m_rightExpr;
    private CombinedValueExpressionOperator m_operator;

    public CombinedValueExpression(ValueExpression leftExpr, CombinedValueExpressionOperator operator, ValueExpression rightExpr) {
        if (leftExpr == null || rightExpr == null || operator == null) {
            throw new NullPointerException(Messages.bind((String)Messages.querySpec_NULL_CONSTRUCTOR_3ARGS, (Object[])new Object[]{CombinedValueExpression.class.getName(), leftExpr, operator, rightExpr}));
        }
        this.m_leftExpr = leftExpr;
        this.m_rightExpr = rightExpr;
        this.m_operator = operator;
    }

    public ValueExpression getLeftExpression() {
        return this.m_leftExpr;
    }

    public ValueExpression getRightExpression() {
        return this.m_rightExpr;
    }

    public CombinedValueExpressionOperator getCombinedOperator() {
        return this.m_operator;
    }

    @Override
    public void validateSyntax(ValidationContext context) throws OdaException {
        this.m_leftExpr.validateSyntax(context);
        this.m_rightExpr.validateSyntax(context);
    }

    @Override
    public String getName() {
        return String.valueOf(this.m_leftExpr.getName()) + "_" + this.m_operator.getLiteral() + "_" + this.m_rightExpr.getName();
    }

    @Override
    public Integer getOdaDataType() {
        Integer rightOdaDataType;
        if (super.getOdaDataType() != null) {
            return super.getOdaDataType();
        }
        if (CombinedValueExpressionOperator.get(this.m_operator.getId()) == null) {
            return UNKNOWN_ODA_DATA_TYPE;
        }
        if (this.m_operator.getId().equals("Concatenate")) {
            return 1;
        }
        Integer leftOdaDataType = this.m_leftExpr.getOdaDataType();
        if (leftOdaDataType == (rightOdaDataType = this.m_rightExpr.getOdaDataType()) || leftOdaDataType != null && leftOdaDataType.equals(rightOdaDataType)) {
            return rightOdaDataType;
        }
        if (leftOdaDataType == null || leftOdaDataType == UNKNOWN_ODA_DATA_TYPE || rightOdaDataType == null || rightOdaDataType == UNKNOWN_ODA_DATA_TYPE) {
            return UNKNOWN_ODA_DATA_TYPE;
        }
        if (CombinedValueExpression.isNumeric(leftOdaDataType) && CombinedValueExpression.isNumeric(rightOdaDataType)) {
            int leftOdaDataTypeCode = leftOdaDataType;
            int rightOdaDataTypeCode = rightOdaDataType;
            if (leftOdaDataTypeCode == 3 || rightOdaDataTypeCode == 3) {
                return 3;
            }
            if (leftOdaDataTypeCode == 8 || rightOdaDataTypeCode == 8) {
                return 8;
            }
            if (leftOdaDataTypeCode == 4 || rightOdaDataTypeCode == 4) {
                return 4;
            }
        }
        return UNKNOWN_ODA_DATA_TYPE;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(CombinedValueExpression.class.getSimpleName()) + " ");
        buffer.append(String.valueOf(this.m_leftExpr.getName()) + " " + this.m_operator.getLiteral() + " " + this.m_rightExpr.getName());
        buffer.append("\n     leftExpr= {" + this.m_leftExpr + "} ");
        buffer.append("\n     operator= " + this.m_operator);
        buffer.append("\n     rightExpr= {" + this.m_rightExpr + "} ");
        return buffer.toString();
    }
}

