package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class SplitBenthosBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SplitBenthosBatchUIModel, SplitBenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_WEIGHT_FIELD_TEXT = "batchWeightField.text";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1XTW8bRRieuLHz0YQ2iVJaWpDbUkhKmLQSiEqh0NgkbYLTIuxA1BzCeHdiTzveWXZnU1dWED+BnwB3LkjcOCEOXOmBS8VfQIgDV8Q7s+tdj7/WCAUfVt6Z93m/55l3v/0dZX0PXX5Emk3sBY5kDYq31/f2HlQfUUt+QH3LY64UHgp/YxmU2Uen7Xjdl+jqfknBVyP4alE0XOFQpwO9VkLTvnzKqV+nVEr0somwfH+1HG+vNd3Aa2uNneqn9es//8h8ZX/5TQahpgvezUEo+TRUEsl4CWWYLdE8WDoiq5w4NXDDY04N/J1Va0VOfP8+adDP0RdoooRyLvFAmURXRg9Z69D4pivRBd/lTBZAtC78ApFWvSLcj4hDuUS7hx5mhx5tUA/LQEqGA4b9J+APtoQjAYOFSz0imXCwpbDUx9VQFdZ6cblb++6W62rrOYmyDWErOw9PxM6OUp4YmzoinNkEMiHRG0ZN4o3IZlk9P2kvJhpyVU88pgBfHuxvRb3eA7sFLZuA5yGSQ1YLwiiiBJ83/Ig0kCrX5Z2KsbMQM60J72mJVBVsXrVCM5Lf1otKcjEGnG0DoA+qoiCaEi0amPa6CZt5dbtMoaNU2DckOmdA4p0uU1WV7U8pq9Vl7MlLg2U2GeV2t+4KbYYbJm7OJw2X0+HKDaFYyTVT6IxUWS1bnuBc5V6iF83g4h0z81mNk+ii8Gr4EbDMYyncENTE23txra7HiNPE6iiwWSm9aBqYsYhjUV6AtoFORwuGfLiqJG/EgGmfHNFk4+1o10MXjV4CBsMJgyUUM7aPsl4Ay9B8+72k9zFshXR3vovulEK9+/e5hV9/+O37zTbHzYLtxb6iHRQN3ON66gxLpkyfCQkukIyv7hB3bR9N+ZQDv2v+vtTHsXK0Dc6BvTkFxwqO7xG/DiqyE89//OncZ89OocwmmuaC2JtEyW+hKVn3IAuC2033/Tvao5knk/A8q3yDEh/U4bhKlG9dCc9yDyFiJXDluAlZudQnK7Fr1amf/1oof3ennZkx8PTCQPEkO9mHKMcczhyq+T+i9r58f9r1aWCLhML7kToaxupuREm39XO9X0ZyVeHZiudeaTn0Sb7CJKd2Qa8tOQHnK3n1XIaEKBUbOlL17y7qS3NpFsclmuTqcG8qap5vdXPXsQQRIAiJXhtUoEN17HEbCIdQCsErzK1o2PXRYFjCPRm3w1uD28GEacqJW6Q3IyZ5pyUjA5QQHgVqb0nagNGkpW9JXKOyHG0UI41Ly8cn4HDP5ZHmc7argN1snxRwebiHHUCJXjggth2+7DoMFlZadeLYHO5cSEVRt9nSsvofaUpkdV7MHnhzZMtmG7yTltXuYIcltvuqHOFkTFBH3TFwY2YPCfdpnMqllmoIPRzCqBLQpbhLComVpWWViUlqs+geays56fC07L87+Autnos8aZyUI9yJ7K48Hh1qlv5WWm56/B2SnN5RJi07p5JTM7DU5Q6lYa2nDiwY/QOpOmZcegH9P+IZqdrZzma+NozU8pdv6xsGwpkNuRCuEjXNK1yJ+REkWuS4vHX/bmnjoLxR2ihWth7cVy3vQ0uZLb8Qq4J2ozVPBA44MtsqCg6Tf6G0XvzwuFOqQKzHbalcS/vTLxHhhJgWfC4u5rVBNQjnRhzOgzDnhe9b6gMI5dqrswc+U3lf15sSidZ//3QKDfm9n1BFbXQ98ksNGJCgGXbzlrPj0IZwmDXkdBnh4EYMMA/nwAvBhBvnEg/uYxM1uHuNqTutdhOdjTsXNS7z9Qeivmmiyl5N8UoN7l11HQ/XuqvaOMmqlsHk8JqujBDIwIq+PgrYqOdKaj01ZnA1Oz6JRpluOXkqAjVgvAvf9yRfZY4NiX2vR/OYek6nalTLv6jHs/4aboKGfwCHnTP21hIAAA==";
    private static final Log log = LogFactory.getLog(SplitBenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JTextField batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected JComboBox categoryComboBox;
    protected JLabel categoryLabel;
    protected Table configurationPanel;
    protected final SplitBenthosBatchUIHandler handler = createHandler();
    protected SplitBenthosBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveButton;
    protected SplitBenthosBatchUI splitBenthosBatchTopPanel = this;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<SplitBenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SplitBenthosBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SplitBenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SplitBenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitBenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SplitBenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitBenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SplitBenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitBenthosBatchUI() {
        $initialize();
    }

    public SplitBenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JTextField getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JComboBox getCategoryComboBox() {
        return categoryComboBox;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public SplitBenthosBatchUIHandler getHandler() {
        return handler;
    }

    public SplitBenthosBatchUIModel getModel() {
        return model;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<SplitBenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(categoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add($JSeparator0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSplitBenthosBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new JTextField());
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setColumns(15);
        batchWeightField.setEnabled(false);
        batchWeightField.setEditable(false);
        batchWeightField.putClientProperty("help", "tutti.splitBenthosBatch.field.batchWeightField.help");
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(t("tutti.splitBenthosBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(t("tutti.splitBenthosBatch.field.batchWeight.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.splitBenthosBatch.field.batchWeightField.help");
        batchWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.splitBenthosBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.splitBenthosBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.splitBenthosBatch.action.cancel.tip"));
        cancelButton.putClientProperty("help", "tutti.splitBenthosBatch.action.cancel.help");
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.actions.SplitBenthosBatchCancelAction.class);
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new JComboBox());
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.putClientProperty("help", "tutti.splitBenthosBatch.field.categoryField.help");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(t("tutti.splitBenthosBatch.field.category"));
        categoryLabel.setToolTipText(t("tutti.splitBenthosBatch.field.category.tip"));
        categoryLabel.putClientProperty("help", "tutti.splitBenthosBatch.field.categoryField.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected SplitBenthosBatchUIHandler createHandler() {
        return new SplitBenthosBatchUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SplitBenthosBatchUIModel.class));
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.putClientProperty("help", "tutti.splitBenthosBatch.field.sampleWeightField.help");
        sampleWeightField.putClientProperty("computed", true);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(t("tutti.splitBenthosBatch.field.sampleWeight"));
        sampleWeightLabel.setToolTipText(t("tutti.splitBenthosBatch.field.sampleWeight.tip"));
        sampleWeightLabel.putClientProperty("help", "tutti.splitBenthosBatch.field.sampleWeightField.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.splitBenthosBatch.action.save"));
        saveButton.setToolTipText(t("tutti.splitBenthosBatch.action.save.tip"));
        saveButton.putClientProperty("help", "tutti.splitBenthosBatch.action.save.help");
        saveButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.actions.SplitBenthosBatchSaveAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SplitBenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSplitBenthosBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToTableScrollPane();
        addChildrenToActionPanel();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        configurationPanel.setBorder(new TitledBorder(null, null));
        categoryLabel.setLabelFor(categoryComboBox);
        batchWeightLabel.setLabelFor(batchWeightField);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.splitBenthosBatch.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.splitBenthosBatch.action.save.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, splitBenthosBatchTopPanel, "tutti.splitBenthosBatch.help");
        registerHelpId(_broker, categoryLabel, "tutti.splitBenthosBatch.field.categoryField.help");
        registerHelpId(_broker, categoryComboBox, "tutti.splitBenthosBatch.field.categoryField.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.splitBenthosBatch.field.batchWeightField.help");
        registerHelpId(_broker, batchWeightField, "tutti.splitBenthosBatch.field.batchWeightField.help");
        registerHelpId(_broker, sampleWeightLabel, "tutti.splitBenthosBatch.field.sampleWeightField.help");
        registerHelpId(_broker, sampleWeightField, "tutti.splitBenthosBatch.field.sampleWeightField.help");
        registerHelpId(_broker, cancelButton, "tutti.splitBenthosBatch.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.splitBenthosBatch.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("splitBenthosBatchTopPanel", splitBenthosBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createCategoryLabel();
        createCategoryComboBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createBatchWeightLabel();
        createBatchWeightField();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        createActionPanel();
        createCancelButton();
        createSaveButton();
        // inline creation of splitBenthosBatchTopPanel
        setName("splitBenthosBatchTopPanel");
        setLayout(new BorderLayout());
        splitBenthosBatchTopPanel.putClientProperty("help", "tutti.splitBenthosBatch.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(batchWeightField, getStringValue(model.getBatchWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}