package fr.ifremer.tutti.ui.swing.content.category;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class EditSampleCategoryModelUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditSampleCategoryModelUIModel, EditSampleCategoryModelUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ROW_ENABLED = "addRow.enabled";
    public static final String BINDING_AVAILABLE_CARACTERISTICS_COMBO_BOX_ENABLED = "availableCaracteristicsComboBox.enabled";
    public static final String BINDING_EXPORT_BUTTON_ENABLED = "exportButton.enabled";
    public static final String BINDING_MOVE_DOWN_ENTRY_MENU_ENABLED = "moveDownEntryMenu.enabled";
    public static final String BINDING_MOVE_UP_ENTRY_MENU_ENABLED = "moveUpEntryMenu.enabled";
    public static final String BINDING_REMOVE_ENTRY_MENU_ENABLED = "removeEntryMenu.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVYz28bRRSeuLHTJC2lifoDtVCntFFDy6a0BVGFQhPXoQ5OW8UuippDGO9OkmnXO8vsuNnICuJP4E+AOxckbpwQB84cuCBOcEaIA1fEm1l7fzi72V1TcnCSmfe+efO+976Z8dd/oKLD0cxT7Loa71iCtom2sri+/rD1lOjiHnF0Tm3BOPJ+RgqosIEmDX/cEej1jbp0n++5z1dY22YWsULeC3U04Yg9kzg7hAiBXo166I4z3/CnF1y7w/uoflBxqF/+9WfhC+PzrwoIuTZE9zJspZzmFexktI4K1BBoClZ6judNbG1DGJxa2xDvcTlWMbHjPMBt8in6DI3VUcnGHMAEuph9ywpD+bu2QBeIQUUDt22YwIJsM763ygxiNpn9CFvEFOjeFtfoFidtwjXREYJqHao5uxCVpjNLwCKa3vPUqvFgj2u2rZYsCVRsyxGBai8CVv0KsEstzp4RLtBcMnhT/nsfvJaUbeA8IXDLJI+Y3YG0nJbZdnsuK2pwlVidwPoEgLPnpGoJCAZmBDoVcZFjNUHa0nwq8JI+j23fSw6fiZqclCb32K51mNHYpaYM9rpAZyPl1duinJOW477DBYiNmnK8gjnWBeHUEVR3oFBabIm5Ar0dAyRrg3GtRbClLcHHMjXBU6H0/CT8+SD/2DDW2K5A05FcLEHKmRU1PaGy3dA5M01ZaAKdifgEM1G/ovIT6Bzj29pT6Ptngtmek6utrPtbv+x7HL20oioZkjUVZVWORtEndZM5JIj3kvy4GpSIg58nzx4jrs24ODjP0blIckFetEBegv4f2UBF3oFhoHXjoCKtwZSnRWcHtEgCqtl/Tk///N2v3y73BeglWPtUrGlIP0EYbM5s6Bsqlz7hqU9HUHN+FdsLG2jcISaIrxLX8zGBNXrTEBysd1K6a9Jdu4+dHYAojv3y/Q+nP/npCCosowmTYWMZS/saGhc7HLLATMO1P7irIjq2e1Qqp4xNwMo7bHeNOFKjRwXvEBd2fz5m934IrfEf/55ufHO3n4ERiOiVRPMgC8UnqEQtk1pEiXBPX2NFd9J2SMdggY7GKSuSIhLfMz0Rua0+78Rtu7i5AwIl0Gz3oqdeCSKtSbOL+66SiEW1W/lXBaXrup0SxahAxz3aKbOkp0CXu3UQjUZ40NQatQcf1qubjWq9WmnWHj7Yh4ZzoAu8Li1uYRPIQ9M+1DLjZJuzjgXn3PFuhZmgL0v1xcpH+2GrJaw/61uVulbHNGM36YlB2lYKoJfEkpaAdq07kyKFGnWqbVvsXZmTe+l1xh7ouxcdMSJusblPWSFD7oOAF7pp8W6THinEkCfOlbnyzJ2yyhkoFlb5rMkjFR0BeYasbzpUlsWimhHocTfHSezBOdqiYUSLC2TfA9R02QX7QRHfSitiD1Pzzo5DSrp3uqRlbyycvde66roBnK4F53XVm1UEjwrigrhczxRi6MwfSG0JrIggB7O7Pkx2vVjTEnyMvvWutWqBrUV1gW7n3YLW9n0nBWNmk9pNlYxbuZEEXDF9wm9nJDwMkMz64EVrSPpXg4vX0PSHLm8D9BfknfGFUO/F+b9QHwr/P1IfRhqK+jDAIdQP3JZzUV+OUO9fqGPIv5E5ZB9lgP5RAyYOFsCTYQtArpOzBBbybyKxCN4ZAitSBgs5yiCASC6Eg2+itFIo+ey+kSkSde8f1HQdW7p8qk5tYts2KVAFc31ylzOQ2+f0oU2s+6wtnzuEWIcTeTN7vIkEajkwIsTdzEic55pMWPgdlatrL4e61qBbcAkrz86W+2MfY5NGWncuU7Ty1TbYsd5YLLND6XYDDx7YKoTDuc6mPDLURKrfzA4RYfpGRqaVZzLRoRdxLp5nuzO5iL6aKVjvAT7Yxv3RWLKH0uiqQsxNd7bD1Qs3kfD5PCARyrNexHu+yaRHvuhIox2esyUT7zEwRi+9Z2CByy1qGZDf9w9gj8jPiQyIR+VXUs09Wz3Jf4/HKafiyOHfDkG4Bgj/Al6jLOeRFgAA";
    private static final Log log = LogFactory.getLog(EditSampleCategoryModelUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRow;
    protected BeanFilterableComboBox<Caracteristic> availableCaracteristicsComboBox;
    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected EditSampleCategoryModelUI editSampleCategoryModelTopPanel = this;
    protected JButton exportButton;
    protected final EditSampleCategoryModelUIHandler handler = createHandler();
    protected EditSampleCategoryModelUIModel model;
    protected JMenuItem moveDownEntryMenu;
    protected JMenuItem moveUpEntryMenu;
    protected JMenuItem removeEntryMenu;
    protected JButton saveButton;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditSampleCategoryModelUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditSampleCategoryModelUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditSampleCategoryModelUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditSampleCategoryModelUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditSampleCategoryModelUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditSampleCategoryModelUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditSampleCategoryModelUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditSampleCategoryModelUI() {
        $initialize();
    }

    public EditSampleCategoryModelUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRow() {
        return addRow;
    }

    public BeanFilterableComboBox<Caracteristic> getAvailableCaracteristicsComboBox() {
        return availableCaracteristicsComboBox;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JButton getExportButton() {
        return exportButton;
    }

    public EditSampleCategoryModelUIHandler getHandler() {
        return handler;
    }

    public EditSampleCategoryModelUIModel getModel() {
        return model;
    }

    public JMenuItem getMoveDownEntryMenu() {
        return moveDownEntryMenu;
    }

    public JMenuItem getMoveUpEntryMenu() {
        return moveUpEntryMenu;
    }

    public JMenuItem getRemoveEntryMenu() {
        return removeEntryMenu;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditSampleCategoryModelTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeEntryMenu);
        tablePopup.add(moveUpEntryMenu);
        tablePopup.add(moveDownEntryMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void createAddRow() {
        $objectMap.put("addRow", addRow = new JButton());
        
        addRow.setName("addRow");
        addRow.putClientProperty("help", "tutti.editSampleCategoryModel.action.addRow.help");
        addRow.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.category.actions.AddSampleCategoryRowAction.class);
    }

    protected void createAvailableCaracteristicsComboBox() {
        $objectMap.put("availableCaracteristicsComboBox", availableCaracteristicsComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        availableCaracteristicsComboBox.setName("availableCaracteristicsComboBox");
        availableCaracteristicsComboBox.setProperty("selectedCaracteristic");
        availableCaracteristicsComboBox.setShowReset(true);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editSampleCategoryModel.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.editSampleCategoryModel.action.close"));
        closeButton.setToolTipText(t("tutti.editSampleCategoryModel.action.close.tip"));
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenHomeScreenAction.class);
        closeButton.putClientProperty("help", "tutti.editSampleCategoryModel.action.close.help");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new JButton());
        
        exportButton.setName("exportButton");
        exportButton.setText(t("tutti.editSampleCategoryModel.action.export"));
        exportButton.setToolTipText(t("tutti.editSampleCategoryModel.action.export.tip"));
        exportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.category.actions.ExportSampleCategoryModelAction.class);
        exportButton.putClientProperty("help", "tutti.editSampleCategoryModel.action.export.help");
    }

    protected EditSampleCategoryModelUIHandler createHandler() {
        return new EditSampleCategoryModelUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditSampleCategoryModelUIModel.class));
    }

    protected void createMoveDownEntryMenu() {
        $objectMap.put("moveDownEntryMenu", moveDownEntryMenu = new JMenuItem());
        
        moveDownEntryMenu.setName("moveDownEntryMenu");
        moveDownEntryMenu.setText(t("tutti.editSampleCategoryModel.action.moveDownEntry"));
        moveDownEntryMenu.setToolTipText(t("tutti.editSampleCategoryModel.action.moveDownEntry.tip"));
        moveDownEntryMenu.putClientProperty("help", "tutti.editSampleCategoryModel.action.moveDownEntry.help");
        moveDownEntryMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.category.actions.MoveDownSampleCategoryRowAction.class);
    }

    protected void createMoveUpEntryMenu() {
        $objectMap.put("moveUpEntryMenu", moveUpEntryMenu = new JMenuItem());
        
        moveUpEntryMenu.setName("moveUpEntryMenu");
        moveUpEntryMenu.setText(t("tutti.editSampleCategoryModel.action.moveUpEntry"));
        moveUpEntryMenu.setToolTipText(t("tutti.editSampleCategoryModel.action.moveUpEntry.tip"));
        moveUpEntryMenu.putClientProperty("help", "tutti.editSampleCategoryModel.action.moveUpEntry.help");
        moveUpEntryMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.category.actions.MoveUpSampleCategoryRowAction.class);
    }

    protected void createRemoveEntryMenu() {
        $objectMap.put("removeEntryMenu", removeEntryMenu = new JMenuItem());
        
        removeEntryMenu.setName("removeEntryMenu");
        removeEntryMenu.setText(t("tutti.editSampleCategoryModel.action.removeEntry"));
        removeEntryMenu.setToolTipText(t("tutti.editSampleCategoryModel.action.removeEntry.tip"));
        removeEntryMenu.putClientProperty("help", "tutti.editSampleCategoryModel.action.removeEntry.help");
        removeEntryMenu.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.category.actions.RemoveSampleCategoryRowAction.class);
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editSampleCategoryModel.action.save"));
        saveButton.setToolTipText(t("tutti.editSampleCategoryModel.action.save.tip"));
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.category.actions.SaveSampleCategoryModelAction.class);
        saveButton.putClientProperty("help", "tutti.editSampleCategoryModel.action.save.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditSampleCategoryModelTopPanel();
        addChildrenToTablePopup();
        // inline complete setup of $Table0
        $Table0.add(availableCaracteristicsComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addRow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(tableScrollPane, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTableScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(closeButton);
        $JPanel0.add(saveButton);
        $JPanel0.add(exportButton);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 19 property setters
        availableCaracteristicsComboBox.setBeanType(Caracteristic.class);
        removeEntryMenu.setIcon(SwingUtil.createActionIcon("delete"));
        removeEntryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSampleCategoryModel.action.removeEntry.mnemonic"),'Z'));
        moveUpEntryMenu.setIcon(SwingUtil.createActionIcon("up"));
        moveUpEntryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSampleCategoryModel.action.moveUpEntry.mnemonic"),'Z'));
        moveDownEntryMenu.setIcon(SwingUtil.createActionIcon("down"));
        moveDownEntryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSampleCategoryModel.action.moveDownEntry.mnemonic"),'Z'));
        addRow.setIcon(SwingUtil.createActionIcon("add"));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSampleCategoryModel.action.close.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSampleCategoryModel.action.save.mnemonic"),'Z'));
        exportButton.setIcon(SwingUtil.createActionIcon("export"));
        exportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSampleCategoryModel.action.export.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editSampleCategoryModelTopPanel, "tutti.editSampleCategoryModel.help");
        registerHelpId(_broker, removeEntryMenu, "tutti.editSampleCategoryModel.action.removeEntry.help");
        registerHelpId(_broker, moveUpEntryMenu, "tutti.editSampleCategoryModel.action.moveUpEntry.help");
        registerHelpId(_broker, moveDownEntryMenu, "tutti.editSampleCategoryModel.action.moveDownEntry.help");
        registerHelpId(_broker, addRow, "tutti.editSampleCategoryModel.action.addRow.help");
        registerHelpId(_broker, closeButton, "tutti.editSampleCategoryModel.action.close.help");
        registerHelpId(_broker, saveButton, "tutti.editSampleCategoryModel.action.save.help");
        registerHelpId(_broker, exportButton, "tutti.editSampleCategoryModel.action.export.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editSampleCategoryModelTopPanel", editSampleCategoryModelTopPanel);
        createModel();
        createBroker();
        createTablePopup();
        createRemoveEntryMenu();
        createMoveUpEntryMenu();
        createMoveDownEntryMenu();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createAvailableCaracteristicsComboBox();
        createAddRow();
        createTableScrollPane();
        createTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createSaveButton();
        createExportButton();
        // inline creation of editSampleCategoryModelTopPanel
        setName("editSampleCategoryModelTopPanel");
        setLayout(new BorderLayout());
        editSampleCategoryModelTopPanel.putClientProperty("help", "tutti.editSampleCategoryModel.help");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ENTRY_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEntryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeEntryMenu.setEnabled(model.isRemoveEntryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEntryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MOVE_UP_ENTRY_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("moveUpEntryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    moveUpEntryMenu.setEnabled(model.isMoveUpEntryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("moveUpEntryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MOVE_DOWN_ENTRY_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("moveDownEntryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    moveDownEntryMenu.setEnabled(model.isMoveDownEntryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("moveDownEntryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AVAILABLE_CARACTERISTICS_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (availableCaracteristicsComboBox != null) {
                    availableCaracteristicsComboBox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (availableCaracteristicsComboBox != null) {
                    availableCaracteristicsComboBox.setEnabled(!availableCaracteristicsComboBox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (availableCaracteristicsComboBox != null) {
                    availableCaracteristicsComboBox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (availableCaracteristicsComboBox != null) {
                    availableCaracteristicsComboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (availableCaracteristicsComboBox != null) {
                    addRow.setEnabled(availableCaracteristicsComboBox.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (availableCaracteristicsComboBox != null) {
                    availableCaracteristicsComboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportButton.setEnabled(!model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}