// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEmbeddedValue.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.type;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.util.Date;

/**
 * Position géographique ponctuele datée (point + date/heure).
 */
public abstract class DateTimePosition
    implements Serializable, Comparable<DateTimePosition>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -6920512159144003675L;

    /**
     * Creates a new instance of {@link DateTimePosition}
     * taking all properties.
     * @param dateTime
     * @param longitude
     * @param latitude
     * @return object
     */
    public static DateTimePosition newInstance(Date dateTime,Float longitude,Float latitude)
    {
        DateTimePositionImpl object = new DateTimePositionImpl();
        object.setDateTime(dateTime);
        object.setLongitude(longitude);
        object.setLatitude(latitude);
        object.initialize();
        return object;
    }

    /**
     * Creates a new instance from other DateTimePosition instance.
     * @param otherObject
     * @return newInstance
     */
    public static DateTimePosition newInstance(DateTimePosition otherObject)
    {
        if (otherObject != null)
        {
            return newInstance(otherObject.getDateTime(),otherObject.getLongitude(),otherObject.getLatitude());
        }
        return null;
    }

    /**
     * Default protected empty constructor
     */
    protected DateTimePosition()
    {
        // Default protected empty constructor
    }

    /**
     * Hook for initializing the object in the subclass. Empty method.
     */
    protected void initialize()
    {
        // Empty block comment
    }

    // EmbeddedValue attributes

    private Date dateTime;

    /**
     * Date et heure de la position.
     * @return dateTime
     */
    public Date getDateTime()
    {
        return this.dateTime;
    }

    /**
     * Date et heure de la position.
     * @param dateTimeIn
     */
    public void setDateTime(Date dateTimeIn)
    {
        this.dateTime = dateTimeIn;
    }

    private Float longitude;

    /**
     * Longitude de la position, exprimée en WGS84.
     * @return longitude
     */
    public Float getLongitude()
    {
        return this.longitude;
    }

    /**
     * Longitude de la position, exprimée en WGS84.
     * @param longitudeIn
     */
    public void setLongitude(Float longitudeIn)
    {
        this.longitude = longitudeIn;
    }

    private Float latitude;

    /**
     * Latitude de la position, exprimée en WGS84.
     * @return latitude
     */
    public Float getLatitude()
    {
        return this.latitude;
    }

    /**
     * Latitude de la position, exprimée en WGS84.
     * @param latitudeIn
     */
    public void setLatitude(Float latitudeIn)
    {
        this.latitude = latitudeIn;
    }

    /**
     * Indicates if the argument is of the same type and all values are equal.
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof DateTimePosition))
        {
            return false;
        }
        final DateTimePosition that = (DateTimePosition)object;
        if (this.dateTime == null || that.getDateTime() == null || !this.dateTime.equals(that.getDateTime()))
        {
            return false;
        }
        if (this.longitude == null || that.getLongitude() == null || !this.longitude.equals(that.getLongitude()))
        {
            return false;
        }
        if (this.latitude == null || that.getLatitude() == null || !this.latitude.equals(that.getLatitude()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     * @see Object#hashCode()
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.dateTime == null ? 0 : this.dateTime.hashCode());
        hashCode = 29 * hashCode + (this.longitude == null ? 0 : this.longitude.hashCode());
        hashCode = 29 * hashCode + (this.latitude == null ? 0 : this.latitude.hashCode());

        return hashCode;
    }
    /**
     * @see Comparable#compareTo
     */
    public int compareTo(DateTimePosition o)
    {
        int cmp = 0;
            if (this.getDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDateTime().compareTo(o.getDateTime()));
            }
            if (this.getLongitude() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLongitude().compareTo(o.getLongitude()));
            }
            if (this.getLatitude() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLatitude().compareTo(o.getLatitude()));
            }
        return cmp;
    }
}