// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.gear;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

/**
 * Une classification d'engin permet le regroupement d'un ensemble cohérent d'engin.
 * Exemple :
 * - Engin FAO, appellée aussi CSITEP (Classification Standard Internationale Type des Engins de
 * Pêche), ou, en anglais : International Standard Statistical Classification of Fishing Gear
 * (ISSCFG) : ftp://ftp.fao.org/FI/DOCUMENT/cwp/handbook/annex/AnnexM1fishinggear.pdf
 * - Engin CNTS (DPMA SIP)
 * - Engin EU (basé sur les engins FAO, mais adapté au contexte réglementaire européen) :
 * exemple : 	- extension pour signifier 'pas d'engin' : NO
 * extension pour signifier 'engin inconnu' : NK (Not Known)
 * 'ligne avec canne (...)' : BTF (code utilisé pour des données historique)
 * - 'Engin EU Corpus' pour le traitment (cf DRE_CORPUS dans tmpsih)
 * - Engin Métier Ifremer (basé sur la classification FAO, et etendue aux besoins Ifremer/francais)
 * Pour ObsMer, la classification utilisée est : FAO
 * Pour les observations au débarquement, la classification utilisée est : FAO + CNTS (pour
 * recroiser avec les déclarations)
 */
// HibernateEntity.vsl annotations merge-point
public abstract class GearClassification
    implements Serializable, Comparable<GearClassification>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 1749412795194260087L;

    // Generate 5 attributes
    private Integer id;

    /**
     * 
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * 
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * 
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * 
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Boolean isAggregation = Boolean.valueOf(false);

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * TODO : confirmer si l'attribut est utile
     * </p>
     * <p>
     * , dans la mesure ou les strat&#233;gies peuvent permettrent de choisir la
     * classification &#224; utiliser.<br>
     * </p>
     * <p>
     * Indicateur permettant de savoir si la classification est utilis&#233;
     * uniquement dans le cadre de donn&#233;es d'agr&#233;gation.
     * </p>
     * </body>
     * </html>
     * @return this.isAggregation Boolean
     */
    public Boolean isIsAggregation()
    {
        return this.isAggregation;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * TODO : confirmer si l'attribut est utile
     * </p>
     * <p>
     * , dans la mesure ou les strat&#233;gies peuvent permettrent de choisir la
     * classification &#224; utiliser.<br>
     * </p>
     * <p>
     * Indicateur permettant de savoir si la classification est utilis&#233;
     * uniquement dans le cadre de donn&#233;es d'agr&#233;gation.
     * </p>
     * </body>
     * </html>
     * @param isAggregationIn Boolean
     */
    public void setIsAggregation(Boolean isAggregationIn)
    {
        this.isAggregation = isAggregationIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 4 associations
    private Collection<Gear> gears = new HashSet<Gear>();

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * D&#233;fini un engin, non pas engin physique, mais au sens &quot;classe d'engin&quot;.
     * </p>
     * <p>
     * Il est possible de d&#233;finir un arboresence d'engin, au sein d'une meme
     * classification, via les liens d'engin parents/enfants.
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'Engin EU corpus' :
     * </p>
     * <p>
     * * 'corpus effort de p&#234;che'<br>- PAL Palangre de surface (Longliner)<br>
     * </p>
     * <p>
     * - EP1 Engins petits p&#233;lagiques - corpus r&#233;glementaire 685/95
     * </p>
     * <p>
     * * corpus 2 (...)<br>- ...
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'FAO/CISTEP' :<br>* 'chaluts' (code
     * '03.0.0')<br>
     * </p>
     * <p>
     * - 'OTB' 'chalut de fond'<br>
     * </p>
     * <p>
     * - chalut p&#233;lagique
     * </p>
     * <p>
     * - ...<br>* 'Filets'
     * </p>
     * </body>
     * </html>
     * @return this.gears Collection<Gear>
     */
    public Collection<Gear> getGears()
    {
        return this.gears;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * D&#233;fini un engin, non pas engin physique, mais au sens &quot;classe d'engin&quot;.
     * </p>
     * <p>
     * Il est possible de d&#233;finir un arboresence d'engin, au sein d'une meme
     * classification, via les liens d'engin parents/enfants.
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'Engin EU corpus' :
     * </p>
     * <p>
     * * 'corpus effort de p&#234;che'<br>- PAL Palangre de surface (Longliner)<br>
     * </p>
     * <p>
     * - EP1 Engins petits p&#233;lagiques - corpus r&#233;glementaire 685/95
     * </p>
     * <p>
     * * corpus 2 (...)<br>- ...
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'FAO/CISTEP' :<br>* 'chaluts' (code
     * '03.0.0')<br>
     * </p>
     * <p>
     * - 'OTB' 'chalut de fond'<br>
     * </p>
     * <p>
     * - chalut p&#233;lagique
     * </p>
     * <p>
     * - ...<br>* 'Filets'
     * </p>
     * </body>
     * </html>
     * @param gearsIn Collection<Gear>
     */
    public void setGears(Collection<Gear> gearsIn)
    {
        this.gears = gearsIn;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * D&#233;fini un engin, non pas engin physique, mais au sens &quot;classe d'engin&quot;.
     * </p>
     * <p>
     * Il est possible de d&#233;finir un arboresence d'engin, au sein d'une meme
     * classification, via les liens d'engin parents/enfants.
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'Engin EU corpus' :
     * </p>
     * <p>
     * * 'corpus effort de p&#234;che'<br>- PAL Palangre de surface (Longliner)<br>
     * </p>
     * <p>
     * - EP1 Engins petits p&#233;lagiques - corpus r&#233;glementaire 685/95
     * </p>
     * <p>
     * * corpus 2 (...)<br>- ...
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'FAO/CISTEP' :<br>* 'chaluts' (code
     * '03.0.0')<br>
     * </p>
     * <p>
     * - 'OTB' 'chalut de fond'<br>
     * </p>
     * <p>
     * - chalut p&#233;lagique
     * </p>
     * <p>
     * - ...<br>* 'Filets'
     * </p>
     * </body>
     * </html>
     * @param elementToAdd Gear
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGears(Gear elementToAdd)
    {
        return this.gears.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * D&#233;fini un engin, non pas engin physique, mais au sens &quot;classe d'engin&quot;.
     * </p>
     * <p>
     * Il est possible de d&#233;finir un arboresence d'engin, au sein d'une meme
     * classification, via les liens d'engin parents/enfants.
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'Engin EU corpus' :
     * </p>
     * <p>
     * * 'corpus effort de p&#234;che'<br>- PAL Palangre de surface (Longliner)<br>
     * </p>
     * <p>
     * - EP1 Engins petits p&#233;lagiques - corpus r&#233;glementaire 685/95
     * </p>
     * <p>
     * * corpus 2 (...)<br>- ...
     * </p>
     * <p>
     * <br>
     * </p>
     * <p>
     * Exemple, pour la classification 'FAO/CISTEP' :<br>* 'chaluts' (code
     * '03.0.0')<br>
     * </p>
     * <p>
     * - 'OTB' 'chalut de fond'<br>
     * </p>
     * <p>
     * - chalut p&#233;lagique
     * </p>
     * <p>
     * - ...<br>* 'Filets'
     * </p>
     * </body>
     * </html>
     * @param elementToRemove Gear
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGears(Gear elementToRemove)
    {
        return this.gears.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an GearClassification instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof GearClassification))
        {
            return false;
        }
        final GearClassification that = (GearClassification)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link GearClassification}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link GearClassification}.
         * @return new GearClassificationImpl()
         */
        public static GearClassification newInstance()
        {
            return new GearClassificationImpl();
        }

        /**
         * Constructs a new instance of {@link GearClassification}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param isAggregation Boolean
         * @return newInstance
         */
        public static GearClassification newInstance(String name, Boolean isAggregation)
        {
            final GearClassification entity = new GearClassificationImpl();
            entity.setName(name);
            entity.setIsAggregation(isAggregation);
            return entity;
        }

        /**
         * Constructs a new instance of {@link GearClassification}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param description String
         * @param isAggregation Boolean
         * @param updateDate Timestamp
         * @param gears Collection<Gear>
         * @return newInstance GearClassification
         */
        public static GearClassification newInstance(String name, String description, Boolean isAggregation, Timestamp updateDate, Collection<Gear> gears)
        {
            final GearClassification entity = new GearClassificationImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setIsAggregation(isAggregation);
            entity.setUpdateDate(updateDate);
            entity.setGears(gears);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(GearClassification o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.isIsAggregation() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsAggregation().compareTo(o.isIsAggregation()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// GearClassification.java merge-point
}