/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropTableChange;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.CreateTableStatement;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.statement.core.SetTableRemarksStatement;
import liquibase.util.StringUtils;

@DatabaseChange(name="createTable", description="Create Table", priority=1)
public class CreateTableChange
extends AbstractChange
implements ChangeWithColumns<ColumnConfig> {
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String tablespace;
    private String remarks;

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.addAll(super.validate(database));
        if (this.columns != null) {
            for (ColumnConfig columnConfig : this.columns) {
                if (columnConfig.getType() == null) {
                    validationErrors.addError("column 'type' is required for all columns");
                }
                if (columnConfig.getName() != null) continue;
                validationErrors.addError("column 'name' is required for all columns");
            }
        }
        return validationErrors;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        CreateTableStatement statement = new CreateTableStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getRemarks());
        for (ColumnConfig column : this.getColumns()) {
            ConstraintsConfig constraints = column.getConstraints();
            boolean isAutoIncrement = column.isAutoIncrement() != null && column.isAutoIncrement() != false;
            Object defaultValue = column.getDefaultValueObject();
            LiquibaseDataType columnType = DataTypeFactory.getInstance().fromDescription(String.valueOf(column.getType()) + (isAutoIncrement ? "{autoIncrement:true}" : ""));
            if (constraints != null && constraints.isPrimaryKey() != null && constraints.isPrimaryKey().booleanValue()) {
                statement.addPrimaryKeyColumn(column.getName(), columnType, defaultValue, constraints.getPrimaryKeyName(), constraints.getPrimaryKeyTablespace(), new ColumnConstraint[0]);
            } else {
                statement.addColumn(column.getName(), columnType, defaultValue, column.getRemarks(), new ColumnConstraint[0]);
            }
            if (constraints != null) {
                if (constraints.isNullable() != null && !constraints.isNullable().booleanValue()) {
                    statement.addColumnConstraint(new NotNullConstraint(column.getName()));
                }
                if (constraints.getReferences() != null || constraints.getReferencedTableName() != null && constraints.getReferencedColumnNames() != null) {
                    if (StringUtils.trimToNull(constraints.getForeignKeyName()) == null) {
                        throw new UnexpectedLiquibaseException("createTable with references requires foreignKeyName");
                    }
                    ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint(constraints.getForeignKeyName(), constraints.getReferences(), constraints.getReferencedTableName(), constraints.getReferencedColumnNames());
                    fkConstraint.setColumn(column.getName());
                    fkConstraint.setDeleteCascade(constraints.isDeleteCascade() != null && constraints.isDeleteCascade() != false);
                    fkConstraint.setInitiallyDeferred(constraints.isInitiallyDeferred() != null && constraints.isInitiallyDeferred() != false);
                    fkConstraint.setDeferrable(constraints.isDeferrable() != null && constraints.isDeferrable() != false);
                    statement.addColumnConstraint(fkConstraint);
                }
                if (constraints.isUnique() != null && constraints.isUnique().booleanValue()) {
                    statement.addColumnConstraint(new UniqueConstraint(constraints.getUniqueConstraintName()).addColumns(column.getName()));
                }
            }
            if (!isAutoIncrement) continue;
            statement.addColumnConstraint(new AutoIncrementConstraint(column.getName(), column.getStartWith(), column.getIncrementBy()));
        }
        statement.setTablespace(StringUtils.trimToNull(this.getTablespace()));
        ArrayList<AbstractSqlStatement> statements = new ArrayList<AbstractSqlStatement>();
        statements.add(statement);
        if (StringUtils.trimToNull(this.remarks) != null) {
            SetTableRemarksStatement remarksStatement = new SetTableRemarksStatement(this.catalogName, this.schemaName, this.tableName, this.remarks);
            if (SqlGeneratorFactory.getInstance().supports(remarksStatement, database)) {
                statements.add(remarksStatement);
            }
        }
        for (ColumnConfig column : this.getColumns()) {
            String columnRemarks = StringUtils.trimToNull(column.getRemarks());
            if (columnRemarks == null) continue;
            SetColumnRemarksStatement remarksStatement = new SetColumnRemarksStatement(this.catalogName, this.schemaName, this.tableName, column.getName(), columnRemarks);
            if (database instanceof MySQLDatabase || !SqlGeneratorFactory.getInstance().supports(remarksStatement, database)) continue;
            statements.add(remarksStatement);
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropTableChange inverse = new DropTableChange();
        inverse.setCatalogName(this.getCatalogName());
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        return new Change[]{inverse};
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={"all"})
    public List<ColumnConfig> getColumns() {
        if (this.columns == null) {
            return new ArrayList<ColumnConfig>();
        }
        return this.columns;
    }

    @Override
    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    @DatabaseChangeProperty(since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public String getConfirmationMessage() {
        return "Table " + this.tableName + " created";
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

