/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.actions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class SelectSpeciesForBenthosBatchAction
extends LongActionSupport<CreateBenthosBatchUIModel, CreateBenthosBatchUI, CreateBenthosBatchUIHandler> {
    protected List<Species> allSpecies = this.getDataContext().getSpecies();
    protected List<Species> referentSpecies = this.getDataContext().getReferentSpecies();
    protected Species selectedSpecies;

    public SelectSpeciesForBenthosBatchAction(CreateBenthosBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        if (canContinue) {
            CreateBenthosBatchUIModel model = (CreateBenthosBatchUIModel)this.getModel();
            ArrayList species = Lists.newArrayList(this.allSpecies);
            species.removeAll(model.getAvailableSpecies());
            this.selectedSpecies = this.openAddSpeciesDialog(I18n.t((String)"tutti.selectSpeciesForBenthosBatch.title", (Object[])new Object[0]), species);
            canContinue = this.selectedSpecies != null;
        }
        return canContinue;
    }

    @Override
    public void doAction() throws Exception {
        CreateBenthosBatchUIModel model = (CreateBenthosBatchUIModel)this.getModel();
        ArrayList availableSpecies = Lists.newArrayList(model.getAvailableSpecies());
        if (!this.selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = this.decorate(this.selectedSpecies, "fromProtocol");
            List<Species> referents = this.referentSpecies;
            Map<String, Species> referentsById = Speciess.splitReferenceSpeciesByReferenceTaxonId(referents);
            String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
            this.selectedSpecies = referentsById.get(taxonId);
            String decoratedReferent = this.decorate(this.selectedSpecies, "fromProtocol");
            this.sendMessage(I18n.t((String)"tutti.flash.info.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        }
        if (!availableSpecies.contains(this.selectedSpecies)) {
            availableSpecies.add(this.selectedSpecies);
        }
        model.setAvailableSpecies(availableSpecies);
        model.setSpecies(this.selectedSpecies);
    }
}

