// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.location;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

/**
 * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de lieux
 * de meme nature géographique.
 * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
 * - Zone FAO,
 * - Sous-Zone FAO,
 * - Division CIEM,
 * - Sous-division CIEM
 * - etc.
 * Pour la classification de lieu "lieux territoriaux", on aura :
 * - Pays
 * - Region,
 * - Département,
 * - Quartier Maritme,
 * - Port
 * - ...
 * On pourra trouver d'autre niveau de lieu, comme :
 * - implantation Ifremer
 * - laboratoire côtier, ...
 */
// HibernateEntity.vsl annotations merge-point
public abstract class LocationLevel
    implements Serializable, Comparable<LocationLevel>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -2620804644117218001L;

    // Generate 3 attributes
    private Integer id;

    /**
     * Idenfiant interne.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 4 associations
    private LocationLevel parentLocationLevel;

    /**
     * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de
     * lieux de
     * meme nature géographique.
     * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
     * - Zone FAO,
     * - Sous-Zone FAO,
     * - Division CIEM,
     * - Sous-division CIEM
     * - etc.
     * Pour la classification de lieu "lieux territoriaux", on aura :
     * - Pays
     * - Region,
     * - Département,
     * - Quartier Maritme,
     * - Port
     * - ...
     * On pourra trouver d'autre niveau de lieu, comme :
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @return this.parentLocationLevel LocationLevel
     */
    public LocationLevel getParentLocationLevel()
    {
        return this.parentLocationLevel;
    }

    /**
     * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de
     * lieux de
     * meme nature géographique.
     * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
     * - Zone FAO,
     * - Sous-Zone FAO,
     * - Division CIEM,
     * - Sous-division CIEM
     * - etc.
     * Pour la classification de lieu "lieux territoriaux", on aura :
     * - Pays
     * - Region,
     * - Département,
     * - Quartier Maritme,
     * - Port
     * - ...
     * On pourra trouver d'autre niveau de lieu, comme :
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @param parentLocationLevelIn LocationLevel
     */
    public void setParentLocationLevel(LocationLevel parentLocationLevelIn)
    {
        this.parentLocationLevel = parentLocationLevelIn;
    }

    private Collection<LocationLevel> locationLevels = new HashSet<LocationLevel>();

    /**
     * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de
     * lieux de
     * meme nature géographique.
     * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
     * - Zone FAO,
     * - Sous-Zone FAO,
     * - Division CIEM,
     * - Sous-division CIEM
     * - etc.
     * Pour la classification de lieu "lieux territoriaux", on aura :
     * - Pays
     * - Region,
     * - Département,
     * - Quartier Maritme,
     * - Port
     * - ...
     * On pourra trouver d'autre niveau de lieu, comme :
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @return this.locationLevels Collection<LocationLevel>
     */
    public Collection<LocationLevel> getLocationLevels()
    {
        return this.locationLevels;
    }

    /**
     * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de
     * lieux de
     * meme nature géographique.
     * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
     * - Zone FAO,
     * - Sous-Zone FAO,
     * - Division CIEM,
     * - Sous-division CIEM
     * - etc.
     * Pour la classification de lieu "lieux territoriaux", on aura :
     * - Pays
     * - Region,
     * - Département,
     * - Quartier Maritme,
     * - Port
     * - ...
     * On pourra trouver d'autre niveau de lieu, comme :
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @param locationLevelsIn Collection<LocationLevel>
     */
    public void setLocationLevels(Collection<LocationLevel> locationLevelsIn)
    {
        this.locationLevels = locationLevelsIn;
    }

    /**
     * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de
     * lieux de
     * meme nature géographique.
     * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
     * - Zone FAO,
     * - Sous-Zone FAO,
     * - Division CIEM,
     * - Sous-division CIEM
     * - etc.
     * Pour la classification de lieu "lieux territoriaux", on aura :
     * - Pays
     * - Region,
     * - Département,
     * - Quartier Maritme,
     * - Port
     * - ...
     * On pourra trouver d'autre niveau de lieu, comme :
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @param elementToAdd LocationLevel
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addLocationLevels(LocationLevel elementToAdd)
    {
        return this.locationLevels.add(elementToAdd);
    }

    /**
     * Niveau de lieu, ou catégorie. Il s'agit d'un regroupement de haut niveau d'un ensemble de
     * lieux de
     * meme nature géographique.
     * Par exemple, pour la classification de lieu "Secteur maritime", on aura :
     * - Zone FAO,
     * - Sous-Zone FAO,
     * - Division CIEM,
     * - Sous-division CIEM
     * - etc.
     * Pour la classification de lieu "lieux territoriaux", on aura :
     * - Pays
     * - Region,
     * - Département,
     * - Quartier Maritme,
     * - Port
     * - ...
     * On pourra trouver d'autre niveau de lieu, comme :
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @param elementToRemove LocationLevel
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeLocationLevels(LocationLevel elementToRemove)
    {
        return this.locationLevels.remove(elementToRemove);
    }

    private LocationClassification locationClassification;

    /**
     * Classification d'une hierachie de lieu.
     * Par exemple :
     * - lieu territoriaux (Pays, region, port, ...)
     * - secteurs maritimes (Zone FAO, sous-zone FAO, etc...)
     * - zone d'effort (B,J,C)
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @return this.locationClassification LocationClassification
     */
    public LocationClassification getLocationClassification()
    {
        return this.locationClassification;
    }

    /**
     * Classification d'une hierachie de lieu.
     * Par exemple :
     * - lieu territoriaux (Pays, region, port, ...)
     * - secteurs maritimes (Zone FAO, sous-zone FAO, etc...)
     * - zone d'effort (B,J,C)
     * - implantation Ifremer
     * - laboratoire côtier, ...
     * @param locationClassificationIn LocationClassification
     */
    public void setLocationClassification(LocationClassification locationClassificationIn)
    {
        this.locationClassification = locationClassificationIn;
    }

    /**
     * Returns <code>true</code> if the argument is an LocationLevel instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof LocationLevel))
        {
            return false;
        }
        final LocationLevel that = (LocationLevel)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link LocationLevel}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link LocationLevel}.
         * @return new LocationLevelImpl()
         */
        public static LocationLevel newInstance()
        {
            return new LocationLevelImpl();
        }

        /**
         * Constructs a new instance of {@link LocationLevel}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param locationClassification LocationClassification
         * @return newInstance
         */
        public static LocationLevel newInstance(String name, LocationClassification locationClassification)
        {
            final LocationLevel entity = new LocationLevelImpl();
            entity.setName(name);
            entity.setLocationClassification(locationClassification);
            return entity;
        }

        /**
         * Constructs a new instance of {@link LocationLevel}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param updateDate Timestamp
         * @param parentLocationLevel LocationLevel
         * @param locationLevels Collection<LocationLevel>
         * @param locationClassification LocationClassification
         * @return newInstance LocationLevel
         */
        public static LocationLevel newInstance(String name, Timestamp updateDate, LocationLevel parentLocationLevel, Collection<LocationLevel> locationLevels, LocationClassification locationClassification)
        {
            final LocationLevel entity = new LocationLevelImpl();
            entity.setName(name);
            entity.setUpdateDate(updateDate);
            entity.setParentLocationLevel(parentLocationLevel);
            entity.setLocationLevels(locationLevels);
            entity.setLocationClassification(locationClassification);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(LocationLevel o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// LocationLevel.java merge-point
}