// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel.feature.physical;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.VesselPhysicalMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.physicalGear.PhysicalGearSurvey;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Caractéristiques physique d'un navire (navire de peche ou océanographique, ou autres).
 */
// HibernateEntity.vsl annotations merge-point
public abstract class VesselPhysicalFeatures
    extends PhysicalFeaturesImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 4054460166001070592L;

    // Generate 5 attributes
    private Short rankOrder;

    /**
     * Permet d'avoir plusieurs information contradictoire, au sein d'un même programme, sur la même
     * période.
     * Ce champ est nécessaire dans le cas des données déclaratives, comme par exemple les ventes,
     * où plusieurs ventes peuvent transmettre, le même jour, des informations différentes sur le
     * navire.
     * Demande effectué par A. Gouello, pour la gestion des notes de ventes (ERS).
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * Permet d'avoir plusieurs information contradictoire, au sein d'un même programme, sur la même
     * période.
     * Ce champ est nécessaire dans le cas des données déclaratives, comme par exemple les ventes,
     * où plusieurs ventes peuvent transmettre, le même jour, des informations différentes sur le
     * navire.
     * Demande effectué par A. Gouello, pour la gestion des notes de ventes (ERS).
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String exteriorMarking;

    /**
     * Marquage extérieur.
     * par exemple : "BR 101717"
     * Si absent, il ets possible d'indiquer un commentaire (comments) avec un descriptif du navire.
     * @return this.exteriorMarking String
     */
    public String getExteriorMarking()
    {
        return this.exteriorMarking;
    }

    /**
     * Marquage extérieur.
     * par exemple : "BR 101717"
     * Si absent, il ets possible d'indiquer un commentaire (comments) avec un descriptif du navire.
     * @param exteriorMarkingIn String
     */
    public void setExteriorMarking(String exteriorMarkingIn)
    {
        this.exteriorMarking = exteriorMarkingIn;
    }

    private String IRCS;

    /**
     * Indicatif radio international du navire (IRCS)
     * @return this.IRCS String
     */
    public String getIRCS()
    {
        return this.IRCS;
    }

    /**
     * Indicatif radio international du navire (IRCS)
     * @param IRCSIn String
     */
    public void setIRCS(String IRCSIn)
    {
        this.IRCS = IRCSIn;
    }

    private String comments;

    /**
     * Le commentaire peut porter une description textuelle du navire (ou de l'usager) : par exemple
     * lorsque le navire ne porte pas de numéro d'identification externe. Dans ce cas, la couleur de
     * la coque et la forme de la cabine sont des éléments de reconnaissance des navires qui peuvent
     * etre utilisés (Exemple : Guyane et à Mayotte), en l'absence de possibilité de gérer des
     * photos des unités de pêche. A noter qu'en Guyane, chaque observateur dispose d'un catalogue
     * des navires informels avec une photo et une description du navire sous la forme d'un
     * commentaire.
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Le commentaire peut porter une description textuelle du navire (ou de l'usager) : par exemple
     * lorsque le navire ne porte pas de numéro d'identification externe. Dans ce cas, la couleur de
     * la coque et la forme de la cabine sont des éléments de reconnaissance des navires qui peuvent
     * etre utilisés (Exemple : Guyane et à Mayotte), en l'absence de possibilité de gérer des
     * photos des unités de pêche. A noter qu'en Guyane, chaque observateur dispose d'un catalogue
     * des navires informels avec une photo et une description du navire sous la forme d'un
     * commentaire.
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    // Generate 6 associations
    private Collection<VesselPhysicalFeaturesOrigin> vesselPhysicalFeaturesOrigins = new HashSet<VesselPhysicalFeaturesOrigin>();

    /**
     * 
     * @return this.vesselPhysicalFeaturesOrigins Collection<VesselPhysicalFeaturesOrigin>
     */
    public Collection<VesselPhysicalFeaturesOrigin> getVesselPhysicalFeaturesOrigins()
    {
        return this.vesselPhysicalFeaturesOrigins;
    }

    /**
     * 
     * @param vesselPhysicalFeaturesOriginsIn Collection<VesselPhysicalFeaturesOrigin>
     */
    public void setVesselPhysicalFeaturesOrigins(Collection<VesselPhysicalFeaturesOrigin> vesselPhysicalFeaturesOriginsIn)
    {
        this.vesselPhysicalFeaturesOrigins = vesselPhysicalFeaturesOriginsIn;
    }

    /**
     * 
     * @param elementToAdd VesselPhysicalFeaturesOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselPhysicalFeaturesOrigins(VesselPhysicalFeaturesOrigin elementToAdd)
    {
        return this.vesselPhysicalFeaturesOrigins.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove VesselPhysicalFeaturesOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselPhysicalFeaturesOrigins(VesselPhysicalFeaturesOrigin elementToRemove)
    {
        return this.vesselPhysicalFeaturesOrigins.remove(elementToRemove);
    }

    private Department recorderDepartment;

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service d'appartenance d'une personne.
     * Il peut s'agir des départements et service de l'Ifremer, ou bien des entreprises, services
     * extérieurs (sous-traitants, etc.).
     * REMARQUE : nous en aurons besoin en v2, pour l'administration des personnes (rechercher une
     * personne, gérer les sous-traitants, etc.), mais aussi pour identifier le service effectuant
     * l’analyse d’un résultat de mesure.
     * Nombre de lignes : 60
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Location baseLandingLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.baseLandingLocation Location
     */
    public Location getBaseLandingLocation()
    {
        return this.baseLandingLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param baseLandingLocationIn Location
     */
    public void setBaseLandingLocation(Location baseLandingLocationIn)
    {
        this.baseLandingLocation = baseLandingLocationIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private PhysicalGearSurvey physicalGearSurvey;

    /**
     * Enquete à partir de laquelle les caractéristiques de l'engin physiques ont été recueillies.
     * @return this.physicalGearSurvey PhysicalGearSurvey
     */
    public PhysicalGearSurvey getPhysicalGearSurvey()
    {
        return this.physicalGearSurvey;
    }

    /**
     * Enquete à partir de laquelle les caractéristiques de l'engin physiques ont été recueillies.
     * @param physicalGearSurveyIn PhysicalGearSurvey
     */
    public void setPhysicalGearSurvey(PhysicalGearSurvey physicalGearSurveyIn)
    {
        this.physicalGearSurvey = physicalGearSurveyIn;
    }

    private Collection<VesselPhysicalMeasurement> vesselPhysicalMeasurements = new HashSet<VesselPhysicalMeasurement>();

    /**
     * Liste des valeurs de caractéristiques de l'engin physique, valables sur la période début/fin
     * de validité des caractéristiques.
     * @return this.vesselPhysicalMeasurements Collection<VesselPhysicalMeasurement>
     */
    public Collection<VesselPhysicalMeasurement> getVesselPhysicalMeasurements()
    {
        return this.vesselPhysicalMeasurements;
    }

    /**
     * Liste des valeurs de caractéristiques de l'engin physique, valables sur la période début/fin
     * de validité des caractéristiques.
     * @param vesselPhysicalMeasurementsIn Collection<VesselPhysicalMeasurement>
     */
    public void setVesselPhysicalMeasurements(Collection<VesselPhysicalMeasurement> vesselPhysicalMeasurementsIn)
    {
        this.vesselPhysicalMeasurements = vesselPhysicalMeasurementsIn;
    }

    /**
     * Liste des valeurs de caractéristiques de l'engin physique, valables sur la période début/fin
     * de validité des caractéristiques.
     * @param elementToAdd VesselPhysicalMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselPhysicalMeasurements(VesselPhysicalMeasurement elementToAdd)
    {
        return this.vesselPhysicalMeasurements.add(elementToAdd);
    }

    /**
     * Liste des valeurs de caractéristiques de l'engin physique, valables sur la période début/fin
     * de validité des caractéristiques.
     * @param elementToRemove VesselPhysicalMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselPhysicalMeasurements(VesselPhysicalMeasurement elementToRemove)
    {
        return this.vesselPhysicalMeasurements.remove(elementToRemove);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>PhysicalFeaturesImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.vessel.feature.physical.PhysicalFeatures#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>PhysicalFeaturesImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.vessel.feature.physical.PhysicalFeatures#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link VesselPhysicalFeatures}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link VesselPhysicalFeatures}.
         * @return new VesselPhysicalFeaturesImpl()
         */
        public static VesselPhysicalFeatures newInstance()
        {
            return new VesselPhysicalFeaturesImpl();
        }

        /**
         * Constructs a new instance of {@link VesselPhysicalFeatures}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param creationDate Date
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param recorderDepartment Department
         * @return newInstance
         */
        public static VesselPhysicalFeatures newInstance(Date creationDate, Program program, QualityFlag qualityFlag, Vessel vessel, Department recorderDepartment)
        {
            final VesselPhysicalFeatures entity = new VesselPhysicalFeaturesImpl();
            entity.setCreationDate(creationDate);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setRecorderDepartment(recorderDepartment);
            return entity;
        }

        /**
         * Constructs a new instance of {@link VesselPhysicalFeatures}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param endDate Date
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param program Program
         * @param qualityFlag QualityFlag
         * @param vessel Vessel
         * @param rankOrder Short
         * @param name String
         * @param exteriorMarking String
         * @param IRCS String
         * @param comments String
         * @param vesselPhysicalFeaturesOrigins Collection<VesselPhysicalFeaturesOrigin>
         * @param recorderDepartment Department
         * @param baseLandingLocation Location
         * @param recorderPerson Person
         * @param physicalGearSurvey PhysicalGearSurvey
         * @param vesselPhysicalMeasurements Collection<VesselPhysicalMeasurement>
         * @return newInstance VesselPhysicalFeatures
         */
        public static VesselPhysicalFeatures newInstance(Date startDate, Date endDate, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Program program, QualityFlag qualityFlag, Vessel vessel, Short rankOrder, String name, String exteriorMarking, String IRCS, String comments, Collection<VesselPhysicalFeaturesOrigin> vesselPhysicalFeaturesOrigins, Department recorderDepartment, Location baseLandingLocation, Person recorderPerson, PhysicalGearSurvey physicalGearSurvey, Collection<VesselPhysicalMeasurement> vesselPhysicalMeasurements)
        {
            final VesselPhysicalFeatures entity = new VesselPhysicalFeaturesImpl();
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setProgram(program);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setRankOrder(rankOrder);
            entity.setName(name);
            entity.setExteriorMarking(exteriorMarking);
            entity.setIRCS(IRCS);
            entity.setComments(comments);
            entity.setVesselPhysicalFeaturesOrigins(vesselPhysicalFeaturesOrigins);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setBaseLandingLocation(baseLandingLocation);
            entity.setRecorderPerson(recorderPerson);
            entity.setPhysicalGearSurvey(physicalGearSurvey);
            entity.setVesselPhysicalMeasurements(vesselPhysicalMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(VesselPhysicalFeatures o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getExteriorMarking() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getExteriorMarking().compareTo(o.getExteriorMarking()));
            }
            if (this.getIRCS() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIRCS().compareTo(o.getIRCS()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// VesselPhysicalFeatures.java merge-point
}