/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportTechnicalActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryPersonService;
import fr.ifremer.tutti.service.referential.csv.PersonRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryPerson;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ExportReferentialPersonAction
extends ExportTechnicalActionSupport {
    private final ReferentialTemporaryPersonService referentialTemporaryPersonService;

    public ExportReferentialPersonAction(ReferentialTemporaryPersonService referentialTemporaryPersonService) {
        this.referentialTemporaryPersonService = referentialTemporaryPersonService;
    }

    @Override
    public void execute(GenericFormatExportContext exportContext) {
        List<Person> temporaryPersons = this.referentialTemporaryPersonService.getTemporaryPersons();
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportTemporaryPerson", (Object[])new Object[]{temporaryPersons.size()}));
        try {
            CsvProducerForTemporaryPerson producerForTemporarySpecies = exportContext.getProducerForTemporaryPerson();
            List<PersonRow> dataToExport = producerForTemporarySpecies.getDataToExport(temporaryPersons);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export temporary person", (Throwable)e);
        }
    }
}

