/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportRequest;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialImportResult;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

public abstract class GenericFormatResultSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean valid;
    private GenericFormatImportRequest importRequest;
    private final Set<String> archiveLayoutErrors;
    private final TuttiProtocol protocol;
    private final GenericFormatCsvFileResult sampleCategoryFileResult;
    private final GenericFormatReferentialImportResult<Gear, Integer> referentialTemporaryGearFileResult;
    private final GenericFormatReferentialImportResult<Person, Integer> referentialTemporaryPersonFileResult;
    private final GenericFormatReferentialImportResult<Species, Integer> referentialTemporarySpeciesFileResult;
    private final GenericFormatReferentialImportResult<Vessel, String> referentialTemporaryVesselFileResult;
    private final GenericFormatFileResult protocolFileResult;
    private final GenericFormatCsvFileResult surveyFileResult;
    private final GenericFormatCsvFileResult gearCaracteristicFileResult;
    private final GenericFormatCsvFileResult operationFileResult;
    private final GenericFormatCsvFileResult parameterFileResult;
    private final GenericFormatCsvFileResult catchFileResult;
    private final GenericFormatCsvFileResult marineLitterFileResult;
    private final GenericFormatCsvFileResult individualObservationFileResult;
    private final GenericFormatCsvFileResult accidentalCatchFileResult;
    private final GenericFormatCsvFileResult attachmentsFileResult;
    private String protocolOriginalName;
    private ProgramDataModel dataModel;

    protected GenericFormatResultSupport(GenericFormatContextSupport importContext) {
        this.importRequest = importContext.getImportRequest();
        this.protocol = importContext.getImportedProtocol();
        this.sampleCategoryFileResult = importContext.getSampleCategoryFileResult();
        this.referentialTemporaryGearFileResult = importContext.getReferentialTemporaryGearFileResult();
        this.referentialTemporaryPersonFileResult = importContext.getReferentialTemporaryPersonFileResult();
        this.referentialTemporarySpeciesFileResult = importContext.getReferentialTemporarySpeciesFileResult();
        this.referentialTemporaryVesselFileResult = importContext.getReferentialTemporaryVesselFileResult();
        this.protocolFileResult = importContext.getProtocolFileResult();
        this.surveyFileResult = importContext.getSurveyFileResult();
        this.gearCaracteristicFileResult = importContext.getGearCaracteristicFileResult();
        this.operationFileResult = importContext.getOperationFileResult();
        this.parameterFileResult = importContext.getParameterFileResult();
        this.catchFileResult = importContext.getCatchFileResult();
        this.marineLitterFileResult = importContext.getMarineLitterFileResult();
        this.individualObservationFileResult = importContext.getIndividualObservationFileResult();
        this.accidentalCatchFileResult = importContext.getAccidentalCatchFileResult();
        this.attachmentsFileResult = importContext.getAttachmentFileResult();
        this.protocolOriginalName = importContext.getProtocolOriginalName();
        Set<Object> archiveLayoutErrors1 = importContext.isArchiveLayoutValid() ? Collections.emptySet() : importContext.getArchiveLayoutErrors();
        this.archiveLayoutErrors = ImmutableSet.copyOf(archiveLayoutErrors1);
        this.valid = this.computeValid();
    }

    private boolean computeValid() {
        boolean result = this.isArchiveLayoutValid() && this.sampleCategoryFileResult.isValid() && this.referentialTemporaryGearFileResult.isValid() && this.referentialTemporaryPersonFileResult.isValid() && this.referentialTemporarySpeciesFileResult.isValid() && this.referentialTemporaryVesselFileResult.isValid() && this.protocolFileResult.isValid() && this.surveyFileResult.isValid() && this.gearCaracteristicFileResult.isValid() && this.operationFileResult.isValid() && this.parameterFileResult.isValid() && this.catchFileResult.isValid() && this.marineLitterFileResult.isValid() && this.accidentalCatchFileResult.isValid() && this.individualObservationFileResult.isValid() && this.attachmentsFileResult.isValid();
        return result;
    }

    public boolean isArchiveLayoutValid() {
        return this.archiveLayoutErrors.isEmpty();
    }

    public Set<String> getArchiveLayoutErrors() {
        return this.archiveLayoutErrors;
    }

    public TuttiProtocol getProtocol() {
        return this.protocol;
    }

    public GenericFormatCsvFileResult getSampleCategoryFileResult() {
        return this.sampleCategoryFileResult;
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.importRequest.getSampleCategoryModel();
    }

    public GenericFormatReferentialImportResult<Gear, Integer> getReferentialTemporaryGearFileResult() {
        return this.referentialTemporaryGearFileResult;
    }

    public GenericFormatReferentialImportResult<Person, Integer> getReferentialTemporaryPersonFileResult() {
        return this.referentialTemporaryPersonFileResult;
    }

    public GenericFormatReferentialImportResult<Species, Integer> getReferentialTemporarySpeciesFileResult() {
        return this.referentialTemporarySpeciesFileResult;
    }

    public GenericFormatReferentialImportResult<Vessel, String> getReferentialTemporaryVesselFileResult() {
        return this.referentialTemporaryVesselFileResult;
    }

    public GenericFormatFileResult getProtocolFileResult() {
        return this.protocolFileResult;
    }

    public GenericFormatCsvFileResult getSurveyFileResult() {
        return this.surveyFileResult;
    }

    public GenericFormatCsvFileResult getGearCaracteristicFileResult() {
        return this.gearCaracteristicFileResult;
    }

    public GenericFormatCsvFileResult getOperationFileResult() {
        return this.operationFileResult;
    }

    public GenericFormatCsvFileResult getParameterFileResult() {
        return this.parameterFileResult;
    }

    public GenericFormatCsvFileResult getCatchFileResult() {
        return this.catchFileResult;
    }

    public GenericFormatCsvFileResult getMarineLitterFileResult() {
        return this.marineLitterFileResult;
    }

    public GenericFormatCsvFileResult getIndividualObservationFileResult() {
        return this.individualObservationFileResult;
    }

    public GenericFormatCsvFileResult getAccidentalCatchFileResult() {
        return this.accidentalCatchFileResult;
    }

    public GenericFormatCsvFileResult getAttachmentsFileResult() {
        return this.attachmentsFileResult;
    }

    public File getReportFile() {
        return this.importRequest.getReportFile();
    }

    public GenericFormatImportConfiguration getImportConfiguration() {
        return this.importRequest.getImportConfiguration();
    }

    public Program getProgram() {
        return this.importRequest.getProgram();
    }

    public Date getStartingDate() {
        return this.importRequest.getStartingDate();
    }

    public boolean isCleanWeights() {
        return this.importRequest.isCleanWeights();
    }

    public boolean isCheckWeights() {
        return this.importRequest.isCheckWeights();
    }

    public GenericFormatArchive getArchive() {
        return this.importRequest.getArchive();
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getProtocolOriginalName() {
        return this.protocolOriginalName;
    }

    public void setProtocolOriginalName(String protocolOriginalName) {
        this.protocolOriginalName = protocolOriginalName;
    }

    public ProgramDataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(ProgramDataModel dataModel) {
        this.dataModel = dataModel;
    }
}

