/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin.signs;

import com.google.common.base.Function;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.service.bigfin.csv.BigfinDataRow;
import fr.ifremer.tutti.service.bigfin.signs.Sign;
import java.util.Map;

public enum VracHorsVrac implements Sign
{
    VRAC(""){

        @Override
        public Integer getCategory() {
            return PmfmId.SORTED_UNSORTED.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SORTED_VRAC.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return false;
        }
    }
    ,
    HORS_VRAC("HV"){

        @Override
        public Integer getCategory() {
            return PmfmId.SORTED_UNSORTED.getValue();
        }

        @Override
        public Integer getQualitativeValueId() {
            return QualitativeValueId.SORTED_HORS_VRAC.getValue();
        }

        @Override
        public boolean isNullEquivalent() {
            return false;
        }
    };

    private String sign;

    private VracHorsVrac(String sign) {
        this.sign = sign;
    }

    @Override
    public String getSign() {
        return this.sign;
    }

    @Override
    public void registerSign(Caracteristic caracteristic, Map<Sign, CaracteristicQualitativeValue> map) {
        Integer valueId = this.getQualitativeValueId();
        CaracteristicQualitativeValue result = CaracteristicQualitativeValues.getQualitativeValue((Caracteristic)caracteristic, (Integer)valueId);
        map.put(this, result);
    }

    public static VracHorsVrac getValue(String sign) {
        VracHorsVrac result = null;
        for (VracHorsVrac s : VracHorsVrac.values()) {
            if (!s.sign.equals(sign)) continue;
            result = s;
            break;
        }
        return result;
    }

    public static Function<BigfinDataRow, Sign> newExtractValueFunction() {
        return new Function<BigfinDataRow, Sign>(){

            public Sign apply(BigfinDataRow bigfinDataRow) {
                VracHorsVrac result = bigfinDataRow.getVracHorsVrac();
                return result;
            }
        };
    }
}

