/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.protocol.OperationFieldMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.TuttiDecorator;
import fr.ifremer.tutti.ui.swing.content.home.actions.CloneProtocolAction;
import fr.ifremer.tutti.ui.swing.content.home.actions.EditProtocolAction;
import fr.ifremer.tutti.ui.swing.content.home.actions.ImportProtocolAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesAbleBatchRowHelper;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolOperationFieldsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolOperationFieldsTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.MandatorySampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanDoubleListModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProtocolUIHandler
extends AbstractTuttiUIHandler<EditProtocolUIModel, EditProtocolUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(EditProtocolUIHandler.class);
    protected SampleCategoryModel sampleCategoryModel;
    protected List<BeanDoubleList<Caracteristic>> allDoubleLists;

    public static String getTitle(boolean exist) {
        String result = exist ? I18n.t((String)"tutti.editProtocol.title.edit.protocol", (Object[])new Object[0]) : I18n.t((String)"tutti.editProtocol.title.create.protocol", (Object[])new Object[0]);
        return result;
    }

    public JXTable getSpeciesTable() {
        return ((EditProtocolUI)this.ui).getSpeciesTable();
    }

    public JXTable getBenthosTable() {
        return ((EditProtocolUI)this.ui).getBenthosTable();
    }

    public JXTable getCaracteristicsMappingTable() {
        return ((EditProtocolUI)this.ui).getCaracteristicsMappingTable();
    }

    public JXTable getOperationFieldsMappingTable() {
        return ((EditProtocolUI)this.ui).getOperationFieldsMappingTable();
    }

    public EditProtocolSpeciesTableModel getSpeciesTableModel() {
        return (EditProtocolSpeciesTableModel)((Object)this.getSpeciesTable().getModel());
    }

    public EditProtocolSpeciesTableModel getBenthosTableModel() {
        return (EditProtocolSpeciesTableModel)((Object)this.getBenthosTable().getModel());
    }

    public boolean isSpeciesSelected(Object selectedItem) {
        return selectedItem != null && selectedItem instanceof Species;
    }

    public EditProtocolCaracteristicsTableModel getCaracteristicMappingTableModel() {
        return (EditProtocolCaracteristicsTableModel)((Object)this.getCaracteristicsMappingTable().getModel());
    }

    public EditProtocolOperationFieldsTableModel getEditProtocolOperationFieldsMappingTableModel() {
        return (EditProtocolOperationFieldsTableModel)((Object)this.getOperationFieldsMappingTable().getModel());
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return ((EditProtocolUI)this.ui).getValidator();
    }

    public void beforeInit(EditProtocolUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.sampleCategoryModel = this.getContext().getDataContext().getSampleCategoryModel();
        this.incrementsMessage("Chargement des r\u00e9ferentiels");
        this.getDataContext().resetValidationDataContext();
        EditProtocolUIModel model = new EditProtocolUIModel();
        ArrayList allSpecies = Lists.newArrayList((Iterable)this.getDataContext().getSpecies());
        model.setAllSpecies(allSpecies);
        Multimap<String, Species> allSpeciesByTaxonId = Speciess.splitByReferenceTaxonId(allSpecies);
        model.setAllSpeciesByTaxonId(allSpeciesByTaxonId);
        List referentSpecies = this.getDataContext().getReferentSpecies();
        Map<String, Species> allReferentSpeciesByTaxonId = Speciess.splitReferenceSpeciesByReferenceTaxonId(referentSpecies);
        model.setAllReferentSpeciesByTaxonId(allReferentSpeciesByTaxonId);
        ArrayList caracteristics = Lists.newArrayList((Iterable)this.getDataContext().getCaracteristics());
        model.setCaracteristics(caracteristics);
        Map<String, Caracteristic> allCaracteristic = TuttiEntities.splitById(caracteristics);
        model.setAllCaracteristic(allCaracteristic);
        this.listModelIsModify(model);
        ((EditProtocolUI)this.ui).setContextValue(model);
    }

    public void afterInit(EditProtocolUI ui) {
        MandatorySampleCategoryColumnIdentifier identifier;
        List<Object> benthosRows;
        List<Object> speciesRows;
        List<Object> operationFieldMappingRows;
        List<Object> caracteristicMappingRows;
        TuttiProtocol protocol;
        this.initUI(this.ui);
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        if (this.getContext().isProtocolFilled()) {
            this.incrementsMessage("Chargement du protocole");
            protocol = this.getDataContext().getProtocol();
            if (EditProtocolAction.CLEAN_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui) != null) {
                protocol = (TuttiProtocol)EditProtocolAction.CLEAN_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
                EditProtocolAction.CLEAN_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                model.setCleaned(true);
                ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n.t((String)"tutti.editProtocol.warn.clean", (Object[])new Object[0]));
            }
            model.fromBean(protocol);
        } else {
            protocol = (TuttiProtocol)ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
            if (protocol != null) {
                this.incrementsMessage("Import du protocole");
                ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                model.fromBean(protocol);
                model.setImported(true);
                ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n.t((String)"tutti.editProtocol.warn.import", (Object[])new Object[0]));
            } else {
                protocol = (TuttiProtocol)CloneProtocolAction.CLONE_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
                if (protocol != null) {
                    this.incrementsMessage("Clone du protocole");
                    CloneProtocolAction.CLONE_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                    model.fromBean(protocol);
                    model.setCloned(true);
                    ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n.t((String)"tutti.editProtocol.warn.clone", (Object[])new Object[0]));
                } else {
                    this.incrementsMessage("Cr\u00e9ation d'un nouveau protocol");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Will create a new protocol");
                    }
                }
            }
        }
        if (model.getLengthClassesPmfmId() == null) {
            model.setLengthClassesPmfmId(Lists.newArrayList());
        }
        SwingValidator<EditProtocolUIModel> validator = ((EditProtocolUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        Collection<Species> referents = model.getAllReferentSpeciesByTaxonId().values();
        this.initBeanFilterableComboBox(((EditProtocolUI)this.ui).getSpeciesComboBox(), Lists.newArrayList(referents), null);
        this.initBeanFilterableComboBox(((EditProtocolUI)this.ui).getBenthosComboBox(), Lists.newArrayList(referents), null);
        this.initBeanFilterableComboBox(ui.getCaracteristicMappingComboBox(), new ArrayList<Caracteristic>(model.getCaracteristics()), null);
        model.addPropertyChangeListener("importColumns", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditProtocolUIHandler.this.populateImportColumnTableEditors();
            }
        });
        this.incrementsMessage("Pr\u00e9paration des interfaces graphiques");
        if (protocol == null) {
            caracteristicMappingRows = Lists.newArrayList();
            operationFieldMappingRows = Lists.newArrayList();
            speciesRows = Lists.newArrayList();
            benthosRows = Lists.newArrayList();
        } else {
            caracteristicMappingRows = this.toProtocolCaracteristicRows(protocol.getCaracteristicMapping());
            operationFieldMappingRows = this.toProtocolOperationFieldsRows(protocol.getOperationFieldMapping());
            speciesRows = this.toSpeciesRows(protocol.getSpecies());
            benthosRows = this.toSpeciesRows(protocol.getBenthos());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit protocol with " + speciesRows.size() + " species and " + benthosRows.size() + " benthos declared."));
            }
        }
        model.setSpeciesRow((List<EditProtocolSpeciesRowModel>)speciesRows);
        model.setBenthosRow((List<EditProtocolSpeciesRowModel>)benthosRows);
        model.setCaracteristicMappingRows(caracteristicMappingRows);
        model.setOperationFieldMappingRows(operationFieldMappingRows);
        ((EditProtocolUI)this.ui).getSpeciesComboBox().reset();
        ((EditProtocolUI)this.ui).getBenthosComboBox().reset();
        ((EditProtocolUI)this.ui).getCaracteristicMappingComboBox().reset();
        JXTable table = this.getSpeciesTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        TableColumnExt speciesColumn = this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        speciesColumn.setSortable(true);
        DecoratorService.SpeciesDecorator speciesDecorator = new DecoratorService.SpeciesDecorator();
        speciesColumn.putClientProperty((Object)"decorator", (Object)speciesDecorator);
        speciesColumn.setCellRenderer(this.newTableCellRender((Decorator)speciesDecorator));
        TableColumnExt speciesSurveyCodeColumn = this.addColumnToModel((TableColumnModel)columnModel, null, null, EditProtocolSpeciesTableModel.SURVEY_CODE_ID);
        speciesSurveyCodeColumn.setSortable(true);
        this.addLengthClassesColumnToModel((TableColumnModel)columnModel, model.getLengthClassesPmfmId());
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.WEIGHT_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.COUNT_IF_NO_FREQUENCY_ENABLED, (JTable)table);
        for (SampleCategoryModelEntry sampleCategoryModelEntry : this.sampleCategoryModel.getCategory()) {
            if (sampleCategoryModelEntry.getOrder() == 0) continue;
            identifier = MandatorySampleCategoryColumnIdentifier.newId("mandatorySampleCategoryId", sampleCategoryModelEntry.getCategoryId(), sampleCategoryModelEntry.getLabel(), sampleCategoryModelEntry.getLabel());
            this.addBooleanColumnToModel((TableColumnModel)columnModel, identifier, (JTable)table);
        }
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.CALCIFY_SAMPLE_ENABLED, (JTable)table);
        this.initTable(table, columnModel, speciesColumn, speciesRows, new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                ((EditProtocolUIModel)EditProtocolUIHandler.this.getModel()).setRemoveSpeciesEnabled(!source.isSelectionEmpty());
            }
        });
        table = this.getBenthosTable();
        columnModel = new DefaultTableColumnModelExt();
        speciesColumn = this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        speciesColumn.setSortable(true);
        speciesDecorator = new DecoratorService.SpeciesDecorator();
        speciesColumn.putClientProperty((Object)"decorator", (Object)speciesDecorator);
        speciesColumn.setCellRenderer(this.newTableCellRender((Decorator)speciesDecorator));
        speciesSurveyCodeColumn = this.addColumnToModel((TableColumnModel)columnModel, null, null, EditProtocolSpeciesTableModel.SURVEY_CODE_ID);
        speciesSurveyCodeColumn.setSortable(true);
        this.addLengthClassesColumnToModel((TableColumnModel)columnModel, model.getLengthClassesPmfmId());
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.WEIGHT_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.COUNT_IF_NO_FREQUENCY_ENABLED, (JTable)table);
        for (SampleCategoryModelEntry sampleCategoryModelEntry : this.sampleCategoryModel.getCategory()) {
            if (sampleCategoryModelEntry.getOrder() == 0) continue;
            identifier = MandatorySampleCategoryColumnIdentifier.newId("mandatorySampleCategoryId", sampleCategoryModelEntry.getCategoryId(), sampleCategoryModelEntry.getLabel(), sampleCategoryModelEntry.getLabel());
            this.addBooleanColumnToModel((TableColumnModel)columnModel, identifier, (JTable)table);
        }
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.CALCIFY_SAMPLE_ENABLED, (JTable)table);
        this.initTable(table, columnModel, speciesColumn, benthosRows, new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                ((EditProtocolUIModel)EditProtocolUIHandler.this.getModel()).setRemoveBenthosEnabled(!source.isSelectionEmpty());
            }
        });
        this.allDoubleLists = Lists.newArrayList((Object[])new BeanDoubleList[]{((EditProtocolUI)this.ui).getLengthClassesList(), ((EditProtocolUI)this.ui).getIndividualObservationList()});
        this.initDoubleList("lengthClassesPmfmId", ((EditProtocolUI)this.ui).getLengthClassesList(), Lists.newArrayList(model.getCaracteristics()), model.getLengthClassesPmfmId());
        this.initDoubleList("individualObservationPmfmId", ((EditProtocolUI)this.ui).getIndividualObservationList(), Lists.newArrayList(model.getCaracteristics()), model.getIndividualObservationPmfmId());
        JXTable caracteristicsMappingTable = this.getCaracteristicsMappingTable();
        columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class), EditProtocolCaracteristicsTableModel.PSFM_ID);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, EditProtocolCaracteristicsTableModel.TYPE, this.getDecorator(CaracteristicType.class, null), Lists.newArrayList((Object[])CaracteristicType.getTabTypes()));
        this.addColumnToModel((TableColumnModel)columnModel, EditProtocolCaracteristicsTableModel.IMPORT_FILE_COLUMN);
        ArrayList<Caracteristic> caracteristics = new ArrayList<Caracteristic>(((EditProtocolUIModel)this.getModel()).getCaracteristics());
        EditProtocolCaracteristicsTableModel tableModel = new EditProtocolCaracteristicsTableModel((TableColumnModelExt)columnModel, caracteristics);
        caracteristicsMappingTable.setModel((TableModel)((Object)tableModel));
        caracteristicsMappingTable.setColumnModel((TableColumnModel)columnModel);
        caracteristicsMappingTable.getTableHeader().setReorderingAllowed(false);
        this.addHighlighters(caracteristicsMappingTable);
        caracteristicsMappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                ((EditProtocolUIModel)EditProtocolUIHandler.this.getModel()).setRemoveCaracteristicMappingEnabled(!source.isSelectionEmpty());
            }
        });
        SwingUtil.scrollToTableSelection((JTable)caracteristicsMappingTable);
        tableModel.setRows(caracteristicMappingRows);
        JXTable operationFieldsTable = ((EditProtocolUI)this.getUI()).getOperationFieldsMappingTable();
        columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setText(I18n.t((String)("tutti.editFishingOperation.field." + value.toString()), (Object[])new Object[0]));
                return this;
            }
        }, EditProtocolOperationFieldsTableModel.FIELD);
        this.addColumnToModel((TableColumnModel)columnModel, EditProtocolOperationFieldsTableModel.IMPORT_FILE_COLUMN);
        EditProtocolOperationFieldsTableModel tableModel2 = new EditProtocolOperationFieldsTableModel((TableColumnModelExt)columnModel);
        operationFieldsTable.setModel((TableModel)((Object)tableModel2));
        operationFieldsTable.setColumnModel((TableColumnModel)columnModel);
        operationFieldsTable.getTableHeader().setReorderingAllowed(false);
        this.addHighlighters(operationFieldsTable);
        tableModel2.setRows(operationFieldMappingRows);
        SwingUtil.scrollToTableSelection((JTable)operationFieldsTable);
        this.populateImportColumnTableEditors();
        model.setModify(model.isCreate() || model.isCleaned());
        ((EditProtocolUI)this.ui).getCaracteristicPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BeanDoubleList<Caracteristic> selectedDoubleList;
                JTabbedPane tabPanel = (JTabbedPane)e.getSource();
                int selectedIndex = tabPanel.getSelectedIndex();
                log.debug((Object)("selected " + selectedIndex));
                switch (selectedIndex) {
                    case 0: {
                        selectedDoubleList = ((EditProtocolUI)EditProtocolUIHandler.this.ui).getLengthClassesList();
                        break;
                    }
                    case 1: {
                        selectedDoubleList = ((EditProtocolUI)EditProtocolUIHandler.this.ui).getIndividualObservationList();
                        break;
                    }
                    default: {
                        selectedDoubleList = null;
                    }
                }
                if (selectedDoubleList != null) {
                    selectedDoubleList.getHandler().refreshFilteredElements();
                } else {
                    ArrayList<Caracteristic> selectedCaracteristics = new ArrayList<Caracteristic>(((EditProtocolUIModel)EditProtocolUIHandler.this.getModel()).getCaracteristics());
                    for (BeanDoubleList<Caracteristic> doubleList : EditProtocolUIHandler.this.allDoubleLists) {
                        selectedCaracteristics.removeAll(doubleList.getModel().getSelected());
                    }
                    selectedCaracteristics.removeAll(((EditProtocolUIModel)EditProtocolUIHandler.this.getModel()).getUsedCaracteristics());
                    ((EditProtocolUI)EditProtocolUIHandler.this.getUI()).getCaracteristicMappingComboBox().setData(selectedCaracteristics);
                }
            }
        });
        model.setVersion(TuttiProtocols.CURRENT_PROTOCOL_VERSION);
    }

    protected JComponent getComponentToFocus() {
        return ((EditProtocolUI)this.getUI()).getNameField();
    }

    public List<EditProtocolSpeciesRowModel> toSpeciesRows(List<SpeciesProtocol> speciesProtocols) {
        BeanFilterableComboBox<Species> speciesComboBox = ((EditProtocolUI)this.ui).getSpeciesComboBox();
        Preconditions.checkNotNull((Object)speciesComboBox.getData());
        BeanFilterableComboBox<Species> benthosComboBox = ((EditProtocolUI)this.ui).getBenthosComboBox();
        Preconditions.checkNotNull((Object)benthosComboBox.getData());
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        Map<String, Species> allReferentSpeciesByTaxonId = model.getAllReferentSpeciesByTaxonId();
        Map<String, Caracteristic> allCaracteristic = model.getAllCaracteristic();
        ArrayList lengthClassesPmfmId = Lists.newArrayList();
        HashSet speciesSet = Sets.newHashSet();
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(speciesProtocols)) {
            for (SpeciesProtocol speciesProtocol : speciesProtocols) {
                Integer taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                if (taxonId == null) continue;
                String taxonIdStr = String.valueOf(taxonId);
                Collection<Species> allSynonyms = model.getAllSynonyms(taxonIdStr);
                model.getAllSynonyms().removeAll(allSynonyms);
                Species species = allReferentSpeciesByTaxonId.get(taxonIdStr);
                Preconditions.checkNotNull((Object)species, (Object)("Esp\u00e8ce inconnue : " + taxonIdStr));
                speciesSet.add(species);
                EditProtocolSpeciesRowModel row = EditProtocolSpeciesTableModel.newRow(this.sampleCategoryModel);
                row.setSpecies(species);
                String lengthStepPmfmId = speciesProtocol.getLengthStepPmfmId();
                Caracteristic lengthStepPmfm = allCaracteristic.get(lengthStepPmfmId);
                if (lengthStepPmfmId != null && !lengthClassesPmfmId.contains(lengthStepPmfm) && !model.containsLengthClassesPmfmId(lengthStepPmfmId)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Found a new lengthStep pmfm: " + lengthStepPmfmId));
                    }
                    lengthClassesPmfmId.add(lengthStepPmfm);
                }
                row.setLengthStepPmfm(lengthStepPmfm);
                row.fromBean(speciesProtocol);
                row.setMandatorySampleCategoryId(Lists.newArrayList(speciesProtocol.getMandatorySampleCategoryId()));
                result.add(row);
            }
            speciesComboBox.removeItems((Iterable)speciesSet);
            benthosComboBox.removeItems((Iterable)speciesSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)lengthClassesPmfmId)) {
            model.addAllLengthClassesPmfmId(TuttiEntities.collecIds(lengthClassesPmfmId));
            BeanDoubleList<Caracteristic> lengthClassesList = ((EditProtocolUI)this.ui).getLengthClassesList();
            lengthClassesList.getModel().addToSelected((List)lengthClassesPmfmId);
        }
        return result;
    }

    public List<EditProtocolCaracteristicsRowModel> toProtocolCaracteristicRows(List<CaracteristicMappingRow> caracteristicMappingRows) {
        BeanFilterableComboBox<Caracteristic> caracteristicMappingComboBox = ((EditProtocolUI)this.ui).getCaracteristicMappingComboBox();
        Preconditions.checkNotNull((Object)caracteristicMappingComboBox.getData());
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        HashSet caracteristicSet = Sets.newHashSet();
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(caracteristicMappingRows)) {
            for (CaracteristicMappingRow caracteristicMappingRow : caracteristicMappingRows) {
                String pmfmId = caracteristicMappingRow.getPmfmId();
                if (pmfmId == null) continue;
                caracteristicSet.add(model.getAllCaracteristic().get(pmfmId));
                EditProtocolCaracteristicsRowModel row = this.createEditProtocolCaracteristicsRowModel();
                row.fromBean(caracteristicMappingRow);
                row.setValid(row.getType() != null);
                result.add(row);
            }
            caracteristicMappingComboBox.removeItems((Iterable)caracteristicSet);
        }
        return result;
    }

    public List<EditProtocolOperationFieldsRowModel> toProtocolOperationFieldsRows(Collection<OperationFieldMappingRow> operationFieldMappingRows) {
        ArrayList result = Lists.newArrayList();
        if (operationFieldMappingRows == null) {
            operationFieldMappingRows = new ArrayList<OperationFieldMappingRow>();
        }
        ImmutableMap rowsByField = Maps.uniqueIndex(operationFieldMappingRows, (Function)new Function<OperationFieldMappingRow, String>(){

            public String apply(OperationFieldMappingRow operationFieldMappingRow) {
                return operationFieldMappingRow.getField();
            }
        });
        I18n.n((String)"tutti.editFishingOperation.field.gearShootingStartDay", (Object[])new Object[0]);
        I18n.n((String)"tutti.editFishingOperation.field.gearShootingStartTime", (Object[])new Object[0]);
        I18n.n((String)"tutti.editFishingOperation.field.gearShootingEndDay", (Object[])new Object[0]);
        I18n.n((String)"tutti.editFishingOperation.field.gearShootingEndTime", (Object[])new Object[0]);
        ArrayList properties = Lists.newArrayList((Object[])new String[]{"stationNumber", "fishingOperationNumber", "gearShootingStartDay", "gearShootingStartTime", "gearShootingStartLatitude", "gearShootingStartLongitude", "gearShootingEndDay", "gearShootingEndTime", "gearShootingEndLatitude", "gearShootingEndLongitude", "fishingOperationRectiligne", "trawlDistance", "fishingOperationValid", "multirigAggregation", "recorderPerson", "gear", "vessel", "strata", "subStrata", "location", "secondaryVessel"});
        Iterator i$ = properties.iterator();
        while (i$.hasNext()) {
            String property;
            OperationFieldMappingRow row = (OperationFieldMappingRow)rowsByField.get(property = (String)i$.next());
            EditProtocolOperationFieldsRowModel newRow = this.createOperationFieldRow(property, row != null ? row.getImportColumn() : null);
            result.add(newRow);
        }
        return result;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
        ((EditProtocolUI)this.ui).getTabPanel().setSelectedIndex(0);
    }

    public boolean quitUI() {
        boolean result = this.quitScreen(((EditProtocolUIModel)this.getModel()).isValid(), ((EditProtocolUIModel)this.getModel()).isModify(), I18n.t((String)"tutti.editProtocol.askCancelEditBeforeLeaving.cancelSaveProtocol", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.askSaveBeforeLeaving.saveProtocol", (Object[])new Object[0]), ((EditProtocolUI)this.ui).getSaveButton().getAction());
        return result;
    }

    public void addDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        for (BeanDoubleList<Caracteristic> list : this.allDoubleLists) {
            String id = (String)list.getClientProperty((Object)"_updateListenerId");
            UpdateSelectedList updateListener = (UpdateSelectedList)list.getClientProperty((Object)"_updateListener");
            model.addPropertyChangeListener(id, updateListener);
        }
    }

    public void removeDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        for (BeanDoubleList<Caracteristic> list : this.allDoubleLists) {
            String id = (String)list.getClientProperty((Object)"_updateListenerId");
            UpdateSelectedList updateListener = (UpdateSelectedList)list.getClientProperty((Object)"_updateListener");
            model.removePropertyChangeListener(id, updateListener);
        }
    }

    public EditProtocolCaracteristicsRowModel createEditProtocolCaracteristicsRowModel() {
        EditProtocolCaracteristicsRowModel newRow = new EditProtocolCaracteristicsRowModel(((EditProtocolUIModel)this.getModel()).getCaracteristics());
        newRow.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditProtocolCaracteristicsRowModel row = (EditProtocolCaracteristicsRowModel)evt.getSource();
                EditProtocolUIModel model = (EditProtocolUIModel)EditProtocolUIHandler.this.getModel();
                if ("importColumn".equals(evt.getPropertyName())) {
                    String newValue;
                    String oldValue = (String)evt.getOldValue();
                    if (oldValue != null) {
                        model.decNumberOfRows(oldValue);
                    }
                    if ((newValue = (String)evt.getNewValue()) != null) {
                        model.incNumberOfRows(newValue);
                    }
                    EditProtocolUIHandler.this.recomputeRowsValidState();
                } else {
                    row.setValid(EditProtocolUIHandler.this.isCaracteristicsRowValid(row));
                }
                if (row.isValid()) {
                    model.setModify(true);
                }
            }
        });
        return newRow;
    }

    protected void initDoubleList(String propertyId, BeanDoubleList<Caracteristic> widget, List<Caracteristic> availableCaracteristics, List<String> selectedCaracteristics) {
        this.initBeanList(widget, availableCaracteristics, Lists.newArrayList());
        UpdateSelectedList listener = new UpdateSelectedList(widget, ((EditProtocolUIModel)this.getModel()).getAllCaracteristic());
        widget.putClientProperty((Object)"_updateListener", (Object)listener);
        widget.putClientProperty((Object)"_updateListenerId", (Object)propertyId);
        listener.select(selectedCaracteristics);
        ArrayList list = Lists.newArrayList(this.allDoubleLists);
        list.remove(widget);
        widget.getHandler().addFilter((Predicate)new SelectValuePredicate(list));
        widget.getHandler().addFilter((Predicate)new Predicate<Caracteristic>(){

            public boolean apply(Caracteristic caracteristic) {
                return !((EditProtocolUIModel)EditProtocolUIHandler.this.getModel()).isCaracteristicUsedInMapping(caracteristic);
            }
        });
    }

    protected void selectLengthClasses(List<String> ids, JComboBox comboBox) {
        ArrayList dataToList;
        Map<String, Caracteristic> allCaracteristic = ((EditProtocolUIModel)this.getModel()).getAllCaracteristic();
        ArrayList selection = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                selection.add(allCaracteristic.get(id));
            }
        }
        if (!(dataToList = Lists.newArrayList((Iterable)selection)).isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox((JComboBox)comboBox, (Collection)dataToList, null);
    }

    protected void addLengthClassesColumnToModel(TableColumnModel model, List<String> selectedIds) {
        Decorator<Caracteristic> decorator = this.getDecorator(Caracteristic.class, null);
        final JComboBox comboBox = new JComboBox();
        ((EditProtocolUIModel)this.getModel()).addPropertyChangeListener("lengthClassesPmfmId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List ids = (List)evt.getNewValue();
                EditProtocolUIHandler.this.selectLengthClasses(ids, comboBox);
            }
        });
        comboBox.setRenderer(this.newListCellRender(decorator));
        this.selectLengthClasses(selectedIds, comboBox);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), EditProtocolSpeciesTableModel.LENGTH_STEP_PMFM_ID);
    }

    protected void initTable(final JXTable table, DefaultTableColumnModelExt columnModel, TableColumnExt speciesColumn, List<EditProtocolSpeciesRowModel> rows, ListSelectionListener selectionListener) {
        final EditProtocolSpeciesTableModel tableModel = new EditProtocolSpeciesTableModel(this.sampleCategoryModel, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        this.addHighlighters(table);
        SwingUtil.scrollToTableSelection((JTable)table);
        table.getSelectionModel().addListSelectionListener(selectionListener);
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ((EditProtocolUIModel)EditProtocolUIHandler.this.getModel()).setModify(true);
                int type = e.getType();
                if (type == -1 || type == 1 || e.getLastRow() == Integer.MAX_VALUE) {
                    boolean comparatorNull;
                    TableColumnExt tableColumn = (TableColumnExt)table.getColumns().get(0);
                    TuttiDecorator.TuttiDecoratorComparator comparator = (TuttiDecorator.TuttiDecoratorComparator)tableColumn.getComparator();
                    TuttiDecorator<Species> decorator = SpeciesAbleBatchRowHelper.getSpeciesColumnDecorator(tableColumn);
                    boolean bl = comparatorNull = comparator == null;
                    if (comparatorNull) {
                        comparator = decorator.getCurrentComparator();
                    }
                    comparator.init(decorator, tableModel.getSpeciesList());
                    if (comparatorNull) {
                        tableColumn.setComparator((Comparator)comparator);
                    }
                }
            }
        });
        SpeciesAbleBatchRowHelper.installSpeciesColumnComparatorPopup(table, speciesColumn, null, I18n.t((String)"tutti.species.refTaxCode.tip", (Object[])new Object[0]), I18n.t((String)"tutti.species.name.tip", (Object[])new Object[0]));
        tableModel.setRows(rows);
    }

    protected EditProtocolOperationFieldsRowModel createOperationFieldRow(String property, String column) {
        EditProtocolOperationFieldsRowModel newRow = new EditProtocolOperationFieldsRowModel();
        newRow.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditProtocolOperationFieldsRowModel row = (EditProtocolOperationFieldsRowModel)evt.getSource();
                EditProtocolUIModel model = (EditProtocolUIModel)EditProtocolUIHandler.this.getModel();
                if ("importColumn".equals(evt.getPropertyName())) {
                    String newValue;
                    String oldValue = (String)evt.getOldValue();
                    if (oldValue != null) {
                        model.decNumberOfRows(oldValue);
                    }
                    if ((newValue = (String)evt.getNewValue()) != null) {
                        model.incNumberOfRows(newValue);
                    }
                    EditProtocolUIHandler.this.recomputeRowsValidState();
                }
            }
        });
        newRow.setValid(true);
        newRow.setField(property);
        newRow.setImportColumn(column);
        newRow.setValid(true);
        newRow.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ((EditProtocolUIModel)EditProtocolUIHandler.this.getModel()).setModify(true);
            }
        });
        return newRow;
    }

    protected void recomputeRowsValidState() {
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        for (EditProtocolCaracteristicsRowModel editProtocolCaracteristicsRowModel : model.getCaracteristicMappingRows()) {
            editProtocolCaracteristicsRowModel.setValid(this.isCaracteristicsRowValid(editProtocolCaracteristicsRowModel));
        }
        for (EditProtocolOperationFieldsRowModel editProtocolOperationFieldsRowModel : model.getOperationFieldMappingRows()) {
            editProtocolOperationFieldsRowModel.setValid(this.isOperationFieldsRowValid(editProtocolOperationFieldsRowModel));
        }
        this.getCaracteristicsMappingTable().repaint();
        this.getOperationFieldsMappingTable().repaint();
    }

    protected boolean isOperationFieldsRowValid(EditProtocolOperationFieldsRowModel row) {
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        String importColumn = row.getImportColumn();
        return importColumn == null || model.numberOfRows(importColumn) < 2;
    }

    protected boolean isCaracteristicsRowValid(EditProtocolCaracteristicsRowModel row) {
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        String importColumn = row.getImportColumn();
        return row.getType() != null && (importColumn == null || model.numberOfRows(importColumn) < 2);
    }

    protected void populateImportColumnTableEditors() {
        Collection<String> importColumns = ((EditProtocolUIModel)this.getModel()).getImportColumns();
        ArrayList<String> dataToList = new ArrayList<String>();
        if (importColumns != null) {
            dataToList.addAll(importColumns);
            if (!dataToList.isEmpty() && dataToList.get(0) != null) {
                dataToList.add(0, null);
            }
        } else {
            dataToList.add(null);
        }
        this.populateImportColumnTableEditor(((EditProtocolUI)this.getUI()).getCaracteristicsMappingTable(), 2, dataToList);
        this.populateImportColumnTableEditor(((EditProtocolUI)this.getUI()).getOperationFieldsMappingTable(), 1, dataToList);
    }

    protected void populateImportColumnTableEditor(JXTable table, int columnIndex, ArrayList<String> dataToList) {
        JComboBox comboBox = new JComboBox();
        SwingUtil.fillComboBox(comboBox, dataToList, null);
        TableColumnExt col = table.getColumnExt(columnIndex);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        col.setCellEditor((TableCellEditor)editor);
    }

    protected static class SelectValuePredicate
    implements Predicate<Caracteristic> {
        protected final List<BeanDoubleList<Caracteristic>> lists;

        public SelectValuePredicate(List<BeanDoubleList<Caracteristic>> lists) {
            this.lists = lists;
        }

        public boolean apply(Caracteristic input) {
            boolean result = true;
            for (BeanDoubleList<Caracteristic> list : this.lists) {
                if (!list.getModel().getSelected().contains(input)) continue;
                result = false;
                break;
            }
            return result;
        }
    }

    protected static class UpdateSelectedList
    implements PropertyChangeListener {
        private final BeanDoubleListModel<Caracteristic> model;
        private final Map<String, Caracteristic> caracteristicMap;
        private boolean valueIsAdjusting;

        public UpdateSelectedList(BeanDoubleList<Caracteristic> doubleList, Map<String, Caracteristic> caracteristicMap) {
            this.model = doubleList.getModel();
            this.caracteristicMap = caracteristicMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.valueIsAdjusting) {
                this.valueIsAdjusting = true;
                try {
                    List selectedIds = (List)evt.getNewValue();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("[" + evt.getPropertyName() + "] selected ids: " + selectedIds));
                    }
                    this.select(selectedIds);
                }
                finally {
                    this.valueIsAdjusting = false;
                }
            }
        }

        public void select(List<String> selectedIds) {
            ArrayList selection = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(selectedIds)) {
                for (String selectedId : selectedIds) {
                    Caracteristic e = this.caracteristicMap.get(selectedId);
                    Preconditions.checkNotNull((Object)e, (Object)("Could not find caracteristic with id: " + selectedId));
                    selection.add(e);
                }
            }
            this.model.setSelected((List)selection);
        }
    }
}

