/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.internal.index.IDocumentIndexWriter;
import org.eclipse.birt.report.engine.internal.index.v2.DocumentIndexV2Constants;
import org.eclipse.birt.report.engine.internal.index.v2.IndexWriter;

public class DocumentIndexWriterV2
implements IDocumentIndexWriter,
DocumentIndexV2Constants,
ReportDocumentConstants {
    IDocArchiveWriter archive;
    IndexWriter bookmarks;
    IndexWriter reportlets;
    IndexWriter pageNumbers;

    public DocumentIndexWriterV2(IDocArchiveWriter archive) throws IOException {
        this.archive = archive;
    }

    @Override
    public void close() throws IOException {
        if (this.bookmarks != null) {
            this.bookmarks.close();
        }
        if (this.reportlets != null) {
            this.reportlets.close();
            this.reportlets = null;
        }
        if (this.pageNumbers != null) {
            this.pageNumbers.close();
            this.pageNumbers = null;
        }
    }

    @Override
    public void setOffsetOfBookmark(String bookmark, long offset) throws IOException {
        if (this.bookmarks == null) {
            this.bookmarks = this.createIndexWriter(this.archive, "/reportletBookmarks");
        }
        if (this.bookmarks != null) {
            this.bookmarks.add(bookmark, offset);
        }
    }

    @Override
    public void setOffsetOfInstance(String instanceId, long offset) throws IOException {
        if (this.reportlets == null) {
            this.reportlets = this.createIndexWriter(this.archive, "/reportlet");
        }
        if (this.reportlets != null) {
            this.reportlets.add(instanceId, offset);
        }
    }

    @Override
    public void setBookmark(String bookmark, BookmarkContent content) throws IOException {
        if (this.pageNumbers == null) {
            this.pageNumbers = this.createIndexWriter(this.archive, "/bookmark");
        }
        if (this.pageNumbers != null) {
            this.pageNumbers.add(bookmark, content);
        }
    }

    IndexWriter createIndexWriter(IDocArchiveWriter archive, String name) {
        return new IndexWriter(archive, name);
    }
}

