/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;

public class TableDirectory {
    private int version = 0;
    private short numTables = 0;
    private short searchRange = 0;
    private short entrySelector = 0;
    private short rangeShift = 0;
    private DirectoryEntry[] entries;

    public TableDirectory(RandomAccessFile randomAccessFile) throws IOException {
        this.version = randomAccessFile.readInt();
        this.numTables = randomAccessFile.readShort();
        this.searchRange = randomAccessFile.readShort();
        this.entrySelector = randomAccessFile.readShort();
        this.rangeShift = randomAccessFile.readShort();
        this.entries = new DirectoryEntry[this.numTables];
        int n = 0;
        while (n < this.numTables) {
            this.entries[n] = new DirectoryEntry(randomAccessFile);
            ++n;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            int n2 = 0;
            while (n2 < this.numTables - 1) {
                if (this.entries[n2].getOffset() > this.entries[n2 + 1].getOffset()) {
                    DirectoryEntry directoryEntry = this.entries[n2];
                    this.entries[n2] = this.entries[n2 + 1];
                    this.entries[n2 + 1] = directoryEntry;
                    bl = true;
                }
                ++n2;
            }
        }
    }

    public DirectoryEntry getEntry(int n) {
        return this.entries[n];
    }

    public DirectoryEntry getEntryByTag(int n) {
        int n2 = 0;
        while (n2 < this.numTables) {
            if (this.entries[n2].getTag() == n) {
                return this.entries[n2];
            }
            ++n2;
        }
        return null;
    }

    public short getEntrySelector() {
        return this.entrySelector;
    }

    public short getNumTables() {
        return this.numTables;
    }

    public short getRangeShift() {
        return this.rangeShift;
    }

    public short getSearchRange() {
        return this.searchRange;
    }

    public int getVersion() {
        return this.version;
    }
}

