/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.caracteristics;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import java.awt.Component;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.commons.collections4.MapUtils;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class GearCaracteristicListCellRenderer
implements ListCellRenderer {
    private final ListCellRenderer delegate;
    private final Decorator<Caracteristic> decorator;
    private final Decorator<Gear> gearDecorator;
    protected final Map<Gear, String> cache;
    protected final boolean useCache;

    public GearCaracteristicListCellRenderer(ListCellRenderer delegate, Decorator<Caracteristic> decorator, Decorator<Gear> gearDecorator, boolean useCache) {
        this.gearDecorator = gearDecorator;
        this.useCache = useCache;
        this.delegate = delegate;
        this.decorator = decorator;
        this.cache = Maps.newHashMap();
    }

    public void clear() {
        this.cache.clear();
    }

    public Component getListCellRendererComponent(JList list, Object item, int index, boolean isSelected, boolean cellHasFocus) {
        String toolTipText = this.getToolTipText((Gear)item);
        Component result = this.delegate.getListCellRendererComponent(list, item, index, isSelected, cellHasFocus);
        ((JComponent)result).setToolTipText(toolTipText);
        return result;
    }

    public String getToolTipText(Gear gear) {
        String toolTipText;
        if (gear == null) {
            toolTipText = "";
        } else if (this.useCache) {
            if (this.cache.containsKey(gear)) {
                toolTipText = this.cache.get(gear);
            } else {
                toolTipText = this.buildTip(gear);
                this.cache.put(gear, toolTipText);
            }
        } else {
            toolTipText = this.buildTip(gear);
        }
        return toolTipText;
    }

    protected String buildTip(Gear gear) {
        ValueFormatter caracteristicValueFormatter = TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER;
        StringBuilder sb = new StringBuilder("<html><body>");
        String gearStr = this.gearDecorator.toString((Object)gear);
        sb.append("<h3>").append(I18n.t((String)"tutti.gear.withCaracteristics", (Object[])new Object[]{gearStr})).append("</h3></hr>");
        if (MapUtils.isNotEmpty((Map)gear.getCaracteristics())) {
            sb.append("<ul>");
            for (Map.Entry entry : gear.getCaracteristics().entrySet()) {
                Caracteristic key = (Caracteristic)entry.getKey();
                String keyStr = this.decorator.toString((Object)key);
                Serializable value = (Serializable)entry.getValue();
                String valueStr = caracteristicValueFormatter.format((Object)value);
                sb.append("<li>").append(keyStr).append(" :");
                sb.append(valueStr).append("</strong></li>");
            }
            sb.append("</ul>");
        } else {
            sb.append("<i>").append(I18n.t((String)"tutti.gear.noCaracteristics", (Object[])new Object[0])).append("</i>");
        }
        sb.append("</body></html>");
        String toolTipText = sb.toString();
        return toolTipText;
    }
}

