/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.spi.NamedQueryDefinitionBuilder;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinitionBuilder;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.logging.Logger;

public class QueryBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)QueryBinder.class.getName());

    private QueryBinder() {
    }

    public static void bind(AnnotationBindingContext bindingContext) {
        List annotations = bindingContext.getIndex().getAnnotations(JPADotNames.NAMED_QUERY);
        for (AnnotationInstance query : annotations) {
            QueryBinder.bindNamedQuery(bindingContext.getMetadataImplementor(), query);
        }
        annotations = bindingContext.getIndex().getAnnotations(JPADotNames.NAMED_QUERIES);
        for (AnnotationInstance queries : annotations) {
            for (AnnotationInstance query : JandexHelper.getValue(queries, "value", AnnotationInstance[].class)) {
                QueryBinder.bindNamedQuery(bindingContext.getMetadataImplementor(), query);
            }
        }
        annotations = bindingContext.getIndex().getAnnotations(JPADotNames.NAMED_NATIVE_QUERY);
        for (AnnotationInstance query : annotations) {
            QueryBinder.bindNamedNativeQuery(bindingContext.getMetadataImplementor(), query);
        }
        annotations = bindingContext.getIndex().getAnnotations(JPADotNames.NAMED_NATIVE_QUERIES);
        for (AnnotationInstance queries : annotations) {
            for (AnnotationInstance query : JandexHelper.getValue(queries, "value", AnnotationInstance[].class)) {
                QueryBinder.bindNamedNativeQuery(bindingContext.getMetadataImplementor(), query);
            }
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.NAMED_QUERY);
        for (AnnotationInstance query : annotations) {
            QueryBinder.bindNamedQuery(bindingContext.getMetadataImplementor(), query);
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.NAMED_QUERIES);
        for (AnnotationInstance queries : annotations) {
            for (AnnotationInstance query : JandexHelper.getValue(queries, "value", AnnotationInstance[].class)) {
                QueryBinder.bindNamedQuery(bindingContext.getMetadataImplementor(), query);
            }
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.NAMED_NATIVE_QUERY);
        for (AnnotationInstance query : annotations) {
            QueryBinder.bindNamedNativeQuery(bindingContext.getMetadataImplementor(), query);
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.NAMED_NATIVE_QUERIES);
        for (AnnotationInstance queries : annotations) {
            for (AnnotationInstance query : JandexHelper.getValue(queries, "value", AnnotationInstance[].class)) {
                QueryBinder.bindNamedNativeQuery(bindingContext.getMetadataImplementor(), query);
            }
        }
    }

    private static void bindNamedQuery(MetadataImplementor metadata, AnnotationInstance annotation) {
        String comment;
        Integer fetchSize;
        Integer timeout;
        String name = JandexHelper.getValue(annotation, "name", String.class);
        if (StringHelper.isEmpty(name)) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String query = JandexHelper.getValue(annotation, "query", String.class);
        AnnotationInstance[] hints = JandexHelper.getValue(annotation, "hints", AnnotationInstance[].class);
        String cacheRegion = QueryBinder.getString(hints, "org.hibernate.cacheRegion");
        if (StringHelper.isEmpty(cacheRegion)) {
            cacheRegion = null;
        }
        if ((timeout = QueryBinder.getTimeout(hints, query)) != null && timeout < 0) {
            timeout = null;
        }
        if ((fetchSize = QueryBinder.getInteger(hints, "org.hibernate.fetchSize", name)) != null && fetchSize < 0) {
            fetchSize = null;
        }
        if (StringHelper.isEmpty(comment = QueryBinder.getString(hints, "org.hibernate.comment"))) {
            comment = null;
        }
        metadata.addNamedQuery(new NamedQueryDefinitionBuilder().setName(name).setQuery(query).setCacheable(QueryBinder.getBoolean(hints, "org.hibernate.cacheable", name)).setCacheRegion(cacheRegion).setTimeout(timeout).setFetchSize(fetchSize).setFlushMode(QueryBinder.getFlushMode(hints, "org.hibernate.flushMode", name)).setCacheMode(QueryBinder.getCacheMode(hints, "org.hibernate.cacheMode", name)).setReadOnly(QueryBinder.getBoolean(hints, "org.hibernate.readOnly", name)).setComment(comment).setParameterTypes(null).createNamedQueryDefinition());
        LOG.debugf("Binding named query: %s => %s", name, query);
    }

    private static void bindNamedNativeQuery(MetadataImplementor metadata, AnnotationInstance annotation) {
        NamedSQLQueryDefinition def;
        Integer fetchSize;
        Integer timeout;
        String name = JandexHelper.getValue(annotation, "name", String.class);
        if (StringHelper.isEmpty(name)) {
            throw new AnnotationException("A named native query must have a name when used in class or package level");
        }
        String query = JandexHelper.getValue(annotation, "query", String.class);
        String resultSetMapping = JandexHelper.getValue(annotation, "resultSetMapping", String.class);
        AnnotationInstance[] hints = JandexHelper.getValue(annotation, "hints", AnnotationInstance[].class);
        boolean cacheable = QueryBinder.getBoolean(hints, "org.hibernate.cacheable", name);
        String cacheRegion = QueryBinder.getString(hints, "org.hibernate.cacheRegion");
        if (StringHelper.isEmpty(cacheRegion)) {
            cacheRegion = null;
        }
        if ((timeout = QueryBinder.getTimeout(hints, query)) != null && timeout < 0) {
            timeout = null;
        }
        if ((fetchSize = QueryBinder.getInteger(hints, "org.hibernate.fetchSize", name)) != null && fetchSize < 0) {
            fetchSize = null;
        }
        FlushMode flushMode = QueryBinder.getFlushMode(hints, "org.hibernate.flushMode", name);
        CacheMode cacheMode = QueryBinder.getCacheMode(hints, "org.hibernate.cacheMode", name);
        boolean readOnly = QueryBinder.getBoolean(hints, "org.hibernate.readOnly", name);
        String comment = QueryBinder.getString(hints, "org.hibernate.comment");
        if (StringHelper.isEmpty(comment)) {
            comment = null;
        }
        boolean callable = QueryBinder.getBoolean(hints, "org.hibernate.callable", name);
        if (StringHelper.isNotEmpty(resultSetMapping)) {
            def = new NamedSQLQueryDefinitionBuilder().setName(name).setQuery(query).setResultSetRef(resultSetMapping).setQuerySpaces((List<String>)null).setCacheable(cacheable).setCacheRegion(cacheRegion).setTimeout(timeout).setFetchSize(fetchSize).setFlushMode(flushMode).setCacheMode(cacheMode).setReadOnly(readOnly).setComment(comment).setParameterTypes(null).setCallable(callable).createNamedQueryDefinition();
        } else {
            AnnotationValue annotationValue = annotation.value("resultClass");
            if (annotationValue == null) {
                throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
            }
            NativeSQLQueryReturn[] queryRoots = new NativeSQLQueryRootReturn[]{new NativeSQLQueryRootReturn("alias1", annotationValue.asString(), new HashMap<String, String[]>(), LockMode.READ)};
            def = new NamedSQLQueryDefinitionBuilder().setName(name).setQuery(query).setQueryReturns(queryRoots).setQuerySpaces((List<String>)null).setCacheable(cacheable).setCacheRegion(cacheRegion).setTimeout(timeout).setFetchSize(fetchSize).setFlushMode(flushMode).setCacheMode(cacheMode).setReadOnly(readOnly).setComment(comment).setParameterTypes(null).setCallable(callable).createNamedQueryDefinition();
        }
        metadata.addNamedNativeQuery(def);
        LOG.debugf("Binding named native query: %s => %s", name, query);
    }

    private static boolean getBoolean(AnnotationInstance[] hints, String element, String query) {
        String val = QueryBinder.getString(hints, element);
        if (val == null || val.equalsIgnoreCase("false")) {
            return false;
        }
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        throw new AnnotationException("Not a boolean in hint: " + query + ":" + element);
    }

    private static CacheMode getCacheMode(AnnotationInstance[] hints, String element, String query) {
        String val = QueryBinder.getString(hints, element);
        if (val == null) {
            return null;
        }
        if (val.equalsIgnoreCase(CacheMode.GET.toString())) {
            return CacheMode.GET;
        }
        if (val.equalsIgnoreCase(CacheMode.IGNORE.toString())) {
            return CacheMode.IGNORE;
        }
        if (val.equalsIgnoreCase(CacheMode.NORMAL.toString())) {
            return CacheMode.NORMAL;
        }
        if (val.equalsIgnoreCase(CacheMode.PUT.toString())) {
            return CacheMode.PUT;
        }
        if (val.equalsIgnoreCase(CacheMode.REFRESH.toString())) {
            return CacheMode.REFRESH;
        }
        throw new AnnotationException("Unknown CacheMode in hint: " + query + ":" + element);
    }

    private static FlushMode getFlushMode(AnnotationInstance[] hints, String element, String query) {
        String val = QueryBinder.getString(hints, element);
        if (val == null) {
            return null;
        }
        if (val.equalsIgnoreCase(FlushMode.ALWAYS.toString())) {
            return FlushMode.ALWAYS;
        }
        if (val.equalsIgnoreCase(FlushMode.AUTO.toString())) {
            return FlushMode.AUTO;
        }
        if (val.equalsIgnoreCase(FlushMode.COMMIT.toString())) {
            return FlushMode.COMMIT;
        }
        if (val.equalsIgnoreCase(FlushMode.NEVER.toString())) {
            return FlushMode.MANUAL;
        }
        if (val.equalsIgnoreCase(FlushMode.MANUAL.toString())) {
            return FlushMode.MANUAL;
        }
        throw new AnnotationException("Unknown FlushMode in hint: " + query + ":" + element);
    }

    private static Integer getInteger(AnnotationInstance[] hints, String element, String query) {
        String val = QueryBinder.getString(hints, element);
        if (val == null) {
            return null;
        }
        try {
            return Integer.decode(val);
        }
        catch (NumberFormatException nfe) {
            throw new AnnotationException("Not an integer in hint: " + query + ":" + element, nfe);
        }
    }

    private static String getString(AnnotationInstance[] hints, String element) {
        for (AnnotationInstance hint : hints) {
            if (!element.equals(JandexHelper.getValue(hint, "name", String.class))) continue;
            return JandexHelper.getValue(hint, "value", String.class);
        }
        return null;
    }

    private static Integer getTimeout(AnnotationInstance[] hints, String query) {
        Integer timeout = QueryBinder.getInteger(hints, "javax.persistence.query.timeout", query);
        if (timeout == null) {
            return QueryBinder.getInteger(hints, "org.hibernate.timeout", query);
        }
        return (timeout + 500) / 1000;
    }
}

