/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.w3c.dom.css.CSSValue;

public class ContentUtil {
    public static long getDesignID(IContent content) {
        if (content == null) {
            return -1L;
        }
        Object design = content.getGenerateBy();
        if (design instanceof ReportElementDesign) {
            return ((ReportElementDesign)design).getID();
        }
        return -1L;
    }

    public static boolean hasHorzPageBreak(ITableContent table) {
        int count = table.getColumnCount();
        int i = 0;
        while (i < count) {
            IColumn column = table.getColumn(i);
            IStyle style = column.getStyle();
            CSSValue pageBreak = style.getProperty(33);
            if (i > 0 && IStyle.ALWAYS_VALUE == pageBreak) {
                return true;
            }
            pageBreak = style.getProperty(57);
            if (i < count - 1 && IStyle.ALWAYS_VALUE == pageBreak) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

