/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.socket;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;

public class SynchroBrowserHandler
implements HttpRequestHandler {
    private static final Log log = LogFactory.getLog(SynchroBrowserHandler.class);
    private final File dataDirectory;

    public SynchroBrowserHandler(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        StringEntity entity;
        File file;
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
            throw new MethodNotSupportedException(method + " method not supported");
        }
        String target = request.getRequestLine().getUri();
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity2 = ((HttpEntityEnclosingRequest)request).getEntity();
            byte[] entityContent = EntityUtils.toByteArray((HttpEntity)entity2);
            log.debug((Object)("Incoming entity content (bytes): " + entityContent.length));
        }
        if (!(file = new File(this.dataDirectory, URLDecoder.decode(target, "UTF-8"))).exists()) {
            response.setStatusCode(404);
            entity = new StringEntity("<html><body><h1>File" + file.getPath() + " not found</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            log.warn((Object)("File " + file.getPath() + " not found"));
        } else if (!file.canRead() || file.isDirectory()) {
            response.setStatusCode(403);
            entity = new StringEntity("<html><body><h1>Access denied</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            log.warn((Object)("Cannot read file " + file.getPath()));
        } else {
            response.setStatusCode(200);
            FileEntity body = new FileEntity(file, ContentType.create((String)"text/html", (Charset)null));
            response.setEntity((HttpEntity)body);
            log.debug((Object)("Serving file " + file.getPath()));
        }
    }
}

