/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;

public class SynchroColumnMetadata {
    protected final ColumnMetadata delegate;
    protected final boolean isProtected;
    protected final String tableName;
    protected final int columnIndex;
    protected SynchroJoinMetadata parentJoin = null;

    public SynchroColumnMetadata(ColumnMetadata delegate, String tableName, int columnIndex, boolean isProtected) {
        Preconditions.checkNotNull((Object)delegate);
        this.delegate = delegate;
        this.tableName = tableName;
        this.columnIndex = columnIndex;
        this.isProtected = isProtected;
    }

    public SynchroColumnMetadata(SynchroColumnMetadata beanToCopy) {
        Preconditions.checkNotNull((Object)beanToCopy);
        this.delegate = beanToCopy.delegate;
        this.tableName = beanToCopy.tableName;
        this.columnIndex = beanToCopy.columnIndex;
        this.isProtected = beanToCopy.isProtected;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SynchroJoinMetadata getParentJoin() {
        return this.parentJoin;
    }

    public void setParentJoin(SynchroJoinMetadata parentJoin) {
        this.parentJoin = parentJoin;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getTypeName() {
        return this.delegate.getTypeName();
    }

    public int getColumnSize() {
        return this.delegate.getColumnSize();
    }

    public int getDecimalDigits() {
        return this.delegate.getDecimalDigits();
    }

    public String getNullable() {
        return this.delegate.getNullable();
    }

    public boolean isNullable() {
        return "YES".equalsIgnoreCase(this.getNullable());
    }

    public String toString() {
        return this.delegate.toString();
    }

    public int getTypeCode() {
        return this.delegate.getTypeCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }
}

