/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.conversion.impl.DefaultTypeConverter;
import java.lang.reflect.Member;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverter
extends DefaultTypeConverter {
    @Override
    public Object convertValue(Map<String, Object> context, Object target, Member member, String propertyName, Object value, Class toType) {
        String result = null;
        if (value instanceof int[]) {
            int[] x = (int[])value;
            ArrayList<Integer> intArray = new ArrayList<Integer>(x.length);
            for (int aX : x) {
                intArray.add(aX);
            }
            result = StringUtils.join(intArray, (String)", ");
        } else if (value instanceof long[]) {
            long[] x = (long[])value;
            ArrayList<Long> longArray = new ArrayList<Long>(x.length);
            for (long aX : x) {
                longArray.add(aX);
            }
            result = StringUtils.join(longArray, (String)", ");
        } else if (value instanceof double[]) {
            double[] x = (double[])value;
            ArrayList<Double> doubleArray = new ArrayList<Double>(x.length);
            for (double aX : x) {
                doubleArray.add(new Double(aX));
            }
            result = StringUtils.join(doubleArray, (String)", ");
        } else if (value instanceof boolean[]) {
            boolean[] x = (boolean[])value;
            ArrayList<Boolean> booleanArray = new ArrayList<Boolean>(x.length);
            for (boolean aX : x) {
                booleanArray.add(new Boolean(aX));
            }
            result = StringUtils.join(booleanArray, (String)", ");
        } else if (value instanceof Date) {
            DateFormat df = null;
            if (value instanceof Time) {
                df = DateFormat.getTimeInstance(2, this.getLocale(context));
            } else if (value instanceof Timestamp) {
                SimpleDateFormat dfmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, this.getLocale(context));
                df = new SimpleDateFormat(dfmt.toPattern() + MILLISECOND_FORMAT);
            } else {
                df = DateFormat.getDateInstance(3, this.getLocale(context));
            }
            result = df.format(value);
        } else if (value instanceof String[]) {
            result = StringUtils.join((Object[])((String[])value), (String)", ");
        }
        return result;
    }
}

