/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util;

import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchImpl;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LazyInitializationException;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;

@Component(value="synchronizationStatusHelper")
public class SynchronizationStatusHelper
extends AbstractPersistenceService {
    private static final Log log = LogFactory.getLog(SynchronizationStatusHelper.class);

    public void setDirty(ScientificCruise scientificCruise) {
        String synchronizationStatus = this.getDirtyValue();
        if (log.isInfoEnabled()) {
            log.info((Object)("SetDirty scientificCruise: " + scientificCruise.getId()));
        }
        scientificCruise.setSynchronizationStatus(synchronizationStatus);
    }

    public void setDirty(FishingTrip fishingTrip) {
        String synchronizationStatus = this.getDirtyValue();
        fishingTrip.setSynchronizationStatus(synchronizationStatus);
        if (log.isInfoEnabled()) {
            log.info((Object)("SetDirty fishingTrip: " + fishingTrip.getId()));
        }
        this.setDirty(fishingTrip.getScientificCruise());
    }

    public void setDirty(CatchBatch catchBatch) {
        String synchronizationStatus = this.getDirtyValue();
        if (log.isInfoEnabled()) {
            log.info((Object)("SetDirty catchBatch: " + catchBatch.getId()));
        }
        catchBatch.setSynchronizationStatus(synchronizationStatus);
        try {
            this.setDirty(catchBatch.getFishingOperation().getFishingTrip());
        }
        catch (LazyInitializationException e) {
            CatchBatchImpl loadedCatchBatch = this.load(CatchBatchImpl.class, catchBatch.getId());
            loadedCatchBatch.setSynchronizationStatus(synchronizationStatus);
        }
    }

    public void setDirty(Sample sample) {
        Batch batch;
        String synchronizationStatus = this.getDirtyValue();
        sample.setSynchronizationStatus(synchronizationStatus);
        if (log.isInfoEnabled()) {
            log.info((Object)("SetDirty sample: " + sample.getId()));
        }
        if ((batch = sample.getBatch()) != null && batch instanceof CatchBatch) {
            this.setDirty((CatchBatch)batch);
        } else {
            this.setDirty(sample.getFishingOperation().getFishingTrip());
        }
    }

    public void setCruiseReadyToSynch(Integer cruiseId) {
        int scientificCruiseQueryUpdate;
        String oldStatus = this.getDirtyValue();
        String newStatus = SynchronizationStatus.READY_TO_SYNCHRONIZE.getValue();
        if (log.isInfoEnabled()) {
            log.info((Object)("setCruiseReadyToSynch cruise: " + cruiseId));
        }
        if ((scientificCruiseQueryUpdate = this.queryUpdate("updateScientificCruiseSynchronizationStatus", "cruiseId", IntegerType.INSTANCE, cruiseId, "oldStatus", StringType.INSTANCE, oldStatus, "newStatus", StringType.INSTANCE, newStatus)) == 0) {
            throw new DataIntegrityViolationException("Could not attach update scientific cruise, was not found.");
        }
        int fishingTripQueryUpdate = this.queryUpdate("updateFishingTripSynchronizationStatus", "cruiseId", IntegerType.INSTANCE, cruiseId, "oldStatus", StringType.INSTANCE, oldStatus, "newStatus", StringType.INSTANCE, newStatus);
        if (log.isInfoEnabled()) {
            log.info((Object)("Nb fishingTrip  updated: " + fishingTripQueryUpdate));
        }
        int catchBatchQueryUpdate = this.queryUpdate("updateCatchBatchSynchronizationStatus", "cruiseId", IntegerType.INSTANCE, cruiseId, "oldStatus", StringType.INSTANCE, oldStatus, "newStatus", StringType.INSTANCE, newStatus);
        if (log.isInfoEnabled()) {
            log.info((Object)("Nb catchBatch  updated: " + catchBatchQueryUpdate));
        }
        int sampleQueryUpdate = this.queryUpdate("updateSampleSynchronizationStatus", "cruiseId", IntegerType.INSTANCE, cruiseId, "oldStatus", StringType.INSTANCE, oldStatus, "newStatus", StringType.INSTANCE, newStatus);
        if (log.isInfoEnabled()) {
            log.info((Object)("Nb sample updated: " + sampleQueryUpdate));
        }
    }

    protected String getDirtyValue() {
        return SynchronizationStatus.DIRTY.getValue();
    }

    public void setDirty(fr.ifremer.tutti.persistence.entities.data.CatchBatch bean) {
        bean.setSynchronizationStatus(this.getDirtyValue());
    }

    public void setDirty(IndividualObservationBatch bean) {
        bean.setSynchronizationStatus(this.getDirtyValue());
    }

    public void setDirty(AccidentalBatch bean) {
        bean.setSynchronizationStatus(this.getDirtyValue());
    }
}

