/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.action;

import fr.ifremer.adagio.core.action.DatabaseChangeLogAction;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import java.io.File;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfigHelper;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.i18n.I18n;

public class ActionUtils {
    private static final Log log = LogFactory.getLog(DatabaseChangeLogAction.class);

    protected ActionUtils() {
    }

    public static void logConnectionProperties() {
        String jdbcSchema;
        if (!log.isInfoEnabled()) {
            return;
        }
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        boolean isFileDatabase = DaoUtils.isFileDatabase(config.getJdbcURL());
        if (isFileDatabase) {
            log.info((Object)String.format(" Database directory: %s", config.getDbDirectory()));
        }
        log.info((Object)String.format(" JDBC Driver: %s", config.getJdbcDriver()));
        log.info((Object)String.format(" JDBC URL: %s", config.getJdbcURL()));
        log.info((Object)String.format(" JDBC Username: %s", config.getJdbcUsername()));
        String jdbcCatalog = config.getJdbcCatalog();
        if (StringUtils.isNotBlank((CharSequence)jdbcCatalog)) {
            log.info((Object)String.format(" JDBC Catalog: %s", jdbcCatalog));
        }
        if (StringUtils.isNotBlank((CharSequence)(jdbcSchema = config.getJdbcSchema()))) {
            log.info((Object)String.format(" JDBC Schema: %s", jdbcSchema));
        }
    }

    public static File checkAndGetOutputFile(boolean isDirectory, Class<?> actionClass) {
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        File output = config.getLiquibaseOutputFile();
        if (output == null) {
            log.error((Object)I18n.t((String)"adagio.action.noOutput.error", (Object[])new Object[]{"--output [...]", ActionUtils.getActionAlias(actionClass)}));
            System.exit(-1);
        }
        if (output.exists()) {
            if (isDirectory) {
                if (!output.isDirectory()) {
                    log.error((Object)I18n.t((String)"adagio.action.outputNotADirectory.error", (Object[])new Object[]{output.getPath()}));
                    System.exit(-1);
                } else if (ArrayUtils.isNotEmpty((Object[])output.listFiles())) {
                    log.error((Object)I18n.t((String)"adagio.action.outputNotEmptyDirectory.error", (Object[])new Object[]{output.getPath()}));
                    System.exit(-1);
                }
            } else {
                log.error((Object)I18n.t((String)"adagio.action.outputNotAFile.error", (Object[])new Object[]{output.getPath()}));
                System.exit(-1);
            }
        }
        return output;
    }

    public static String getActionAlias(Class<?> clazz) {
        Object[] alias;
        Object actionDefFound = null;
        Set providers = ApplicationConfigHelper.getProviders(null, null, null, (boolean)true);
        for (ApplicationConfigProvider provider : providers) {
            Object[] actionDefs = provider.getActions();
            if (!ArrayUtils.isNotEmpty((Object[])actionDefs)) continue;
            for (Object actionDef : actionDefs) {
                if (!clazz.equals(actionDef.getClass())) continue;
                actionDefFound = actionDef;
                break;
            }
            if (actionDefFound == null) continue;
            break;
        }
        if (actionDefFound != null && ArrayUtils.isNotEmpty((Object[])(alias = actionDefFound.getAliases()))) {
            return alias[0];
        }
        return I18n.t((String)"adagio.action.current", (Object[])new Object[0]);
    }
}

