package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class SpeciesFrequencyUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SpeciesFrequencyUIModel, SpeciesFrequencyUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AUTO_GEN_MODE_BUTTON_SELECTED = "autoGenModeButton.selected";
    public static final String BINDING_DATA_FIELD_LAYOUT_SELECTED = "dataFieldLayout.selected";
    public static final String BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE = "dataInFrequenciesWarningContainer.visible";
    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE = "lengthstepSettingsBlock.visible";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED = "lengthStepCaracteristicComboBox.enabled";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "lengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED = "lengthStepCaracteristicLabel.enabled";
    public static final String BINDING_MAX_STEP_FIELD_MODEL = "maxStepField.model";
    public static final String BINDING_MAX_STEP_FIELD_NUMBER_PATTERN = "maxStepField.numberPattern";
    public static final String BINDING_MIN_STEP_FIELD_MODEL = "minStepField.model";
    public static final String BINDING_MIN_STEP_FIELD_NUMBER_PATTERN = "minStepField.numberPattern";
    public static final String BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED = "modeConfigurationLayout.selected";
    public static final String BINDING_RAFALE_MODE_BUTTON_SELECTED = "rafaleModeButton.selected";
    public static final String BINDING_RAFALE_STEP_FIELD_ENABLED = "rafaleStepField.enabled";
    public static final String BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN = "rafaleStepField.numberPattern";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";
    public static final String BINDING_SIMPLE_COUNTING_FIELD_MODEL = "simpleCountingField.model";
    public static final String BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED = "simpleCountingModeButton.selected";
    public static final String BINDING_STEP_FIELD_ENABLED = "stepField.enabled";
    public static final String BINDING_STEP_FIELD_MODEL = "stepField.model";
    public static final String BINDING_STEP_FIELD_NUMBER_PATTERN = "stepField.numberPattern";
    public static final String BINDING_STEP_LABEL_ENABLED = "stepLabel.enabled";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";
    public static final String BINDING_TOTAL_NUMBER_FIELD_TEXT = "totalNumberField.text";
    public static final String BINDING_TOTAL_NUMBER_LABEL_ENABLED = "totalNumberLabel.enabled";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_BEAN = "totalWeightField.bean";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_MODEL = "totalWeightField.model";
    public static final String BINDING_TOTAL_WEIGHT_LABEL_ENABLED = "totalWeightLabel.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JButton addLengthStepCaracteristicButton;
    protected JRadioButton autoGenModeButton;
    protected JPanel autoGenModePanel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected JPanel configurationPanel;
    protected CardLayout2Ext dataFieldLayout;
    protected JPanel dataFieldPanel;
    protected JLabel dataInFrequenciesWarning;
    protected JPanel dataInFrequenciesWarningContainer;
    protected SpeciesFrequencyUI editSpeciesFrequenciesTopPanel = this;
    protected JButton generateButton;
    protected final SpeciesFrequencyUIHandler handler = new SpeciesFrequencyUIHandler();
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "lengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> lengthStepCaracteristicComboBox;
    protected JLabel lengthStepCaracteristicLabel;
    protected Table lengthstepSettingsBlock;
    protected NumberEditor maxStepField;
    protected JLabel maxStepLabel;
    protected NumberEditor minStepField;
    protected JLabel minStepLabel;
    protected JAXXButtonGroup mode;
    protected CardLayout2Ext modeConfigurationLayout;
    protected JPanel modeConfigurationPanel;
    protected VBox modePanel;
    protected SpeciesFrequencyUIModel model;
    protected JRadioButton rafaleModeButton;
    protected JPanel rafaleModePanel;
    protected NumberEditor rafaleStepField;
    protected JLabel rafaleStepLabel;
    protected JButton resetButton;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    protected NumberEditor simpleCountingField;
    protected JLabel simpleCountingLabel;
    protected JRadioButton simpleCountingModeButton;
    protected JLabel simpleCountingModeLabel;
    protected JPanel simpleCountingModePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "step",  editorName = "stepField")
    protected NumberEditor stepField;
    protected JLabel stepLabel;
    protected JXTable table;
    @ValidatorField( validatorId = "validator",  propertyName = "rows",  editorName = "tableScrollPane")
    protected JScrollPane tableScrollPane;
    protected JTextField totalNumberField;
    protected JLabel totalNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "totalWeight",  editorName = "totalWeightField")
    protected ComputableDataEditor<Float> totalWeightField;
    protected JLabel totalWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesFrequencyUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesFrequencyUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SpeciesFrequencyUI() {
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addLengthStepCaracteristicButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addLengthStepCaracteristic();
    }

    public void doActionPerformed__on__autoGenModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.AUTO_GEN);
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__generateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateLengthSteps();
    }

    public void doActionPerformed__on__rafaleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.RAFALE);
    }

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reset();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    public void doActionPerformed__on__simpleCountingModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(FrequencyConfigurationMode.SIMPLE_COUNTING);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JButton getAddLengthStepCaracteristicButton() {
        return addLengthStepCaracteristicButton;
    }

    public JRadioButton getAutoGenModeButton() {
        return autoGenModeButton;
    }

    public JPanel getAutoGenModePanel() {
        return autoGenModePanel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public CardLayout2Ext getDataFieldLayout() {
        return dataFieldLayout;
    }

    public JPanel getDataFieldPanel() {
        return dataFieldPanel;
    }

    public JLabel getDataInFrequenciesWarning() {
        return dataInFrequenciesWarning;
    }

    public JPanel getDataInFrequenciesWarningContainer() {
        return dataInFrequenciesWarningContainer;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public SpeciesFrequencyUIHandler getHandler() {
        return handler;
    }

    public BeanFilterableComboBox<Caracteristic> getLengthStepCaracteristicComboBox() {
        return lengthStepCaracteristicComboBox;
    }

    public JLabel getLengthStepCaracteristicLabel() {
        return lengthStepCaracteristicLabel;
    }

    public Table getLengthstepSettingsBlock() {
        return lengthstepSettingsBlock;
    }

    public NumberEditor getMaxStepField() {
        return maxStepField;
    }

    public JLabel getMaxStepLabel() {
        return maxStepLabel;
    }

    public NumberEditor getMinStepField() {
        return minStepField;
    }

    public JLabel getMinStepLabel() {
        return minStepLabel;
    }

    public JAXXButtonGroup getMode() {
        return mode;
    }

    public CardLayout2Ext getModeConfigurationLayout() {
        return modeConfigurationLayout;
    }

    public JPanel getModeConfigurationPanel() {
        return modeConfigurationPanel;
    }

    public VBox getModePanel() {
        return modePanel;
    }

    public SpeciesFrequencyUIModel getModel() {
        return model;
    }

    public JRadioButton getRafaleModeButton() {
        return rafaleModeButton;
    }

    public JPanel getRafaleModePanel() {
        return rafaleModePanel;
    }

    public NumberEditor getRafaleStepField() {
        return rafaleStepField;
    }

    public JLabel getRafaleStepLabel() {
        return rafaleStepLabel;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public NumberEditor getSimpleCountingField() {
        return simpleCountingField;
    }

    public JLabel getSimpleCountingLabel() {
        return simpleCountingLabel;
    }

    public JRadioButton getSimpleCountingModeButton() {
        return simpleCountingModeButton;
    }

    public JLabel getSimpleCountingModeLabel() {
        return simpleCountingModeLabel;
    }

    public JPanel getSimpleCountingModePanel() {
        return simpleCountingModePanel;
    }

    public NumberEditor getStepField() {
        return stepField;
    }

    public JLabel getStepLabel() {
        return stepLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JTextField getTotalNumberField() {
        return totalNumberField;
    }

    public JLabel getTotalNumberLabel() {
        return totalNumberLabel;
    }

    public ComputableDataEditor<Float> getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightLabel() {
        return totalWeightLabel;
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(resetButton);
        actionPanel.add(saveAndContinueButton);
        actionPanel.add(saveAndCloseButton);
    }

    protected void addChildrenToAutoGenModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; autoGenModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(autoGenModeButton); }
    }

    protected void addChildrenToAutoGenModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        autoGenModePanel.add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(modePanel, BorderLayout.WEST);
        configurationPanel.add(modeConfigurationPanel, BorderLayout.CENTER);
        configurationPanel.add(lengthstepSettingsBlock, BorderLayout.SOUTH);
    }

    protected void addChildrenToDataFieldPanel() {
        if (!allComponentsCreated) {
            return;
        }
        dataFieldPanel.add(SwingUtil.boxComponentWithJxLayer(tableScrollPane), "lengthCaracteristicPmfm");
        dataFieldPanel.add($Table2, "noLengthCaracteristicPmfm");
    }

    protected void addChildrenToDataInFrequenciesWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        dataInFrequenciesWarningContainer.add(dataInFrequenciesWarning, BorderLayout.CENTER);
    }

    protected void addChildrenToEditSpeciesFrequenciesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(dataFieldPanel, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToLengthstepSettingsBlock() {
        if (!allComponentsCreated) {
            return;
        }
        lengthstepSettingsBlock.add($JSeparator0, new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(lengthStepCaracteristicLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add($JPanel1, new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(stepLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(stepField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalNumberField, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(totalWeightLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        lengthstepSettingsBlock.add(SwingUtil.boxComponentWithJxLayer(totalWeightField), new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToModeConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        modeConfigurationPanel.add(autoGenModePanel, "autoGenMode");
        modeConfigurationPanel.add(rafaleModePanel, "rafaleMode");
        modeConfigurationPanel.add(simpleCountingModePanel, "simpleCountingMode");
    }

    protected void addChildrenToModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        modePanel.add(autoGenModeButton);
        modePanel.add(rafaleModeButton);
        modePanel.add(simpleCountingModeButton);
    }

    protected void addChildrenToRafaleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; rafaleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(rafaleModeButton); }
    }

    protected void addChildrenToRafaleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rafaleModePanel.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToSimpleCountingModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleCountingModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleCountingModeButton); }
    }

    protected void addChildrenToSimpleCountingModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleCountingModePanel.add(simpleCountingModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createAddLengthStepCaracteristicButton() {
        $objectMap.put("addLengthStepCaracteristicButton", addLengthStepCaracteristicButton = new JButton());
        
        addLengthStepCaracteristicButton.setName("addLengthStepCaracteristicButton");
        addLengthStepCaracteristicButton.setText(t("tutti.editSpeciesFrequencies.action.addLengthStepCaracteristic"));
        addLengthStepCaracteristicButton.setToolTipText(t("tutti.editSpeciesFrequencies.action.addLengthStepCaracteristic.tip"));
        addLengthStepCaracteristicButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addLengthStepCaracteristicButton"));
        addLengthStepCaracteristicButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.addLengthStepCaracteristic.help");
    }

    protected void createAutoGenModeButton() {
        $objectMap.put("autoGenModeButton", autoGenModeButton = new JRadioButton());
        
        autoGenModeButton.setName("autoGenModeButton");
        autoGenModeButton.setText(t("tutti.editSpeciesFrequencies.field.mode.autoGen"));
        { autoGenModeButton.putClientProperty("$value", "autoGenMode");  Object $buttonGroup = autoGenModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        autoGenModeButton.setToolTipText(t("tutti.editSpeciesFrequencies.field.mode.autoGen.tip"));
        autoGenModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autoGenModeButton"));
        autoGenModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.autoGen.help");
    }

    protected void createAutoGenModePanel() {
        $objectMap.put("autoGenModePanel", autoGenModePanel = new JPanel());
        
        autoGenModePanel.setName("autoGenModePanel");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editSpeciesFrequencies.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.editSpeciesFrequencies.action.cancel"));
        cancelButton.setToolTipText(t("tutti.editSpeciesFrequencies.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new BorderLayout());
    }

    protected void createDataFieldLayout() {
        $objectMap.put("dataFieldLayout", dataFieldLayout = new CardLayout2Ext(this, "dataFieldPanel"));
    }

    protected void createDataFieldPanel() {
        $objectMap.put("dataFieldPanel", dataFieldPanel = new JPanel());
        
        dataFieldPanel.setName("dataFieldPanel");
        dataFieldPanel.setLayout(dataFieldLayout);
    }

    protected void createDataInFrequenciesWarning() {
        $objectMap.put("dataInFrequenciesWarning", dataInFrequenciesWarning = new JLabel());
        
        dataInFrequenciesWarning.setName("dataInFrequenciesWarning");
        dataInFrequenciesWarning.setText(t("tutti.editSpeciesFrequencies.simpleCountingAndFrequencies"));
    }

    protected void createDataInFrequenciesWarningContainer() {
        $objectMap.put("dataInFrequenciesWarningContainer", dataInFrequenciesWarningContainer = new JPanel());
        
        dataInFrequenciesWarningContainer.setName("dataInFrequenciesWarningContainer");
        dataInFrequenciesWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(t("tutti.editSpeciesFrequencies.action.generate"));
        generateButton.setToolTipText(t("tutti.editSpeciesFrequencies.action.generate.tip"));
        generateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateButton"));
        generateButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.generate.help");
    }

    protected void createLengthStepCaracteristicComboBox() {
        $objectMap.put("lengthStepCaracteristicComboBox", lengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        lengthStepCaracteristicComboBox.setName("lengthStepCaracteristicComboBox");
        lengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        lengthStepCaracteristicComboBox.setShowReset(true);
        lengthStepCaracteristicComboBox.putClientProperty("help", "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
        lengthStepCaracteristicComboBox.putClientProperty("validatorLabel", t("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic"));
    }

    protected void createLengthStepCaracteristicLabel() {
        $objectMap.put("lengthStepCaracteristicLabel", lengthStepCaracteristicLabel = new JLabel());
        
        lengthStepCaracteristicLabel.setName("lengthStepCaracteristicLabel");
        lengthStepCaracteristicLabel.setText(t("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic"));
        lengthStepCaracteristicLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.tip"));
        lengthStepCaracteristicLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
    }

    protected void createLengthstepSettingsBlock() {
        $objectMap.put("lengthstepSettingsBlock", lengthstepSettingsBlock = new Table());
        
        lengthstepSettingsBlock.setName("lengthstepSettingsBlock");
    }

    protected void createMaxStepField() {
        $objectMap.put("maxStepField", maxStepField = new NumberEditor(this));
        
        maxStepField.setName("maxStepField");
        maxStepField.setProperty("maxStep");
        maxStepField.setUseFloat(true);
        maxStepField.setShowReset(true);
        maxStepField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.maxStep.help");
        maxStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMaxStepLabel() {
        $objectMap.put("maxStepLabel", maxStepLabel = new JLabel());
        
        maxStepLabel.setName("maxStepLabel");
        maxStepLabel.setText(t("tutti.editSpeciesFrequencies.field.maxStep"));
        maxStepLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.maxStep.tip"));
        maxStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.maxStep.help");
    }

    protected void createMinStepField() {
        $objectMap.put("minStepField", minStepField = new NumberEditor(this));
        
        minStepField.setName("minStepField");
        minStepField.setProperty("minStep");
        minStepField.setUseFloat(true);
        minStepField.setShowReset(true);
        minStepField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.minStep.help");
        minStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createMinStepLabel() {
        $objectMap.put("minStepLabel", minStepLabel = new JLabel());
        
        minStepLabel.setName("minStepLabel");
        minStepLabel.setText(t("tutti.editSpeciesFrequencies.field.minStep"));
        minStepLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.minStep.tip"));
        minStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.minStep.help");
    }

    protected void createMode() {
        $objectMap.put("mode", mode = new JAXXButtonGroup());
    }

    protected void createModeConfigurationLayout() {
        $objectMap.put("modeConfigurationLayout", modeConfigurationLayout = new CardLayout2Ext(this, "modeConfigurationPanel"));
    }

    protected void createModeConfigurationPanel() {
        $objectMap.put("modeConfigurationPanel", modeConfigurationPanel = new JPanel());
        
        modeConfigurationPanel.setName("modeConfigurationPanel");
        modeConfigurationPanel.setLayout(modeConfigurationLayout);
    }

    protected void createModePanel() {
        $objectMap.put("modePanel", modePanel = new VBox());
        
        modePanel.setName("modePanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesFrequencyUIModel.class));
    }

    protected void createRafaleModeButton() {
        $objectMap.put("rafaleModeButton", rafaleModeButton = new JRadioButton());
        
        rafaleModeButton.setName("rafaleModeButton");
        rafaleModeButton.setText(t("tutti.editSpeciesFrequencies.field.mode.rafale"));
        { rafaleModeButton.putClientProperty("$value", "rafaleMode");  Object $buttonGroup = rafaleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        rafaleModeButton.setToolTipText(t("tutti.editSpeciesFrequencies.field.mode.rafale.tip"));
        rafaleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rafaleModeButton"));
        rafaleModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.rafale.help");
    }

    protected void createRafaleModePanel() {
        $objectMap.put("rafaleModePanel", rafaleModePanel = new JPanel());
        
        rafaleModePanel.setName("rafaleModePanel");
    }

    protected void createRafaleStepField() {
        $objectMap.put("rafaleStepField", rafaleStepField = new NumberEditor(this));
        
        rafaleStepField.setName("rafaleStepField");
        rafaleStepField.setUseFloat(true);
        rafaleStepField.setShowReset(true);
        rafaleStepField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.rafaleStep.help");
        rafaleStepField.putClientProperty("selectOnFocus", true);
    }

    protected void createRafaleStepLabel() {
        $objectMap.put("rafaleStepLabel", rafaleStepLabel = new JLabel());
        
        rafaleStepLabel.setName("rafaleStepLabel");
        rafaleStepLabel.setText(t("tutti.editSpeciesFrequencies.field.rafaleStep"));
        rafaleStepLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.rafaleStep.tip"));
        rafaleStepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.rafaleStep.help");
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setText(t("tutti.editSpeciesFrequencies.action.reset"));
        resetButton.setToolTipText(t("tutti.editSpeciesFrequencies.action.reset.tip"));
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
        resetButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.reset.help");
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.editSpeciesFrequencies.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.editSpeciesFrequencies.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.editSpeciesFrequencies.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.editSpeciesFrequencies.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.editSpeciesFrequencies.action.saveAndContinue.help");
    }

    protected void createSimpleCountingField() {
        $objectMap.put("simpleCountingField", simpleCountingField = new NumberEditor(this));
        
        simpleCountingField.setName("simpleCountingField");
        simpleCountingField.setProperty("simpleCount");
        simpleCountingField.setUseFloat(false);
        simpleCountingField.setShowReset(true);
        simpleCountingField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.simpleCounting.help");
    }

    protected void createSimpleCountingLabel() {
        $objectMap.put("simpleCountingLabel", simpleCountingLabel = new JLabel());
        
        simpleCountingLabel.setName("simpleCountingLabel");
        simpleCountingLabel.setText(t("tutti.editSpeciesFrequencies.field.simpleCounting"));
        simpleCountingLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.simpleCounting.tip"));
        simpleCountingLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.simpleCounting.help");
    }

    protected void createSimpleCountingModeButton() {
        $objectMap.put("simpleCountingModeButton", simpleCountingModeButton = new JRadioButton());
        
        simpleCountingModeButton.setName("simpleCountingModeButton");
        simpleCountingModeButton.setText(t("tutti.editSpeciesFrequencies.field.mode.simpleCounting"));
        { simpleCountingModeButton.putClientProperty("$value", "simpleCountingMode");  Object $buttonGroup = simpleCountingModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleCountingModeButton.setToolTipText(t("tutti.editSpeciesFrequencies.field.mode.simpleCounting.tip"));
        simpleCountingModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleCountingModeButton"));
        simpleCountingModeButton.putClientProperty("help", "tutti.editSpeciesFrequencies.field.mode.simpleCounting.help");
    }

    protected void createSimpleCountingModeLabel() {
        $objectMap.put("simpleCountingModeLabel", simpleCountingModeLabel = new JLabel());
        
        simpleCountingModeLabel.setName("simpleCountingModeLabel");
        simpleCountingModeLabel.setEnabled(false);
        simpleCountingModeLabel.setText(t("tutti.editSpeciesFrequencies.label.no.configuration"));
    }

    protected void createSimpleCountingModePanel() {
        $objectMap.put("simpleCountingModePanel", simpleCountingModePanel = new JPanel());
        
        simpleCountingModePanel.setName("simpleCountingModePanel");
        simpleCountingModePanel.setLayout(new BorderLayout());
    }

    protected void createStepField() {
        $objectMap.put("stepField", stepField = new NumberEditor(this));
        
        stepField.setName("stepField");
        stepField.setProperty("step");
        stepField.setUseFloat(true);
        stepField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.step.help");
        stepField.putClientProperty("validatorLabel", t("tutti.editSpeciesFrequencies.field.step"));
        stepField.putClientProperty("selectOnFocus", true);
    }

    protected void createStepLabel() {
        $objectMap.put("stepLabel", stepLabel = new JLabel());
        
        stepLabel.setName("stepLabel");
        stepLabel.setText(t("tutti.editSpeciesFrequencies.field.step"));
        stepLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.step.tip"));
        stepLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.step.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
        tableScrollPane.putClientProperty("validatorLabel", t("tutti.editSpeciesFrequencies.field.rows"));
    }

    protected void createTotalNumberField() {
        $objectMap.put("totalNumberField", totalNumberField = new JTextField());
        
        totalNumberField.setName("totalNumberField");
        totalNumberField.setColumns(15);
        totalNumberField.setEnabled(false);
        totalNumberField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalNumber.help");
        totalNumberField.putClientProperty("computed", true);
    }

    protected void createTotalNumberLabel() {
        $objectMap.put("totalNumberLabel", totalNumberLabel = new JLabel());
        
        totalNumberLabel.setName("totalNumberLabel");
        totalNumberLabel.setText(t("tutti.editSpeciesFrequencies.field.totalNumber"));
        totalNumberLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.totalNumber.tip"));
        totalNumberLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalNumber.help");
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new ComputableDataEditor<Float>(this));
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setUseFloat(true);
        totalWeightField.setShowReset(true);
        totalWeightField.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalWeight.help");
        totalWeightField.putClientProperty("validatorLabel", t("tutti.editSpeciesFrequencies.field.totalWeight"));
    }

    protected void createTotalWeightLabel() {
        $objectMap.put("totalWeightLabel", totalWeightLabel = new JLabel());
        
        totalWeightLabel.setName("totalWeightLabel");
        totalWeightLabel.setText(t("tutti.editSpeciesFrequencies.field.totalWeight"));
        totalWeightLabel.setToolTipText(t("tutti.editSpeciesFrequencies.field.totalWeight.tip"));
        totalWeightLabel.putClientProperty("help", "tutti.editSpeciesFrequencies.field.totalWeight.help");
        totalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesFrequencyUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditSpeciesFrequenciesTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToModePanel();
        addChildrenToAutoGenModeButton();
        addChildrenToRafaleModeButton();
        addChildrenToSimpleCountingModeButton();
        addChildrenToModeConfigurationPanel();
        addChildrenToAutoGenModePanel();
        // inline complete setup of $Table0
        $Table0.add(minStepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(minStepField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(generateButton);
        addChildrenToRafaleModePanel();
        // inline complete setup of $Table1
        $Table1.add(rafaleStepLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(rafaleStepField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSimpleCountingModePanel();
        addChildrenToLengthstepSettingsBlock();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(lengthStepCaracteristicComboBox), BorderLayout.CENTER);
        $JPanel1.add(addLengthStepCaracteristicButton, BorderLayout.EAST);
        addChildrenToDataFieldPanel();
        addChildrenToTableScrollPane();
        // inline complete setup of $Table2
        $Table2.add(dataInFrequenciesWarningContainer, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(simpleCountingField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDataInFrequenciesWarningContainer();
        addChildrenToActionPanel();
        
        // apply 30 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 58 property setters
        modePanel.setVerticalAlignment(SwingConstants.CENTER);
        lengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        configurationPanel.setBorder(new TitledBorder(null, null));
        minStepLabel.setLabelFor(minStepField);
        minStepField.setBean(model);
        minStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        minStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        maxStepLabel.setLabelFor(maxStepField);
        maxStepField.setBean(model);
        maxStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        maxStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.action.generate.mnemonic"),'Z'));
        rafaleStepLabel.setLabelFor(rafaleStepField);
        rafaleStepField.setModelType(Float.class);
        rafaleStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rafaleStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        simpleCountingModeLabel.setHorizontalAlignment(JLabel.CENTER);
        lengthStepCaracteristicLabel.setLabelFor(lengthStepCaracteristicComboBox);
        lengthStepCaracteristicComboBox.setBean(model);
        addLengthStepCaracteristicButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.action.addLengthStepCaracteristic.mnemonic"),'Z'));
        stepLabel.setLabelFor(stepField);
        stepField.setBean(model);
        stepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        totalNumberLabel.setLabelFor(totalNumberField);
        totalWeightLabel.setLabelFor(totalWeightField);
        totalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        totalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        dataInFrequenciesWarningContainer.setBackground(new java.awt.Color(245, 218, 88));
        dataInFrequenciesWarning.setIcon(SwingUtil.createActionIcon("warning"));
        dataInFrequenciesWarning.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        simpleCountingLabel.setLabelFor(simpleCountingField);
        simpleCountingField.setBean(model);
        simpleCountingField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        simpleCountingField.setNumberPattern(TuttiUI.INT_6_DIGITS_PATTERN);
        simpleCountingField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.action.cancel.mnemonic"),'Z'));
        resetButton.setIcon(SwingUtil.createActionIcon("reset"));
        resetButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.action.reset.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesFrequencies.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editSpeciesFrequenciesTopPanel, "tutti.editSpeciesFrequencies.help");
        registerHelpId(_broker, autoGenModeButton, "tutti.editSpeciesFrequencies.field.mode.autoGen.help");
        registerHelpId(_broker, rafaleModeButton, "tutti.editSpeciesFrequencies.field.mode.rafale.help");
        registerHelpId(_broker, simpleCountingModeButton, "tutti.editSpeciesFrequencies.field.mode.simpleCounting.help");
        registerHelpId(_broker, minStepLabel, "tutti.editSpeciesFrequencies.field.minStep.help");
        registerHelpId(_broker, minStepField, "tutti.editSpeciesFrequencies.field.minStep.help");
        registerHelpId(_broker, maxStepLabel, "tutti.editSpeciesFrequencies.field.maxStep.help");
        registerHelpId(_broker, maxStepField, "tutti.editSpeciesFrequencies.field.maxStep.help");
        registerHelpId(_broker, generateButton, "tutti.editSpeciesFrequencies.action.generate.help");
        registerHelpId(_broker, rafaleStepLabel, "tutti.editSpeciesFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, rafaleStepField, "tutti.editSpeciesFrequencies.field.rafaleStep.help");
        registerHelpId(_broker, lengthStepCaracteristicLabel, "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, lengthStepCaracteristicComboBox, "tutti.editSpeciesFrequencies.field.lengthStepCaracteristic.help");
        registerHelpId(_broker, addLengthStepCaracteristicButton, "tutti.editSpeciesFrequencies.action.addLengthStepCaracteristic.help");
        registerHelpId(_broker, stepLabel, "tutti.editSpeciesFrequencies.field.step.help");
        registerHelpId(_broker, stepField, "tutti.editSpeciesFrequencies.field.step.help");
        registerHelpId(_broker, totalNumberLabel, "tutti.editSpeciesFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalNumberField, "tutti.editSpeciesFrequencies.field.totalNumber.help");
        registerHelpId(_broker, totalWeightLabel, "tutti.editSpeciesFrequencies.field.totalWeight.help");
        registerHelpId(_broker, totalWeightField, "tutti.editSpeciesFrequencies.field.totalWeight.help");
        registerHelpId(_broker, simpleCountingLabel, "tutti.editSpeciesFrequencies.field.simpleCounting.help");
        registerHelpId(_broker, simpleCountingField, "tutti.editSpeciesFrequencies.field.simpleCounting.help");
        registerHelpId(_broker, cancelButton, "tutti.editSpeciesFrequencies.action.cancel.help");
        registerHelpId(_broker, resetButton, "tutti.editSpeciesFrequencies.action.reset.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.editSpeciesFrequencies.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.editSpeciesFrequencies.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editSpeciesFrequenciesTopPanel", editSpeciesFrequenciesTopPanel);
        createModel();
        createValidator();
        createBroker();
        createModeConfigurationLayout();
        createDataFieldLayout();
        createConfigurationPanel();
        createModePanel();
        createAutoGenModeButton();
        createRafaleModeButton();
        createSimpleCountingModeButton();
        createModeConfigurationPanel();
        createAutoGenModePanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMinStepLabel();
        createMinStepField();
        createMaxStepLabel();
        createMaxStepField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createGenerateButton();
        createRafaleModePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createRafaleStepLabel();
        createRafaleStepField();
        createSimpleCountingModePanel();
        createSimpleCountingModeLabel();
        createLengthstepSettingsBlock();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createLengthStepCaracteristicLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createLengthStepCaracteristicComboBox();
        createAddLengthStepCaracteristicButton();
        createStepLabel();
        createStepField();
        createTotalNumberLabel();
        createTotalNumberField();
        createTotalWeightLabel();
        createTotalWeightField();
        createDataFieldPanel();
        createTableScrollPane();
        createTable();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createDataInFrequenciesWarningContainer();
        createDataInFrequenciesWarning();
        createSimpleCountingLabel();
        createSimpleCountingField();
        createActionPanel();
        createCancelButton();
        createResetButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        createMode();
        // inline creation of editSpeciesFrequenciesTopPanel
        setName("editSpeciesFrequenciesTopPanel");
        setLayout(new BorderLayout());
        editSpeciesFrequenciesTopPanel.putClientProperty("help", "tutti.editSpeciesFrequencies.help");
        
        // registers 30 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 30 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (mode != null) {
                    mode.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (mode != null) {
                    modeConfigurationLayout.setSelected(String.valueOf(mode.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (mode != null) {
                    mode.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_FIELD_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dataFieldLayout.setSelected(model.isSimpleCountingMode() ? "noLengthCaracteristicPmfm" : "lengthCaracteristicPmfm");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTO_GEN_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("autoGenMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    autoGenModeButton.setSelected(model.isAutoGenMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("autoGenMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rafaleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleModeButton.setSelected(model.isRafaleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rafaleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingModeButton.setSelected(model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MIN_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minStepField.setModel(model.getMinStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIN_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                minStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAX_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    maxStepField.setModel(model.getMaxStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MAX_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                maxStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isCanGenerate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleStepField.setEnabled(model.getLengthStepCaracteristic() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                rafaleStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTHSTEP_SETTINGS_BLOCK_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthstepSettingsBlock.setVisible(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setModel(model.getStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                stepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCountingMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalNumberLabel.setEnabled(!model.isSimpleCountingMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCountingMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(totalNumberField, getStringValue(model.getTotalNumber()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_LABEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightLabel.setEnabled(model.getTotalWeight() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setModel(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setBean(model.getTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getLengthStepCaracteristic() != null && model.getStep() > 0f);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATA_IN_FREQUENCIES_WARNING_CONTAINER_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("emptyRows", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("rows", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getRows() != null && model.getEmptyRows() != null && model.getRowsInError() != null) {
                    dataInFrequenciesWarningContainer.setVisible((model.getRowsInError().size() + model.getEmptyRows().size()) != model.getRows().size());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rowsInError", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("emptyRows", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("rows", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_COUNTING_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleCountingField.setModel(model.getSimpleCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nextEditableRowIndex", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.getNextEditableRowIndex() != null && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nextEditableRowIndex", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}