/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.computable;

import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.NumberEditorHandler;

public class ComputableDataEditorHandler
extends NumberEditorHandler {
    protected Integer decimalNumber;

    public ComputableDataEditorHandler(ComputableDataEditor ui) {
        super((NumberEditor)ui);
    }

    public void init() {
        final PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableDataEditorHandler.this.setComputedTextIfNullModel();
            }
        };
        ComputableData bean = (ComputableData)((Object)this.editor.getBean());
        if (bean != null) {
            bean.addPropertyChangeListener(l);
        }
        this.editor.addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableData bean = (ComputableData)((Object)evt.getOldValue());
                if (bean != null) {
                    bean.removePropertyChangeListener("computedData", l);
                }
                if ((bean = (ComputableData)((Object)evt.getNewValue())) != null) {
                    bean.addPropertyChangeListener("computedData", l);
                }
            }
        });
        this.editor.addPropertyChangeListener("model", l);
        this.editor.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextField tf = ComputableDataEditorHandler.this.editor.getTextField();
                tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
                tf.setForeground(Color.BLACK);
                if (ComputableDataEditorHandler.this.editor.getModel() == null) {
                    tf.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ComputableDataEditorHandler.this.setComputedTextIfNullModel();
            }
        });
        this.editor.addPropertyChangeListener("decimalNumber", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComputableDataEditorHandler.this.decimalNumber = (Integer)evt.getNewValue();
            }
        });
        this.decimalNumber = ((ComputableDataEditor)this.editor).getDecimalNumber();
        super.init();
    }

    protected void setComputedTextIfNullModel() {
        ComputableData bean = (ComputableData)((Object)this.editor.getBean());
        JTextField tf = this.editor.getTextField();
        if (bean != null && this.editor.getModel() == null) {
            String modelText;
            tf.setFont(TuttiUI.TEXTFIELD_COMPUTED_FONT);
            tf.setForeground(((ComputableDataEditor)this.editor).getComputedDataColor());
            Object computedData = bean.getComputedData();
            if (this.editor.isUseFloat().booleanValue() && this.decimalNumber != null && computedData != null) {
                DecimalFormat decimalFormat = Weights.getDecimalFormat(1, this.decimalNumber);
                modelText = decimalFormat.format(computedData);
            } else {
                modelText = JAXXUtil.getStringValue(computedData);
            }
            tf.setText(modelText);
        } else {
            tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
            tf.setForeground(Color.BLACK);
        }
    }
}

