/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoUtils;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.sql.TIMESTAMP;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.ForeignKeyMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.i18n.I18n;

public class SynchroTableMetadata {
    private static final Log log = LogFactory.getLog(SynchroTableMetadata.class);
    public static final String PK_SEPARATOR = "~~";
    public static final String COLUMN_SYNCHRONIZATION_STATUS = "synchronization_status";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_REMOTE_ID = "remote_id";
    public static final String COLUMN_UPDATE_DATE = "update_date";
    public static final String SEQUENCE_SUFFIX = "_seq";
    public static Set<String> PROTECTED_COLUMN_NAMES = ImmutableSet.builder().add((Object[])new String[]{"remote_id", "synchronization_status"}).build();
    private static Field delegateTableMetadataColumnsField = null;
    protected final String selectPrimaryKeysAsStringQuery;
    protected final String selectPrimaryKeysQuery;
    protected final String selectMaxUpdateDateQuery;
    protected final String countQuery;
    protected final TableMetadata delegate;
    protected final Map<String, SynchroColumnMetadata> columns;
    protected List<SynchroJoinMetadata> childJoins;
    protected List<SynchroJoinMetadata> parentJoins;
    protected List<SynchroJoinMetadata> joins;
    protected boolean hasJoins;
    protected boolean hasChildJoins;
    protected final List<String> protectedColumnNames;
    protected final List<String> columnNames;
    protected final Set<String> pkNames;
    protected final int[] pkIndexs;
    protected String insertQuery;
    protected String insertWithGeneratedIdQuery;
    protected String updateQuery;
    protected final boolean withUpdateDateColumn;
    protected final boolean withSynchronizationStatusColumn;
    protected final boolean withIdColumn;
    protected final boolean withRemoteIdColumn;
    protected boolean isRoot;
    protected final String countDataToUpdateQuery;
    protected final String selectDataToUpdateQuery;
    protected final String sequenceName;
    protected final String selectSequenceNextValueString;
    protected final String sequenceNextValString;
    protected final String selectAllQuery;
    protected final String selectDataQueryFromPk;
    protected final String selectIdFromRemoteIdQuery;
    protected final String selectRemoteIdsQuery;
    protected List<SynchroInterceptor> interceptors;
    protected final SynchroContext context;
    protected TableInsertStrategy insertStrategy;
    protected final SynchroDatabaseMetadata dbMeta;

    public static Map<String, ColumnMetadata> getColumns(TableMetadata delegate) {
        try {
            if (delegateTableMetadataColumnsField == null) {
                delegateTableMetadataColumnsField = TableMetadata.class.getDeclaredField("columns");
                delegateTableMetadataColumnsField.setAccessible(true);
            }
            return Maps.newLinkedHashMap((Map)((Map)delegateTableMetadataColumnsField.get(delegate)));
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(e.getMessage(), e);
        }
    }

    protected SynchroTableMetadata(SynchroDatabaseMetadata dbMeta, TableMetadata delegate, List<SynchroInterceptor> interceptors, String tableName, Set<String> availableSequences, Predicate<SynchroColumnMetadata> columnFilter) {
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)dbMeta);
        this.delegate = delegate;
        this.interceptors = interceptors != null ? interceptors : Lists.newArrayList();
        this.dbMeta = dbMeta;
        this.context = dbMeta.getContext();
        try {
            this.columns = this.initColumns(tableName, dbMeta, columnFilter);
            this.columnNames = this.initColumnNames(this.columns);
            this.protectedColumnNames = this.initProtectedColumnNames(this.columns);
            this.pkNames = this.initPrimaryKeys(dbMeta);
            Preconditions.checkNotNull(this.pkNames);
            this.joins = Lists.newArrayList();
            this.hasJoins = !this.joins.isEmpty();
            this.withUpdateDateColumn = this.columnNames.contains(COLUMN_UPDATE_DATE);
            this.withSynchronizationStatusColumn = this.protectedColumnNames.contains(COLUMN_SYNCHRONIZATION_STATUS);
            this.withIdColumn = this.columnNames.contains(COLUMN_ID);
            this.withRemoteIdColumn = this.protectedColumnNames.contains(COLUMN_REMOTE_ID);
            this.sequenceName = this.initSequenceName(availableSequences);
            Preconditions.checkArgument((!this.withRemoteIdColumn || this.sequenceName != null ? 1 : 0) != 0, (Object)String.format("Columns %s and %s found on table %s, but unable to retrieve a sequence !", COLUMN_REMOTE_ID, COLUMN_ID, tableName));
            Preconditions.checkArgument((!this.withRemoteIdColumn || this.pkNames.size() == 1 && this.withIdColumn ? 1 : 0) != 0, (Object)String.format("Columns %s found on table %s, but more than one PK columns exists. Only %s column must be a PK.", COLUMN_REMOTE_ID, tableName, COLUMN_ID));
            this.isRoot = false;
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.persistence.tableMetadata.instanciation.error", (Object[])new Object[]{this}), e);
        }
        this.pkIndexs = this.createPkIndex();
        this.selectSequenceNextValueString = this.createSelectSequenceNextValString(dbMeta.getDialect());
        this.sequenceNextValString = this.createSequenceNextValString(dbMeta.getDialect());
        this.insertQuery = this.createInsertQuery();
        this.insertWithGeneratedIdQuery = this.createInsertWithGeneratedIdQuery();
        this.updateQuery = this.createUpdateQuery();
        this.selectMaxUpdateDateQuery = this.createSelectMaxUpdateDateQuery();
        this.selectPrimaryKeysAsStringQuery = this.createSelectPrimaryKeysAsStringQuery();
        this.selectPrimaryKeysQuery = this.createSelectPrimaryKeysQuery();
        this.selectRemoteIdsQuery = this.createSelectRemoteIdsQuery();
        this.selectAllQuery = this.createSelectAllQuery();
        this.selectDataQueryFromPk = this.createSelectDataFromPkQuery();
        this.selectDataToUpdateQuery = this.createSelectDataToUpdateQuery();
        this.selectIdFromRemoteIdQuery = this.createSelectIdFromRemoteIdQuery();
        this.countQuery = this.createCountQuery();
        this.countDataToUpdateQuery = this.createCountDataToUpdateQuery();
        this.insertStrategy = TableInsertStrategy.INLINE_INSERT;
    }

    SynchroTableMetadata() {
        this.delegate = null;
        this.context = null;
        this.dbMeta = null;
        this.columns = null;
        this.columnNames = null;
        this.protectedColumnNames = null;
        this.joins = null;
        this.pkNames = null;
        this.pkIndexs = null;
        this.withUpdateDateColumn = false;
        this.withSynchronizationStatusColumn = false;
        this.withIdColumn = false;
        this.withRemoteIdColumn = false;
        this.isRoot = false;
        this.insertQuery = null;
        this.insertWithGeneratedIdQuery = null;
        this.updateQuery = null;
        this.countQuery = null;
        this.countDataToUpdateQuery = null;
        this.selectPrimaryKeysAsStringQuery = null;
        this.selectPrimaryKeysQuery = null;
        this.selectRemoteIdsQuery = null;
        this.selectMaxUpdateDateQuery = null;
        this.selectDataToUpdateQuery = null;
        this.selectIdFromRemoteIdQuery = null;
        this.selectSequenceNextValueString = null;
        this.sequenceNextValString = null;
        this.sequenceName = null;
        this.selectAllQuery = null;
        this.selectDataQueryFromPk = null;
    }

    public void initJoins(SynchroDatabaseMetadata dbMeta) {
        try {
            this.joins = this.initJoins(this.getName(), dbMeta, this.columns, this.interceptors);
            this.hasJoins = !this.joins.isEmpty();
            this.childJoins = this.initChildJoins(this.joins);
            this.parentJoins = this.initParentJoins(this.joins);
            this.hasChildJoins = !this.childJoins.isEmpty();
            this.insertQuery = this.createInsertQuery();
            this.insertStrategy = !this.hasJoins || !this.withRemoteIdColumn ? TableInsertStrategy.INLINE_INSERT : TableInsertStrategy.GENERATE_ID_FIRST;
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.persistence.tableMetadata.instanciation.error", (Object[])new Object[]{this}), e);
        }
    }

    public Set<String> getPkNames() {
        return this.pkNames;
    }

    public boolean isWithUpdateDateColumn() {
        return this.withUpdateDateColumn;
    }

    public boolean isWithSynchronizationStatusColumn() {
        return this.withSynchronizationStatusColumn;
    }

    public boolean isWithIdColumn() {
        return this.withIdColumn;
    }

    public boolean isWithRemoteIdColumn() {
        return this.withRemoteIdColumn;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public int getColumnsCount() {
        return this.columnNames.size();
    }

    public Set<String> getColumnNames() {
        return ImmutableSet.copyOf(this.columnNames);
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex);
    }

    public int getColumnIndex(String name) {
        return this.columnNames.indexOf(name.toLowerCase());
    }

    public TableMetadata getDelegate() {
        return this.delegate;
    }

    public SynchroDatabaseMetadata getDatabaseMetadata() {
        return this.dbMeta;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public ForeignKeyMetadata getForeignKeyMetadata(ForeignKey fk) {
        return this.delegate.getForeignKeyMetadata(fk);
    }

    public SynchroColumnMetadata getColumnMetadata(String columnName) {
        return this.columns.get(StringHelper.toLowerCase((String)columnName));
    }

    public String getSchema() {
        return this.delegate.getSchema();
    }

    public String getCatalog() {
        return this.delegate.getCatalog();
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String keyName) {
        return this.delegate.getForeignKeyMetadata(keyName);
    }

    public IndexMetadata getIndexMetadata(String indexName) {
        return this.delegate.getIndexMetadata(indexName);
    }

    public SynchroColumnMetadata getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public List<SynchroJoinMetadata> getJoins() {
        return this.joins;
    }

    public List<SynchroJoinMetadata> getChildJoins() {
        return this.childJoins;
    }

    public List<SynchroJoinMetadata> getParentJoins() {
        return this.parentJoins;
    }

    public boolean hasJoins() {
        return this.hasJoins;
    }

    public boolean hasChildJoins() {
        return this.hasChildJoins;
    }

    public String getTableLogPrefix() {
        return "[" + this.getName() + "]";
    }

    public TableInsertStrategy getInsertStrategy() {
        return this.insertStrategy;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String getInsertQuery() {
        return this.insertQuery;
    }

    public String getInsertWithGeneratedIdQuery() {
        return this.insertWithGeneratedIdQuery;
    }

    public String getUpdateQuery() {
        return this.updateQuery;
    }

    public String getUpdateQueryForColumn(String columnName, String referenceTableName) {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        SynchroTableMetadata referenceTable = null;
        if (referenceTableName != null) {
            referenceTable = this.dbMeta.getTable(referenceTableName);
        }
        String result = null;
        result = referenceTable != null && referenceTable.isWithRemoteIdColumn() ? String.format("UPDATE %s SET %s = (SELECT %s FROM %s WHERE %s=?) WHERE %s", this.getName(), columnName, COLUMN_ID, referenceTableName, COLUMN_REMOTE_ID, this.createPkWhereClause()) : String.format("UPDATE %s SET %s = ? WHERE %s", this.getName(), columnName, this.createPkWhereClause());
        return result;
    }

    public String getSelectPrimaryKeysAsStringQuery() {
        return this.selectPrimaryKeysAsStringQuery;
    }

    public String getSelectPrimaryKeysQuery() {
        return this.selectPrimaryKeysQuery;
    }

    public String getSelectRemoteIdsQuery() {
        return this.selectRemoteIdsQuery;
    }

    public String getSequenceNextValString() {
        return this.sequenceNextValString;
    }

    public String getSelectMaxUpdateDateQuery() {
        return this.selectMaxUpdateDateQuery;
    }

    public String getSelectDataQueryFromPk() {
        return this.selectDataQueryFromPk;
    }

    public String getSelectDataToUpdateQuery(Date fromDate) {
        String sql = fromDate == null ? this.selectAllQuery : this.selectDataToUpdateQuery;
        return sql;
    }

    public String getSelectDataByColumnQuery(String columnName, int nbValues) {
        String sql = this.createSelectDataByColumnQuery(columnName.toLowerCase());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nbValues; ++i) {
            builder.append(",?");
        }
        return String.format(sql, builder.substring(1));
    }

    public String getCountQuery() {
        return this.countQuery;
    }

    public String getCountDataToUpdateQuery(Date fromDate) {
        String sql = fromDate == null ? this.countQuery : this.countDataToUpdateQuery;
        return sql;
    }

    public String getSelectIdFromRemoteIdQuery(String tableName) {
        return String.format(this.selectIdFromRemoteIdQuery, tableName);
    }

    public Object[] getData(ResultSet incomingData) throws SQLException {
        Object[] result = new Object[this.columnNames.size()];
        for (int c = 1; c <= this.columnNames.size(); ++c) {
            Object object;
            result[c - 1] = object = this.getObject(incomingData, c);
        }
        return result;
    }

    public Object getObject(ResultSet incomingData, int index) throws SQLException {
        Object object = incomingData.getObject(index);
        if (object instanceof TIMESTAMP) {
            object = ((TIMESTAMP)object).timestampValue();
        }
        if (object instanceof BigDecimal) {
            object = ((BigDecimal)object).intValue();
        }
        return object;
    }

    public int[] getPkIndexs() {
        return this.pkIndexs;
    }

    public boolean isSimpleKey() {
        return this.pkIndexs.length == 1;
    }

    public List<Object> getPk(ResultSet incomingData) throws SQLException {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.pkIndexs.length);
        for (int pkIndex : this.pkIndexs) {
            Object pk = this.getObject(incomingData, pkIndex);
            result.add(pk);
        }
        return result;
    }

    public boolean isSelectPrimaryKeysAsStringQueryEnable() {
        return this.selectPrimaryKeysAsStringQuery != null;
    }

    public List<Object> getPk(Object[] incomingData) throws SQLException {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.pkIndexs.length);
        for (int pkIndex : this.pkIndexs) {
            Object pk = incomingData[pkIndex - 1];
            result.add(pk);
        }
        return result;
    }

    public Integer getId(ResultSet incomingData) throws SQLException {
        return incomingData.getInt(this.pkIndexs[0]);
    }

    public String toPkStr(List<Object> pkList) {
        StringBuilder sb = new StringBuilder();
        for (Object pk : pkList) {
            sb.append(PK_SEPARATOR).append(pk);
        }
        return sb.substring(PK_SEPARATOR.length());
    }

    public List<Object> fromPkStr(String pk) {
        String[] split;
        ArrayList pkList = Lists.newArrayList();
        for (String s : split = pk.split(PK_SEPARATOR)) {
            if ("null".equals(s)) {
                s = null;
            }
            pkList.add(s);
        }
        return pkList;
    }

    protected Map<String, SynchroColumnMetadata> initColumns(String tableName, SynchroDatabaseMetadata dbMeta, Predicate<SynchroColumnMetadata> columnFilter) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Map<String, ColumnMetadata> delegateColumns = SynchroTableMetadata.getColumns(this.delegate);
        HashMap columns = Maps.newHashMap();
        int columnIndex = 1;
        for (String columnName : delegateColumns.keySet()) {
            ColumnMetadata delegateColumn = delegateColumns.get(columnName);
            SynchroColumnMetadata column = new SynchroColumnMetadata(delegateColumn, tableName, columnIndex, PROTECTED_COLUMN_NAMES.contains(columnName));
            if (columnFilter != null && !columnFilter.apply((Object)column)) continue;
            columns.put(columnName, column);
            ++columnIndex;
        }
        return columns;
    }

    protected List<String> initProtectedColumnNames(Map<String, SynchroColumnMetadata> columns) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)PROTECTED_COLUMN_NAMES.size());
        for (String name : columns.keySet()) {
            if (!PROTECTED_COLUMN_NAMES.contains(name.toLowerCase())) continue;
            result.add(name.toLowerCase());
        }
        return result;
    }

    protected List<String> initColumnNames(Map<String, SynchroColumnMetadata> columns) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)columns.size());
        for (String name : columns.keySet()) {
            if (PROTECTED_COLUMN_NAMES.contains(name.toLowerCase())) continue;
            result.add(name.toLowerCase());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> initPrimaryKeys(SynchroDatabaseMetadata dbMeta) throws SQLException {
        LinkedHashSet result = Sets.newLinkedHashSet();
        ResultSet rs = dbMeta.getPrimaryKeys(this.getCatalog(), this.getSchema(), this.getName());
        try {
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME").toLowerCase());
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)result);
            return immutableSet;
        }
        finally {
            DaoUtils.closeSilently(rs);
        }
    }

    protected int[] createPkIndex() {
        int[] result = new int[this.pkNames.size()];
        int pkI = 0;
        for (String pkName : this.pkNames) {
            String pkColumnName = pkName.toLowerCase();
            int i = 1;
            int index = -1;
            for (String columnName : this.columnNames) {
                if (pkColumnName.equals(columnName)) {
                    index = i;
                    continue;
                }
                ++i;
            }
            result[pkI++] = index;
        }
        return result;
    }

    protected List<SynchroJoinMetadata> initJoins(String tableName, SynchroDatabaseMetadata dbMeta, Map<String, SynchroColumnMetadata> columns, List<SynchroInterceptor> interceptors) throws SQLException {
        SynchroColumnMetadata column;
        SynchroJoinMetadata join;
        String columnName;
        ArrayList result = Lists.newArrayList();
        ResultSet rs = dbMeta.getExportedKeys(this.delegate.getCatalog(), this.delegate.getSchema(), tableName);
        while (rs.next()) {
            columnName = rs.getString("PKCOLUMN_NAME").toLowerCase();
            if (!columns.containsKey(columnName)) continue;
            join = new SynchroJoinMetadata(rs, this, dbMeta);
            this.fireOnJoinLoad(join);
            if (!join.isValid()) continue;
            result.add(join);
            column = columns.get(columnName);
        }
        rs = dbMeta.getImportedKeys(this.delegate.getCatalog(), this.delegate.getSchema(), tableName);
        while (rs.next()) {
            columnName = rs.getString("FKCOLUMN_NAME").toLowerCase();
            if (!columns.containsKey(columnName)) continue;
            join = new SynchroJoinMetadata(rs, this, dbMeta);
            this.fireOnJoinLoad(join);
            if (!join.isValid()) continue;
            result.add(join);
            column = columns.get(columnName);
            column.setParentJoin(join);
        }
        return result;
    }

    protected List<SynchroJoinMetadata> initChildJoins(List<SynchroJoinMetadata> joins) throws SQLException {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)joins.size());
        for (SynchroJoinMetadata join : joins) {
            if (!join.isChild()) continue;
            result.add(join);
        }
        return result;
    }

    protected List<SynchroJoinMetadata> initParentJoins(List<SynchroJoinMetadata> joins) throws SQLException {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)joins.size());
        for (SynchroJoinMetadata join : joins) {
            if (join.isChild()) continue;
            result.add(join);
        }
        return result;
    }

    protected String createInsertQuery() {
        return this.createInsertQuery(false);
    }

    protected String createInsertWithGeneratedIdQuery() {
        if (!this.withRemoteIdColumn) {
            return null;
        }
        return this.createInsertQuery(true);
    }

    protected String createInsertQuery(boolean generateId) {
        if (CollectionUtils.isEmpty(this.columnNames)) {
            return null;
        }
        StringBuilder queryParams = new StringBuilder();
        StringBuilder valueParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            if (this.withRemoteIdColumn && COLUMN_ID.equals(columnName)) {
                queryParams.append(", ").append(COLUMN_REMOTE_ID);
            } else {
                queryParams.append(", ").append(columnName);
            }
            valueParams.append(", ?");
        }
        if (this.withRemoteIdColumn) {
            queryParams.append(", ").append(COLUMN_ID);
            if (generateId) {
                valueParams.append(", ").append(this.selectSequenceNextValueString);
            } else {
                valueParams.append(", ?");
            }
        }
        if (this.withSynchronizationStatusColumn) {
            queryParams.append(", ").append(COLUMN_SYNCHRONIZATION_STATUS);
            valueParams.append(", '").append(SynchroConfiguration.getInstance().getSynchronizationStatusSynchronized()).append("'");
        }
        String result = String.format("INSERT INTO %s (%s) VALUES (%s)", this.getName(), queryParams.substring(2), valueParams.substring(2));
        return result;
    }

    protected String createUpdateQuery() {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.columnNames)) {
            return null;
        }
        StringBuilder updateParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            if (this.withRemoteIdColumn && COLUMN_ID.equals(columnName)) {
                updateParams.append(", ").append(COLUMN_REMOTE_ID);
            } else {
                updateParams.append(", ").append(columnName);
            }
            updateParams.append(" = ?");
        }
        if (this.withSynchronizationStatusColumn) {
            updateParams.append(", ").append(COLUMN_SYNCHRONIZATION_STATUS).append(" = '").append(SynchroConfiguration.getInstance().getSynchronizationStatusSynchronized()).append("'");
        }
        String result = String.format("UPDATE %s SET %s WHERE %s", this.getName(), updateParams.substring(2), this.createPkWhereClause());
        return result;
    }

    protected String createSelectDataFromPkQuery() {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        String sql = String.format("SELECT %s FROM %s WHERE %s", this.createSelectParams(), this.getName(), this.createPkWhereClause());
        sql = this.fireOnCreateSelectQuery("selectDataFromPkQuery", sql);
        return sql;
    }

    protected String createSelectPrimaryKeysAsStringQuery() {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        String prefix = " || '~~' || ";
        StringBuilder pkParams = new StringBuilder();
        boolean allowUniqueOutputColumn = true;
        for (String columnName : this.pkNames) {
            SynchroColumnMetadata column = this.columns.get(columnName);
            if (column.getTypeCode() == 93 || column.getTypeCode() == 91) {
                allowUniqueOutputColumn = false;
            }
            pkParams.append(prefix).append(columnName);
        }
        if (!allowUniqueOutputColumn) {
            return null;
        }
        String sql = String.format("SELECT %s FROM %s", pkParams.substring(prefix.length()), this.getName());
        sql = this.fireOnCreateSelectQuery("selectPrimaryKeysAsStringQuery", sql);
        return sql;
    }

    protected String createSelectPrimaryKeysQuery() {
        if (CollectionUtils.isEmpty(this.pkNames)) {
            return null;
        }
        StringBuilder pkParams = new StringBuilder();
        for (String columnName : this.pkNames) {
            pkParams.append(", ").append(columnName);
        }
        String sql = String.format("SELECT %s FROM %s", pkParams.substring(2), this.getName());
        sql = this.fireOnCreateSelectQuery("selectPrimaryKeysQuery", sql);
        return sql;
    }

    protected String createSelectRemoteIdsQuery() {
        if (!this.withRemoteIdColumn || !this.withIdColumn) {
            return null;
        }
        String sql = String.format("SELECT %s, %s FROM %s WHERE %s IS NOT NULL", COLUMN_ID, COLUMN_REMOTE_ID, this.getName(), COLUMN_REMOTE_ID);
        sql = this.fireOnCreateSelectQuery("selectRemoteIdsQuery", sql);
        return sql;
    }

    protected String createSelectAllQuery() {
        String sql = String.format("SELECT %s FROM %s t", this.createSelectParams("t"), this.getName());
        sql = this.fireOnCreateSelectQuery("selectAllQuery", sql);
        return sql;
    }

    protected String createSelectMaxUpdateDateQuery() {
        if (!this.withUpdateDateColumn) {
            return null;
        }
        String sql = String.format("SELECT max(%s) FROM %s", COLUMN_UPDATE_DATE, this.getName());
        sql = this.fireOnCreateSelectQuery("selectMaxUpdateDateQuery", sql);
        return sql;
    }

    protected String createSelectDataToUpdateQuery() {
        String sql = String.format("SELECT %s FROM %s t%s", this.createSelectParams("t"), this.getName(), this.createWithUpdateDateWhereClause("t"));
        sql = this.fireOnCreateSelectQuery("selectDataToUpdateQuery", sql);
        return sql;
    }

    protected String createCountQuery() {
        String sql = String.format("SELECT count(*) FROM %s t", this.getName());
        sql = this.fireOnCreateSelectQuery("countQuery", sql);
        return sql;
    }

    protected String createSelectIdFromRemoteIdQuery() {
        if (!this.withIdColumn || this.withRemoteIdColumn) {
            return null;
        }
        String sql = String.format("SELECT %s FROM %s WHERE %s=?", COLUMN_ID, "%s", COLUMN_REMOTE_ID);
        sql = this.fireOnCreateSelectQuery("selectIdFromRemoteIdQuery", sql);
        return sql;
    }

    protected String createCountDataToUpdateQuery() {
        String sql = String.format("SELECT count(*) FROM %s t%s", this.getName(), this.createWithUpdateDateWhereClause("t"));
        sql = this.fireOnCreateSelectQuery("countDataToUpdateQuery", sql);
        return sql;
    }

    protected String createPkWhereClause() {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.pkNames));
        StringBuilder pkParams = new StringBuilder();
        for (String columnName : this.pkNames) {
            pkParams.append("AND ").append(columnName).append(" = ?");
        }
        return pkParams.substring(4);
    }

    protected String createWithUpdateDateWhereClause() {
        return this.createWithUpdateDateWhereClause(null);
    }

    protected String createWithUpdateDateWhereClause(String tableAlias) {
        String whereClause;
        if (this.isWithUpdateDateColumn()) {
            String prefix = tableAlias != null ? tableAlias + "." : "";
            whereClause = String.format(" WHERE (%supdate_date IS NULL OR %supdate_date > ?)", prefix, prefix);
        } else {
            whereClause = "";
        }
        return whereClause;
    }

    protected String createSelectParams() {
        return this.createSelectParams(null);
    }

    public String createSelectParams(String tableAlias) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.columnNames), (Object)String.format("No column found for table: %s", this.delegate.getName()));
        StringBuilder queryParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            queryParams.append(", ");
            if (tableAlias != null) {
                queryParams.append(tableAlias).append(".");
            }
            queryParams.append(columnName);
        }
        return queryParams.substring(2);
    }

    protected String createSelectDataByColumnQuery(String columnName) {
        String sql = String.format("SELECT %s FROM %s WHERE %s IN (%s)", this.createSelectParams("t"), this.getName(), columnName, "%s");
        sql = this.fireOnCreateSelectQuery("selectDataByColumn", sql);
        return sql;
    }

    public String getSelectDataByColumnUsingTempParameterTableQuery(String columnName) {
        String sql = String.format("SELECT %s FROM %s t INNER JOIN TEMP_QUERY_PARAMETER p on t.%s = p.ALPHANUMERICAL_VALUE AND p.PARAMETER_NAME=? AND p.PERSON_FK=?", this.createSelectParams("t"), this.getName(), columnName);
        sql = this.fireOnCreateSelectQuery("selectDataByColumnUsingTempParameterTable", sql);
        return sql;
    }

    public String getSelectDataByColumnsUsingTempParameterTableQuery(Set<String> columnNames, String queryParameterName) {
        StringBuilder sb = new StringBuilder(String.format("SELECT %s FROM %s", this.createSelectParams("t"), this.getName()));
        int index = 0;
        for (String columnName : columnNames) {
            String alias = "tqp_" + index;
            sb.append(String.format(" INNER JOIN TEMP_QUERY_PARAMETER %s", alias));
            sb.append(String.format(" ON %s.alphanumerical_value=t.%s", alias, columnName));
            sb.append(String.format(" AND %s.parameter_name='%s_%s'", alias, queryParameterName, index));
            if (index > 0) {
                sb.append(String.format(" AND %s.numerical_value=tqp_0.numerical_value", alias));
            }
            ++index;
        }
        String sql = this.fireOnCreateSelectQuery("selectDataByColumnsUsingTempParameterTable", sb.toString());
        return sql;
    }

    protected String initSequenceName(Set<String> availableSequences) {
        String tableName = this.getName().toLowerCase();
        String sequenceName = tableName + SEQUENCE_SUFFIX;
        if (availableSequences.contains(sequenceName.toLowerCase())) {
            return sequenceName;
        }
        int maxLengthWithoutSuffix = 30 - SEQUENCE_SUFFIX.length();
        if (tableName.length() > maxLengthWithoutSuffix && availableSequences.contains((sequenceName = tableName.substring(0, maxLengthWithoutSuffix) + SEQUENCE_SUFFIX).toLowerCase())) {
            return sequenceName;
        }
        return null;
    }

    public void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    protected String createSelectSequenceNextValString(Dialect dialect) {
        if (StringUtils.isBlank((CharSequence)this.sequenceName)) {
            return null;
        }
        return dialect.getSelectSequenceNextValString(this.sequenceName);
    }

    protected String createSequenceNextValString(Dialect dialect) {
        if (StringUtils.isBlank((CharSequence)this.sequenceName)) {
            return null;
        }
        return dialect.getSequenceNextValString(this.sequenceName);
    }

    public List<SynchroInterceptor> getInterceptors() {
        return this.interceptors;
    }

    protected String fireOnCreateSelectQuery(String queryName, String sql) {
        if (CollectionUtils.isNotEmpty(this.interceptors)) {
            for (SynchroInterceptor interceptor : this.interceptors) {
                String newSql = interceptor.onCreateSelectQuery(this, queryName, sql);
                if (newSql == null) continue;
                sql = newSql;
            }
        }
        return sql;
    }

    protected void fireOnJoinLoad(SynchroJoinMetadata join) {
        if (CollectionUtils.isNotEmpty(this.interceptors)) {
            ArrayList interceptorsCopy = Lists.newArrayList(this.interceptors);
            for (SynchroInterceptor interceptor : interceptorsCopy) {
                interceptor.onJoinLoad(this, join);
            }
        }
    }

    public static enum TableInsertStrategy {
        GENERATE_ID_FIRST,
        INLINE_INSERT;

    }
}

