/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class SynchroMetadataUtils {
    public static final List<String> ORACLE_EXCLUDE_TABLE_PATTERNS = Lists.newArrayList((Object[])new String[]{"BIN%", "MDR%"});

    protected SynchroMetadataUtils() {
    }

    public static Predicate<String> newAllTablesOraclePredicate() {
        return SynchroMetadataUtils.newTablesOraclePredicate(null, null);
    }

    public static Predicate<String> newTablesOraclePredicate(Set<String> excludes, Set<String> includes) {
        HashSet excludesPatterns = Sets.newHashSet(ORACLE_EXCLUDE_TABLE_PATTERNS);
        if (CollectionUtils.isNotEmpty(excludes)) {
            excludesPatterns.addAll(excludes);
        }
        return SynchroMetadataUtils.newTablePredicate(excludesPatterns, includes);
    }

    public static Predicate<String> newTablePredicate(final Set<String> excludes, final Set<String> includes) {
        if (CollectionUtils.isEmpty(excludes) && CollectionUtils.isEmpty(includes)) {
            return null;
        }
        return new Predicate<String>(){

            public boolean apply(String tableName) {
                if (CollectionUtils.isNotEmpty((Collection)excludes)) {
                    for (String excludePattern : excludes) {
                        if (!tableName.matches(excludePattern.replaceAll("%", ".*"))) continue;
                        return false;
                    }
                }
                if (CollectionUtils.isEmpty((Collection)includes)) {
                    return true;
                }
                for (String includePattern : includes) {
                    if (!tableName.matches(includePattern.replaceAll("%", ".*"))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<SynchroColumnMetadata> newExcludeColumnPredicate(final Map<String, Set<String>> excludeColumnNamesMap) {
        Preconditions.checkNotNull(excludeColumnNamesMap);
        Preconditions.checkArgument((!excludeColumnNamesMap.isEmpty() ? 1 : 0) != 0);
        return new Predicate<SynchroColumnMetadata>(){

            public boolean apply(SynchroColumnMetadata input) {
                Set excludeColumnNames = (Set)excludeColumnNamesMap.get(input.getTableName());
                return CollectionUtils.isEmpty((Collection)excludeColumnNames) || !excludeColumnNames.contains(input.getName().toLowerCase());
            }
        };
    }

    public static void checkType(String tableName, SynchroColumnMetadata internalColumn, SynchroColumnMetadata externalColumn) {
        if (SynchroMetadataUtils.isNumericType(internalColumn) && SynchroMetadataUtils.isNumericType(externalColumn)) {
            int internalColumnSize = internalColumn.getColumnSize();
            int externalColumnSize = externalColumn.getColumnSize();
            if (internalColumnSize > 0 && externalColumnSize > 0 && internalColumnSize < externalColumnSize) {
                throw new SynchroTechnicalException(String.format("Incompatible column type of table / column: %s / %s", tableName, internalColumn.getName()));
            }
            int internalDecimalDigits = internalColumn.getDecimalDigits();
            int externalDecimalDigits = externalColumn.getDecimalDigits();
            if (internalDecimalDigits > 0 && externalDecimalDigits > 0 && internalDecimalDigits < externalDecimalDigits) {
                throw new SynchroTechnicalException(String.format("Incompatible column type of table / column: %s / %s", tableName, internalColumn.getName()));
            }
        } else if (!(SynchroMetadataUtils.isDateType(internalColumn) && SynchroMetadataUtils.isDateType(externalColumn) || SynchroMetadataUtils.isBooleanType(internalColumn) && SynchroMetadataUtils.isBooleanType(externalColumn))) {
            int externalColumnTypeCode;
            String internalColumnTypeName = internalColumn.getTypeName();
            String externalColumnTypeName = externalColumn.getTypeName();
            int internalColumnTypeCode = internalColumn.getTypeCode();
            if (internalColumnTypeCode != (externalColumnTypeCode = externalColumn.getTypeCode()) && !internalColumnTypeName.equals(externalColumnTypeName)) {
                throw new SynchroTechnicalException(String.format("Incompatible column type of table / column: %s / %s", tableName, internalColumn.getName()));
            }
        }
    }

    protected static boolean isNumericType(SynchroColumnMetadata column) {
        int typeCode = column.getTypeCode();
        if (typeCode == -5 || typeCode == 4 || typeCode == 2 || typeCode == 3 || typeCode == 6 || typeCode == 7 || typeCode == 5 || typeCode == -6 || typeCode == 8) {
            return true;
        }
        String columnTypeName = column.getTypeName();
        return columnTypeName.equals("NUMBER") || columnTypeName.equals("INTEGER") || columnTypeName.equals("SMALLINT");
    }

    protected static boolean isDateType(SynchroColumnMetadata column) {
        String columnTypeName = column.getTypeName();
        return columnTypeName.equals("TIMESTAMP") || columnTypeName.equals("DATE");
    }

    protected static boolean isBooleanType(SynchroColumnMetadata column) {
        String columnTypeName = column.getTypeName();
        int columnSize = column.getColumnSize();
        return columnTypeName.equals("BOOLEAN") || columnTypeName.equals("NUMBER") && columnSize == 1;
    }
}

