/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.action;

import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoUtils;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroServiceImpl;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SynchroImportReferentialAction {
    private static final Log log = LogFactory.getLog(SynchroImportReferentialAction.class);

    public void run() {
        SynchroConfiguration config = SynchroConfiguration.getInstance();
        Properties sourceConnectionProperties = config.getImportConnectionProperties();
        Properties targetConnectionProperties = config.getConnectionProperties();
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting database referential importation...");
        }
        if (!this.checkConnection(config, sourceConnectionProperties, targetConnectionProperties)) {
            return;
        }
        SynchroResult result = new SynchroResult();
        Set<String> tableToIncludes = config.getImportReferentialTablesIncludes();
        SynchroContext context = SynchroContext.newContext(tableToIncludes, sourceConnectionProperties, targetConnectionProperties, result);
        ReferentialSynchroServiceImpl service = new ReferentialSynchroServiceImpl();
        service.prepare(context);
        if (!result.isSuccess()) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.prepare.error", (Object[])new Object[0]), result.getError());
        }
        service.synchronize(context);
        if (!result.isSuccess()) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.synchro.error", (Object[])new Object[0]), result.getError());
        }
        try {
            DaoUtils.shutdownDatabase(targetConnectionProperties);
        }
        catch (SQLException e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.shutdown.error", (Object[])new Object[0]), result.getError());
        }
    }

    protected boolean checkConnection(SynchroConfiguration config, Properties sourceConnectionProperties, Properties targetConnectionProperties) {
        String sourceJdbcUrl;
        boolean isValidConnection;
        if (log.isInfoEnabled()) {
            log.info((Object)"Connecting to target database...");
            log.info((Object)String.format(" Database directory: %s", config.getDbDirectory()));
            log.info((Object)String.format(" JDBC Driver: %s", config.getJdbcDriver()));
            log.info((Object)String.format(" JDBC URL: %s", config.getJdbcURL()));
            log.info((Object)String.format(" JDBC Username: %s", config.getJdbcUsername()));
        }
        if (!(isValidConnection = DaoUtils.isValidConnectionProperties(targetConnectionProperties))) {
            log.error((Object)"Connection error: could not connect to target database.");
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Connecting to source database...");
            log.info((Object)String.format(" JDBC Driver: %s", config.getImportJdbcDriver()));
            log.info((Object)String.format(" JDBC URL: %s", config.getImportJdbcURL()));
            log.info((Object)String.format(" JDBC Username: %s", config.getImportJdbcUsername()));
        }
        if (!(sourceJdbcUrl = DaoUtils.getUrl(sourceConnectionProperties)).startsWith("jdbc:oracle:")) {
            log.warn((Object)"Source database is not a Oracle database. Make sure your configuration file is correct.");
        }
        if (!(isValidConnection = DaoUtils.isValidConnectionProperties(sourceConnectionProperties))) {
            log.warn((Object)"Connection error: could not connect to source database.");
            return false;
        }
        return true;
    }
}

