/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;

public class CommandLineResourceAccessor
implements ResourceAccessor {
    private ClassLoader loader;

    public CommandLineResourceAccessor(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        URL resource = this.loader.getResource(file);
        if (resource == null) {
            if (file.startsWith("/")) {
                resource = this.loader.getResource(file.substring(1));
            }
            if (resource == null) {
                return null;
            }
        }
        return resource.openStream();
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        return this.loader.getResources(packageName);
    }

    @Override
    public ClassLoader toClassLoader() {
        return this.loader;
    }

    public String toString() {
        String description;
        if (this.loader instanceof URLClassLoader) {
            ArrayList<String> urls = new ArrayList<String>();
            URL[] uRLArray = ((URLClassLoader)this.loader).getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                urls.add(url.toExternalForm());
                ++n2;
            }
            description = StringUtils.join(urls, ",");
        } else {
            description = this.loader.getClass().getName();
        }
        return String.valueOf(this.getClass().getName()) + "(" + description + ")";
    }
}

