/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;

public class CompoundExpression
extends SpelNodeImpl {
    public CompoundExpression(int pos, SpelNodeImpl ... expressionComponents) {
        super(pos, expressionComponents);
        if (expressionComponents.length < 2) {
            throw new IllegalStateException("Dont build compound expression less than one entry: " + expressionComponents.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        if (this.getChildCount() == 1) {
            return this.children[0].getValueRef(state);
        }
        TypedValue result = null;
        SpelNodeImpl nextNode = null;
        nextNode = this.children[0];
        result = nextNode.getValueInternal(state);
        int cc = this.getChildCount();
        for (int i = 1; i < cc - 1; ++i) {
            try {
                state.pushActiveContextObject(result);
                nextNode = this.children[i];
                result = nextNode.getValueInternal(state);
                continue;
            }
            finally {
                state.popActiveContextObject();
            }
        }
        try {
            state.pushActiveContextObject(result);
            nextNode = this.children[cc - 1];
            ValueRef valueRef = nextNode.getValueRef(state);
            state.popActiveContextObject();
            return valueRef;
        }
        catch (Throwable throwable) {
            try {
                state.popActiveContextObject();
                throw throwable;
            }
            catch (SpelEvaluationException ee) {
                ee.setPosition(nextNode.getStartPosition());
                throw ee;
            }
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state).getValue();
    }

    @Override
    public void setValue(ExpressionState state, Object value) throws EvaluationException {
        this.getValueRef(state).setValue(value);
    }

    @Override
    public boolean isWritable(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state).isWritable();
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(this.getChild(i).toStringAST());
        }
        return sb.toString();
    }
}

