/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatiblePropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.xml.sax.SAXException;

public class Base64PropertyState
extends CompatiblePropertyState {
    private Base64 base = new Base64();
    private final String charSet;

    Base64PropertyState(ModuleParserHandler theHandler, DesignElement element, String charSet) {
        super(theHandler, element);
        assert (charSet != null);
        this.charSet = charSet;
    }

    Base64PropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct, String charSet) {
        super(theHandler, element, propDefn, struct);
        assert (charSet != null);
        this.charSet = charSet;
    }

    @Override
    public void end() throws SAXException {
        String value = this.text.toString();
        value = this.getDecodedBase64Value(value);
        super.doEnd(value);
    }

    private String getDecodedBase64Value(String value) {
        byte[] data;
        block5: {
            String encodedValue = StringUtil.trimString(value);
            if (encodedValue == null) {
                return null;
            }
            Pattern p = Pattern.compile("\\s");
            Matcher m = p.matcher(encodedValue);
            encodedValue = m.replaceAll("");
            data = null;
            try {
                data = this.base.decode(encodedValue.getBytes(this.charSet));
                if (data != null) break block5;
                return null;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                assert (false);
                return null;
            }
        }
        return new String(data, this.charSet);
    }
}

