/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.odt;

import java.util.LinkedList;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.odf.AbstractOdfEmitterContext;
import org.eclipse.birt.report.engine.odf.OdfUtil;
import org.eclipse.birt.report.engine.odf.TableInfo;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.style.StyleManager;

public class EmitterContext
extends AbstractOdfEmitterContext {
    private LinkedList<Double> widthList = new LinkedList();
    private boolean isFirst = true;
    private boolean inMasterPage = false;

    public void startInline() {
        this.isFirst = false;
    }

    public boolean isFirstInline() {
        return this.isFirst;
    }

    public void endInline() {
        this.isFirst = true;
    }

    public void addWidth(double witdh) {
        this.widthList.addLast(witdh);
    }

    public void resetWidth() {
        this.widthList.clear();
    }

    public double getCurrentWidth() {
        return this.widthList.getLast();
    }

    public void removeWidth() {
        this.widthList.removeLast();
    }

    public double getCellWidth(int columnId, int columnSpan) {
        double[] cols = this.getCurrentTableColmns();
        double width = 0.0;
        int colNum = Math.min(columnId + columnSpan, 63);
        int i = columnId;
        while (i < colNum) {
            width += cols[i];
            ++i;
        }
        return width;
    }

    public void startMasterPage() {
        this.inMasterPage = true;
    }

    public void endMasterPage() {
        this.inMasterPage = false;
    }

    @Override
    public StyleManager getStyleManager() {
        if (this.inMasterPage) {
            return super.getGlobalStyleManager();
        }
        return super.getStyleManager();
    }

    public StyleEntry getRowHeightStyle(DimensionType rowHeight) {
        StyleEntry style = ((TableInfo)this.tables.getLast()).getRowHeightStyle(rowHeight);
        if (style == null && rowHeight != null) {
            style = StyleBuilder.createEmptyStyleEntry(4);
            style.setProperty(64, OdfUtil.convertTo(rowHeight, this.dpi));
            ((TableInfo)this.tables.getLast()).addRowHeightStyle(rowHeight, style);
        }
        return style;
    }
}

