/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;

public class PostgresTableMetaDataProvider
extends GenericTableMetaDataProvider {
    public PostgresTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        super(databaseMetaData);
    }

    @Override
    public boolean isGetGeneratedKeysSimulated() {
        if (this.getDatabaseVersion().compareTo("8.2.0") >= 0) {
            return true;
        }
        logger.warn((Object)("PostgreSQL does not support getGeneratedKeys or INSERT ... RETURNING in version " + this.getDatabaseVersion()));
        return false;
    }

    @Override
    public String getSimpleQueryForGetGeneratedKey(String tableName, String keyColumnName) {
        return "RETURNING " + keyColumnName;
    }
}

