/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorUtils;
import fr.ifremer.adagio.synchro.intercept.internal.RemoteIdWriteInterceptor;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchroBaseService {
    private static final Log log = LogFactory.getLog(SynchroBaseService.class);
    protected final SynchroConfiguration config;
    protected final int batchSize;
    protected final DataSource dataSource;
    protected List<SynchroInterceptor> daoInterceptors = null;

    public SynchroBaseService(DataSource dataSource, SynchroConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        this.dataSource = dataSource;
        this.config = config;
        this.batchSize = config.getImportJdbcBatchSize();
    }

    public SynchroBaseService() {
        this.config = SynchroConfiguration.getInstance();
        Preconditions.checkNotNull((Object)this.config, (Object)String.format("%s instance not initialized. Make sure 'setInstance()' is called first.", SynchroConfiguration.class.getName()));
        this.dataSource = null;
        this.batchSize = this.config.getImportJdbcBatchSize();
    }

    public List<SynchroInterceptor> getInterceptors(SynchroContext context) {
        if (this.daoInterceptors == null) {
            this.daoInterceptors = SynchroInterceptorUtils.load(SynchroInterceptor.class, context);
        }
        return this.daoInterceptors;
    }

    public SynchroInterceptor getInterceptor(SynchroTableMetadata table, SynchroContext context) {
        List<SynchroInterceptor> interceptors = this.getInterceptors(context);
        ArrayList filteredInterceptors = Lists.newArrayList();
        filteredInterceptors.addAll(SynchroInterceptorUtils.filter(interceptors, table.getDatabaseMetadata(), table.getDelegate()));
        if (table.hasJoins()) {
            for (SynchroJoinMetadata join : table.getJoins()) {
                if (!join.needRemoteIdInterceptor()) continue;
                String pkTableName = join.getTargetTable().getName().toLowerCase();
                String fkColumnName = join.getSourceColumn().getName().toLowerCase();
                int fkColumnIndex = join.getSourceTable().getColumnIndex(fkColumnName);
                RemoteIdWriteInterceptor remoteIdInterceptor = new RemoteIdWriteInterceptor(pkTableName, fkColumnIndex, join.getSourceColumn().isNullable());
                filteredInterceptors.add(remoteIdInterceptor);
            }
        }
        Object result = SynchroInterceptorUtils.chain(filteredInterceptors, SynchroInterceptorBase.class);
        return result;
    }

    protected void reportProgress(SynchroResult result, SynchroTableDao dao, int countR, String tablePrefix) {
        if (countR % this.batchSize == 0) {
            result.getProgressionModel().increments(this.batchSize);
        }
        if (countR % (this.batchSize * 10) == 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("%s Done: %s (inserts: %s, updates: %s)", tablePrefix, countR, dao.getInsertCount(), dao.getUpdateCount()));
        }
    }
}

