/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.hibernate;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.type.Type;
import org.springframework.dao.DataIntegrityViolationException;

public class HibernateDaoSupport {
    protected static final Log logger = LogFactory.getLog(HibernateDaoSupport.class);
    protected boolean debugEntityLoad = false;
    private SessionFactory sessionFactory;
    private Calendar calendar = new GregorianCalendar();

    public HibernateDaoSupport() {
        this.debugEntityLoad = AdagioConfiguration.getInstance().debugEntityLoad();
    }

    protected void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected Session getSession(boolean oldAPIArg) {
        return this.sessionFactory.getCurrentSession();
    }

    protected void deleteAll(Collection<?> entities) {
        Session session = this.getSession();
        for (Object entity : entities) {
            session.delete(entity);
        }
    }

    protected Object[] queryUnique(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Object result = query.uniqueResult();
        return (Object[])result;
    }

    protected <T> T queryUniqueTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Object result = query.uniqueResult();
        return (T)result;
    }

    protected Iterator<Object[]> queryIterator(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Iterator result = query.iterate();
        return result;
    }

    protected <T> Iterator<T> queryIteratorTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        Iterator result = query.iterate();
        return result;
    }

    protected List<Object[]> queryList(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        List result = query.list();
        return result;
    }

    protected <T> List<T> queryListTyped(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        List result = query.list();
        return result;
    }

    protected int queryUpdate(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        int result = query.executeUpdate();
        return result;
    }

    protected Query createQuery(String queryName, Object ... params) {
        Query query = this.getSession().getNamedQuery(queryName);
        return this.setQueryParams(query, queryName, params);
    }

    protected Query setQueryParams(Query query, String queryName, Object ... params) {
        if (params.length > 0) {
            Preconditions.checkArgument((params.length % 3 == 0 ? 1 : 0) != 0, (Object)"Params must be tuple (paramName, paramType, paramValue)");
            int nbParams = params.length / 3;
            for (int i = 0; i < nbParams; ++i) {
                String paramName = (String)params[3 * i];
                Type paramType = (Type)params[3 * i + 1];
                Object paramValue = params[3 * i + 2];
                if (paramType != null) {
                    query.setParameter(paramName, paramValue, paramType);
                } else if (paramValue instanceof Collection) {
                    query.setParameterList(paramName, (Collection)paramValue);
                } else {
                    query.setParameter(paramName, paramValue);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("query [" + queryName + "] (param " + i + " [" + paramName + '=' + paramValue + "])"));
            }
        }
        return query;
    }

    protected <T extends Serializable> T load(Class<? extends T> clazz, Serializable id) {
        Serializable load;
        if (this.debugEntityLoad && (load = (Serializable)this.getSession().get(clazz, id)) == null) {
            throw new DataIntegrityViolationException("Unable to load entity " + clazz.getName() + " with identifier '" + id + "': not found in database.");
        }
        load = (Serializable)this.getSession().load(clazz, id);
        return (T)load;
    }

    protected <T extends Serializable> T get(Class<? extends T> clazz, Serializable id) {
        Serializable load = (Serializable)this.getSession().get(clazz, id);
        return (T)load;
    }

    protected Iterator<Object[]> queryIteratorWithPage(String queryName, int pageNumber, int pageSize, String orderBy, boolean isAscending, Object ... params) {
        Query query = this.getSession().getNamedQuery(queryName);
        String queryString = query.getQueryString();
        if (orderBy != null) {
            queryString = queryString + " order by " + orderBy;
            if (!isAscending) {
                queryString = queryString + " desc";
            }
        }
        query = this.createQuery(queryString, params);
        if (pageSize != -1) {
            query.setMaxResults(pageSize);
            if (pageNumber > 1) {
                query.setMaxResults(pageSize);
                query.setFirstResult((pageNumber - 1) * pageSize);
            }
        }
        return query.iterate();
    }

    protected Date newCreateDate() {
        return this.dateWithNoTime(new Date());
    }

    protected Date dateWithNoTime(Date date) {
        this.calendar.setTime(date);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    protected Date dateWithNoMiliSecond(Date date) {
        this.calendar.setTime(date);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    protected Date dateWithNoSecondAndMiliSecond(Date date) {
        this.calendar.setTime(date);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    protected Date dateWithNoSecondAndOneMiliSecond(Date date) {
        this.calendar.setTime(date);
        this.calendar.add(13, 0);
        this.calendar.add(14, 1);
        return this.calendar.getTime();
    }

    protected Date dateWithOneMiliSecond(Date date) {
        this.calendar.setTime(date);
        this.calendar.add(14, 1);
        return this.calendar.getTime();
    }

    protected Date dateOfYearWithOneMiliSecond(int year) {
        this.calendar.setTimeInMillis(0L);
        this.calendar.set(1, year);
        this.calendar.set(14, 1);
        return this.calendar.getTime();
    }

    protected long dateOfYearWithOneMiliSecondInMili(int year) {
        this.calendar.setTimeInMillis(0L);
        this.calendar.set(1, year);
        this.calendar.set(14, 1);
        return this.calendar.getTimeInMillis();
    }

    protected Date convertDatabase2UI(Timestamp databaseValue) {
        Date result;
        if (databaseValue == null) {
            result = null;
        } else {
            this.calendar.setTimeInMillis(databaseValue.getTime());
            result = this.calendar.get(14) != 0 ? null : this.calendar.getTime();
        }
        return result;
    }

    protected Date convertUI2DatabaseMandatoryDate(Date uiValue, Date defaultNotEmptyDate, boolean addOneSecondToDefaultDate) {
        Date result;
        if (uiValue == null) {
            Preconditions.checkState((defaultNotEmptyDate != null ? 1 : 0) != 0, (Object)"'defaultNotEmptyDate' could not be null.");
            this.calendar.setTime(defaultNotEmptyDate);
            if (addOneSecondToDefaultDate) {
                this.calendar.add(13, 1);
            }
            this.calendar.set(14, 1);
            result = this.calendar.getTime();
        } else {
            result = this.dateWithNoMiliSecond(uiValue);
        }
        return result;
    }
}

